/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.StopEngine;

public class SpringStopEngine
implements StopEngine {
    double mDamping = 0.5;
    private static final double UNSET = Double.MAX_VALUE;
    private boolean mInitialized = false;
    private double mStiffness;
    private double mTargetPos;
    private double mLastVelocity;
    private float mLastTime;
    private float mPos;
    private float mV;
    private float mMass;
    private float mStopThreshold;
    private int mBoundaryMode = 0;

    @Override
    public String debug(String desc, float time) {
        return null;
    }

    void log(String str) {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        String line = ".(" + s.getFileName() + ":" + s.getLineNumber() + ") " + s.getMethodName() + "() ";
        System.out.println(line + str);
    }

    public void springConfig(float currentPos, float target, float currentVelocity, float mass, float stiffness, float damping, float stopThreshold, int boundaryMode) {
        this.mTargetPos = target;
        this.mDamping = damping;
        this.mInitialized = false;
        this.mPos = currentPos;
        this.mLastVelocity = currentVelocity;
        this.mStiffness = stiffness;
        this.mMass = mass;
        this.mStopThreshold = stopThreshold;
        this.mBoundaryMode = boundaryMode;
        this.mLastTime = 0.0f;
    }

    @Override
    public float getVelocity(float time) {
        return this.mV;
    }

    @Override
    public float getInterpolation(float time) {
        this.compute(time - this.mLastTime);
        this.mLastTime = time;
        if (this.isStopped()) {
            this.mPos = (float)this.mTargetPos;
        }
        return this.mPos;
    }

    public float getAcceleration() {
        double k = this.mStiffness;
        double c = this.mDamping;
        double x = (double)this.mPos - this.mTargetPos;
        return (float)(-k * x - c * (double)this.mV) / this.mMass;
    }

    @Override
    public float getVelocity() {
        return 0.0f;
    }

    @Override
    public boolean isStopped() {
        double v = this.mV;
        double m = this.mMass;
        double k = this.mStiffness;
        double x = (double)this.mPos - this.mTargetPos;
        double energy = v * v * m + k * x * x;
        double max_def = Math.sqrt(energy / k);
        return max_def <= (double)this.mStopThreshold;
    }

    private void compute(double dt) {
        if (dt <= 0.0) {
            return;
        }
        double k = this.mStiffness;
        double c = this.mDamping;
        int overSample = (int)(1.0 + 9.0 / (Math.sqrt(this.mStiffness / (double)this.mMass) * dt * 4.0));
        dt /= (double)overSample;
        for (int i = 0; i < overSample; ++i) {
            double x = (double)this.mPos - this.mTargetPos;
            double a = (-k * x - c * (double)this.mV) / (double)this.mMass;
            double avgV = (double)this.mV + a * dt / 2.0;
            double avgX = (double)this.mPos + dt * avgV / 2.0 - this.mTargetPos;
            a = (-avgX * k - avgV * c) / (double)this.mMass;
            double dv = a * dt;
            avgV = (double)this.mV + dv / 2.0;
            this.mV += (float)dv;
            this.mPos += (float)(avgV * dt);
            if (this.mBoundaryMode <= 0) continue;
            if (this.mPos < 0.0f && (this.mBoundaryMode & 1) == 1) {
                this.mPos = -this.mPos;
                this.mV = -this.mV;
            }
            if (!(this.mPos > 1.0f) || (this.mBoundaryMode & 2) != 2) continue;
            this.mPos = 2.0f - this.mPos;
            this.mV = -this.mV;
        }
    }
}

