/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.analyzer.Grouping;
import androidx.constraintlayout.core.widgets.analyzer.WidgetGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class HelperWidget
extends ConstraintWidget
implements Helper {
    public ConstraintWidget[] mWidgets = new ConstraintWidget[4];
    public int mWidgetsCount = 0;

    @Override
    public void updateConstraints(ConstraintWidgetContainer container) {
    }

    @Override
    public void add(ConstraintWidget widget) {
        if (widget == this || widget == null) {
            return;
        }
        if (this.mWidgetsCount + 1 > this.mWidgets.length) {
            this.mWidgets = Arrays.copyOf(this.mWidgets, this.mWidgets.length * 2);
        }
        this.mWidgets[this.mWidgetsCount] = widget;
        ++this.mWidgetsCount;
    }

    @Override
    public void copy(ConstraintWidget src, HashMap<ConstraintWidget, ConstraintWidget> map) {
        super.copy(src, map);
        HelperWidget srcHelper = (HelperWidget)src;
        this.mWidgetsCount = 0;
        int count = srcHelper.mWidgetsCount;
        for (int i = 0; i < count; ++i) {
            this.add(map.get(srcHelper.mWidgets[i]));
        }
    }

    @Override
    public void removeAllIds() {
        this.mWidgetsCount = 0;
        Arrays.fill(this.mWidgets, null);
    }

    public void addDependents(ArrayList<WidgetGroup> dependencyLists, int orientation, WidgetGroup group) {
        ConstraintWidget widget;
        int i;
        for (i = 0; i < this.mWidgetsCount; ++i) {
            widget = this.mWidgets[i];
            group.add(widget);
        }
        for (i = 0; i < this.mWidgetsCount; ++i) {
            widget = this.mWidgets[i];
            Grouping.findDependents(widget, orientation, dependencyLists, group);
        }
    }

    public int findGroupInDependents(int orientation) {
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget widget = this.mWidgets[i];
            if (orientation == 0 && widget.horizontalGroup != -1) {
                return widget.horizontalGroup;
            }
            if (orientation != 1 || widget.verticalGroup == -1) continue;
            return widget.verticalGroup;
        }
        return -1;
    }
}

