/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.HelperReference;
import androidx.constraintlayout.core.state.State;

public class AlignVerticallyReference
extends HelperReference {
    private float mBias = 0.5f;

    public AlignVerticallyReference(State state) {
        super(state, State.Helper.ALIGN_VERTICALLY);
    }

    @Override
    public void apply() {
        for (Object key : this.mReferences) {
            ConstraintReference reference = this.mHelperState.constraints(key);
            reference.clearVertical();
            if (this.mTopToTop != null) {
                reference.topToTop(this.mTopToTop);
            } else if (this.mTopToBottom != null) {
                reference.topToBottom(this.mTopToBottom);
            } else {
                reference.topToTop(State.PARENT);
            }
            if (this.mBottomToTop != null) {
                reference.bottomToTop(this.mBottomToTop);
            } else if (this.mBottomToBottom != null) {
                reference.bottomToBottom(this.mBottomToBottom);
            } else {
                reference.bottomToBottom(State.PARENT);
            }
            if (this.mBias == 0.5f) continue;
            reference.verticalBias(this.mBias);
        }
    }
}

