/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.constraintlayout.core.parser.CLContainer;
import androidx.constraintlayout.core.parser.CLElement;
import java.util.ArrayList;

public class CLKey
extends CLContainer {
    private static ArrayList<String> sSections = new ArrayList();

    public CLKey(char[] content) {
        super(content);
    }

    public static CLElement allocate(char[] content) {
        return new CLKey(content);
    }

    public static CLElement allocate(String name, CLElement value) {
        CLKey key = new CLKey(name.toCharArray());
        key.setStart(0L);
        key.setEnd(name.length() - 1);
        key.set(value);
        return key;
    }

    public String getName() {
        return this.content();
    }

    @Override
    protected String toJSON() {
        if (this.mElements.size() > 0) {
            return this.getDebugName() + this.content() + ": " + ((CLElement)this.mElements.get(0)).toJSON();
        }
        return this.getDebugName() + this.content() + ": <> ";
    }

    @Override
    protected String toFormattedJSON(int indent, int forceIndent) {
        StringBuilder json = new StringBuilder(this.getDebugName());
        this.addIndent(json, indent);
        String content = this.content();
        if (this.mElements.size() > 0) {
            json.append(content);
            json.append(": ");
            if (sSections.contains(content)) {
                forceIndent = 3;
            }
            if (forceIndent > 0) {
                json.append(((CLElement)this.mElements.get(0)).toFormattedJSON(indent, forceIndent - 1));
            } else {
                String val = ((CLElement)this.mElements.get(0)).toJSON();
                if (val.length() + indent < sMaxLine) {
                    json.append(val);
                } else {
                    json.append(((CLElement)this.mElements.get(0)).toFormattedJSON(indent, forceIndent - 1));
                }
            }
            return json.toString();
        }
        return content + ": <> ";
    }

    public void set(CLElement value) {
        if (this.mElements.size() > 0) {
            this.mElements.set(0, value);
        } else {
            this.mElements.add(value);
        }
    }

    public CLElement getValue() {
        if (this.mElements.size() > 0) {
            return (CLElement)this.mElements.get(0);
        }
        return null;
    }

    static {
        sSections.add("ConstraintSets");
        sSections.add("Variables");
        sSections.add("Generate");
        sSections.add("Transitions");
        sSections.add("KeyFrames");
        sSections.add("KeyAttributes");
        sSections.add("KeyPositions");
        sSections.add("KeyCycles");
    }
}

