/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.constraintlayout.core.motion.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class CustomAttribute {
    private static final String TAG = "TransitionLayout";
    private boolean mMethod = false;
    String mName;
    private AttributeType mType;
    private int mIntegerValue;
    private float mFloatValue;
    private String mStringValue;
    boolean mBooleanValue;
    private int mColorValue;

    public AttributeType getType() {
        return this.mType;
    }

    public boolean isContinuous() {
        switch (this.mType) {
            case REFERENCE_TYPE: 
            case BOOLEAN_TYPE: 
            case STRING_TYPE: {
                return false;
            }
        }
        return true;
    }

    public void setFloatValue(float value) {
        this.mFloatValue = value;
    }

    public void setColorValue(int value) {
        this.mColorValue = value;
    }

    public void setIntValue(int value) {
        this.mIntegerValue = value;
    }

    public void setStringValue(String value) {
        this.mStringValue = value;
    }

    public int numberOfInterpolatedValues() {
        switch (this.mType) {
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                return 4;
            }
        }
        return 1;
    }

    public float getValueToInterpolate() {
        switch (this.mType) {
            case INT_TYPE: {
                return this.mIntegerValue;
            }
            case FLOAT_TYPE: {
                return this.mFloatValue;
            }
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case STRING_TYPE: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case BOOLEAN_TYPE: {
                return this.mBooleanValue ? 1.0f : 0.0f;
            }
            case DIMENSION_TYPE: {
                return this.mFloatValue;
            }
        }
        return Float.NaN;
    }

    public void getValuesToInterpolate(float[] ret) {
        switch (this.mType) {
            case INT_TYPE: {
                ret[0] = this.mIntegerValue;
                break;
            }
            case FLOAT_TYPE: {
                ret[0] = this.mFloatValue;
                break;
            }
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                int a = 0xFF & this.mColorValue >> 24;
                int r = 0xFF & this.mColorValue >> 16;
                int g = 0xFF & this.mColorValue >> 8;
                int b = 0xFF & this.mColorValue;
                float f_r = (float)Math.pow((float)r / 255.0f, 2.2);
                float f_g = (float)Math.pow((float)g / 255.0f, 2.2);
                float f_b = (float)Math.pow((float)b / 255.0f, 2.2);
                ret[0] = f_r;
                ret[1] = f_g;
                ret[2] = f_b;
                ret[3] = (float)a / 255.0f;
                break;
            }
            case STRING_TYPE: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case BOOLEAN_TYPE: {
                ret[0] = this.mBooleanValue ? 1.0f : 0.0f;
                break;
            }
            case DIMENSION_TYPE: {
                ret[0] = this.mFloatValue;
                break;
            }
        }
    }

    public void setValue(float[] value) {
        switch (this.mType) {
            case REFERENCE_TYPE: 
            case INT_TYPE: {
                this.mIntegerValue = (int)value[0];
                break;
            }
            case FLOAT_TYPE: {
                this.mFloatValue = value[0];
                break;
            }
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                this.mColorValue = CustomAttribute.hsvToRgb(value[0], value[1], value[2]);
                this.mColorValue = this.mColorValue & 0xFFFFFF | CustomAttribute.clamp((int)(255.0f * value[3])) << 24;
                break;
            }
            case STRING_TYPE: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case BOOLEAN_TYPE: {
                this.mBooleanValue = (double)value[0] > 0.5;
                break;
            }
            case DIMENSION_TYPE: {
                this.mFloatValue = value[0];
                break;
            }
        }
    }

    public static int hsvToRgb(float hue, float saturation, float value) {
        int h = (int)(hue * 6.0f);
        float f = hue * 6.0f - (float)h;
        int p = (int)(0.5f + 255.0f * value * (1.0f - saturation));
        int q = (int)(0.5f + 255.0f * value * (1.0f - f * saturation));
        int t = (int)(0.5f + 255.0f * value * (1.0f - (1.0f - f) * saturation));
        int v = (int)(0.5f + 255.0f * value);
        switch (h) {
            case 0: {
                return 0xFF000000 | (v << 16) + (t << 8) + p;
            }
            case 1: {
                return 0xFF000000 | (q << 16) + (v << 8) + p;
            }
            case 2: {
                return 0xFF000000 | (p << 16) + (v << 8) + t;
            }
            case 3: {
                return 0xFF000000 | (p << 16) + (q << 8) + v;
            }
            case 4: {
                return 0xFF000000 | (t << 16) + (p << 8) + v;
            }
            case 5: {
                return 0xFF000000 | (v << 16) + (p << 8) + q;
            }
        }
        return 0;
    }

    public boolean diff(CustomAttribute CustomAttribute2) {
        if (CustomAttribute2 == null || this.mType != CustomAttribute2.mType) {
            return false;
        }
        switch (this.mType) {
            case REFERENCE_TYPE: 
            case INT_TYPE: {
                return this.mIntegerValue == CustomAttribute2.mIntegerValue;
            }
            case FLOAT_TYPE: {
                return this.mFloatValue == CustomAttribute2.mFloatValue;
            }
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                return this.mColorValue == CustomAttribute2.mColorValue;
            }
            case STRING_TYPE: {
                return this.mIntegerValue == CustomAttribute2.mIntegerValue;
            }
            case BOOLEAN_TYPE: {
                return this.mBooleanValue == CustomAttribute2.mBooleanValue;
            }
            case DIMENSION_TYPE: {
                return this.mFloatValue == CustomAttribute2.mFloatValue;
            }
        }
        return false;
    }

    public CustomAttribute(String name, AttributeType attributeType) {
        this.mName = name;
        this.mType = attributeType;
    }

    public CustomAttribute(String name, AttributeType attributeType, Object value, boolean method) {
        this.mName = name;
        this.mType = attributeType;
        this.mMethod = method;
        this.setValue(value);
    }

    public CustomAttribute(CustomAttribute source, Object value) {
        this.mName = source.mName;
        this.mType = source.mType;
        this.setValue(value);
    }

    public void setValue(Object value) {
        switch (this.mType) {
            case REFERENCE_TYPE: 
            case INT_TYPE: {
                this.mIntegerValue = (Integer)value;
                break;
            }
            case FLOAT_TYPE: {
                this.mFloatValue = ((Float)value).floatValue();
                break;
            }
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                this.mColorValue = (Integer)value;
                break;
            }
            case STRING_TYPE: {
                this.mStringValue = (String)value;
                break;
            }
            case BOOLEAN_TYPE: {
                this.mBooleanValue = (Boolean)value;
                break;
            }
            case DIMENSION_TYPE: {
                this.mFloatValue = ((Float)value).floatValue();
                break;
            }
        }
    }

    public static HashMap<String, CustomAttribute> extractAttributes(HashMap<String, CustomAttribute> base, Object view) {
        HashMap<String, CustomAttribute> ret = new HashMap<String, CustomAttribute>();
        Class<?> viewClass = view.getClass();
        for (String name : base.keySet()) {
            CustomAttribute CustomAttribute2 = base.get(name);
            try {
                Method method = viewClass.getMethod("getMap" + name, new Class[0]);
                Object val = method.invoke(view, new Object[0]);
                ret.put(name, new CustomAttribute(CustomAttribute2, val));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static void setAttributes(Object view, HashMap<String, CustomAttribute> map) {
        Class<?> viewClass = view.getClass();
        for (String name : map.keySet()) {
            CustomAttribute CustomAttribute2 = map.get(name);
            String methodName = name;
            if (!CustomAttribute2.mMethod) {
                methodName = "set" + methodName;
            }
            try {
                switch (CustomAttribute2.mType) {
                    case INT_TYPE: {
                        Method method = viewClass.getMethod(methodName, Integer.TYPE);
                        method.invoke(view, CustomAttribute2.mIntegerValue);
                        break;
                    }
                    case FLOAT_TYPE: {
                        Method method = viewClass.getMethod(methodName, Float.TYPE);
                        method.invoke(view, Float.valueOf(CustomAttribute2.mFloatValue));
                        break;
                    }
                    case COLOR_TYPE: {
                        Method method = viewClass.getMethod(methodName, Integer.TYPE);
                        method.invoke(view, CustomAttribute2.mColorValue);
                        break;
                    }
                    case STRING_TYPE: {
                        Method method = viewClass.getMethod(methodName, CharSequence.class);
                        method.invoke(view, CustomAttribute2.mStringValue);
                        break;
                    }
                    case BOOLEAN_TYPE: {
                        Method method = viewClass.getMethod(methodName, Boolean.TYPE);
                        method.invoke(view, CustomAttribute2.mBooleanValue);
                        break;
                    }
                    case DIMENSION_TYPE: {
                        Method method = viewClass.getMethod(methodName, Float.TYPE);
                        method.invoke(view, Float.valueOf(CustomAttribute2.mFloatValue));
                        break;
                    }
                    case REFERENCE_TYPE: {
                        Method method = viewClass.getMethod(methodName, Integer.TYPE);
                        method.invoke(view, CustomAttribute2.mIntegerValue);
                        break;
                    }
                }
            }
            catch (NoSuchMethodException e) {
                Utils.loge(TAG, e.getMessage());
                Utils.loge(TAG, " Custom Attribute \"" + name + "\" not found on " + viewClass.getName());
                Utils.loge(TAG, viewClass.getName() + " must have a method " + methodName);
            }
            catch (IllegalAccessException e) {
                Utils.loge(TAG, " Custom Attribute \"" + name + "\" not found on " + viewClass.getName());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Utils.loge(TAG, " Custom Attribute \"" + name + "\" not found on " + viewClass.getName());
                e.printStackTrace();
            }
        }
    }

    public void applyCustom(Object view) {
        String name;
        Class<?> viewClass = view.getClass();
        String methodName = name = this.mName;
        if (!this.mMethod) {
            methodName = "set" + methodName;
        }
        try {
            switch (this.mType) {
                case REFERENCE_TYPE: 
                case INT_TYPE: {
                    Method method = viewClass.getMethod(methodName, Integer.TYPE);
                    method.invoke(view, this.mIntegerValue);
                    break;
                }
                case FLOAT_TYPE: {
                    Method method = viewClass.getMethod(methodName, Float.TYPE);
                    method.invoke(view, Float.valueOf(this.mFloatValue));
                    break;
                }
                case COLOR_TYPE: {
                    Method method = viewClass.getMethod(methodName, Integer.TYPE);
                    method.invoke(view, this.mColorValue);
                    break;
                }
                case STRING_TYPE: {
                    Method method = viewClass.getMethod(methodName, CharSequence.class);
                    method.invoke(view, this.mStringValue);
                    break;
                }
                case BOOLEAN_TYPE: {
                    Method method = viewClass.getMethod(methodName, Boolean.TYPE);
                    method.invoke(view, this.mBooleanValue);
                    break;
                }
                case DIMENSION_TYPE: {
                    Method method = viewClass.getMethod(methodName, Float.TYPE);
                    method.invoke(view, Float.valueOf(this.mFloatValue));
                    break;
                }
            }
        }
        catch (NoSuchMethodException e) {
            Utils.loge(TAG, e.getMessage());
            Utils.loge(TAG, " Custom Attribute \"" + name + "\" not found on " + viewClass.getName());
            Utils.loge(TAG, viewClass.getName() + " must have a method " + methodName);
        }
        catch (IllegalAccessException e) {
            Utils.loge(TAG, " Custom Attribute \"" + name + "\" not found on " + viewClass.getName());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Utils.loge(TAG, " Custom Attribute \"" + name + "\" not found on " + viewClass.getName());
            e.printStackTrace();
        }
    }

    private static int clamp(int c) {
        int N = 255;
        c &= ~(c >> 31);
        c -= N;
        c &= c >> 31;
        return c += N;
    }

    public void setInterpolatedValue(Object view, float[] value) {
        Class<?> viewClass = view.getClass();
        String methodName = "set" + this.mName;
        try {
            switch (this.mType) {
                case INT_TYPE: {
                    Method method = viewClass.getMethod(methodName, Integer.TYPE);
                    method.invoke(view, (int)value[0]);
                    break;
                }
                case FLOAT_TYPE: {
                    Method method = viewClass.getMethod(methodName, Float.TYPE);
                    method.invoke(view, Float.valueOf(value[0]));
                    break;
                }
                case COLOR_TYPE: {
                    Method method = viewClass.getMethod(methodName, Integer.TYPE);
                    int r = CustomAttribute.clamp((int)((float)Math.pow(value[0], 0.45454545454545453) * 255.0f));
                    int g = CustomAttribute.clamp((int)((float)Math.pow(value[1], 0.45454545454545453) * 255.0f));
                    int b = CustomAttribute.clamp((int)((float)Math.pow(value[2], 0.45454545454545453) * 255.0f));
                    int a = CustomAttribute.clamp((int)(value[3] * 255.0f));
                    int color = a << 24 | r << 16 | g << 8 | b;
                    method.invoke(view, color);
                    break;
                }
                case STRING_TYPE: {
                    throw new RuntimeException("unable to interpolate strings " + this.mName);
                }
                case BOOLEAN_TYPE: {
                    Method method = viewClass.getMethod(methodName, Boolean.TYPE);
                    method.invoke(view, value[0] > 0.5f);
                    break;
                }
                case DIMENSION_TYPE: {
                    Method method = viewClass.getMethod(methodName, Float.TYPE);
                    method.invoke(view, Float.valueOf(value[0]));
                    break;
                }
            }
        }
        catch (NoSuchMethodException e) {
            Utils.loge(TAG, "no method " + methodName + " on View \"" + view.getClass().getName() + "\"");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            Utils.loge(TAG, "cannot access method " + methodName + " on View \"" + view.getClass().getName() + "\"");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static enum AttributeType {
        INT_TYPE,
        FLOAT_TYPE,
        COLOR_TYPE,
        COLOR_DRAWABLE_TYPE,
        STRING_TYPE,
        BOOLEAN_TYPE,
        DIMENSION_TYPE,
        REFERENCE_TYPE;

    }
}

