/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.CurveFit;
import java.text.DecimalFormat;

public abstract class TimeCycleSplineSet {
    private static final String TAG = "SplineSet";
    protected CurveFit mCurveFit;
    protected int mWaveShape = 0;
    protected int[] mTimePoints = new int[10];
    protected float[][] mValues = new float[10][3];
    protected int count;
    protected String mType;
    protected float[] mCache = new float[3];
    protected static final int CURVE_VALUE = 0;
    protected static final int CURVE_PERIOD = 1;
    protected static final int CURVE_OFFSET = 2;
    protected static float VAL_2PI = (float)Math.PI * 2;
    protected boolean mContinue = false;
    protected long last_time;
    protected float last_cycle = Float.NaN;

    public String toString() {
        String str = this.mType;
        DecimalFormat df = new DecimalFormat("##.##");
        for (int i = 0; i < this.count; ++i) {
            str = str + "[" + this.mTimePoints[i] + " , " + df.format(this.mValues[i]) + "] ";
        }
        return str;
    }

    public void setType(String type) {
        this.mType = type;
    }

    protected float calcWave(float period) {
        float p = period;
        switch (this.mWaveShape) {
            default: {
                return (float)Math.sin(p * VAL_2PI);
            }
            case 1: {
                return Math.signum(p * VAL_2PI);
            }
            case 2: {
                return 1.0f - Math.abs(p);
            }
            case 3: {
                return (p * 2.0f + 1.0f) % 2.0f - 1.0f;
            }
            case 4: {
                return 1.0f - (p * 2.0f + 1.0f) % 2.0f;
            }
            case 5: {
                return (float)Math.cos(p * VAL_2PI);
            }
            case 6: 
        }
        float x = 1.0f - Math.abs(p * 4.0f % 4.0f - 2.0f);
        return 1.0f - x * x;
    }

    public CurveFit getCurveFit() {
        return this.mCurveFit;
    }

    protected void setStartTime(long currentTime) {
        this.last_time = currentTime;
    }

    public void setPoint(int position, float value, float period, int shape, float offset) {
        this.mTimePoints[this.count] = position;
        this.mValues[this.count][0] = value;
        this.mValues[this.count][1] = period;
        this.mValues[this.count][2] = offset;
        this.mWaveShape = Math.max(this.mWaveShape, shape);
        ++this.count;
    }

    public void setup(int curveType) {
        if (this.count == 0) {
            System.err.println("Error no points added to " + this.mType);
            return;
        }
        Sort.doubleQuickSort(this.mTimePoints, this.mValues, 0, this.count - 1);
        int unique = 0;
        for (int i = 1; i < this.mTimePoints.length; ++i) {
            if (this.mTimePoints[i] == this.mTimePoints[i - 1]) continue;
            ++unique;
        }
        if (unique == 0) {
            unique = 1;
        }
        double[] time = new double[unique];
        double[][] values = new double[unique][3];
        int k = 0;
        for (int i = 0; i < this.count; ++i) {
            if (i > 0 && this.mTimePoints[i] == this.mTimePoints[i - 1]) continue;
            time[k] = (double)this.mTimePoints[i] * 0.01;
            values[k][0] = this.mValues[i][0];
            values[k][1] = this.mValues[i][1];
            values[k][2] = this.mValues[i][2];
            ++k;
        }
        this.mCurveFit = CurveFit.get(curveType, time, values);
    }

    protected static class Sort {
        protected Sort() {
        }

        static void doubleQuickSort(int[] key, float[][] value, int low, int hi) {
            int[] stack = new int[key.length + 10];
            int count = 0;
            stack[count++] = hi;
            stack[count++] = low;
            while (count > 0) {
                --count;
                low = stack[count];
                if (low >= (hi = stack[--count])) continue;
                int p = Sort.partition(key, value, low, hi);
                stack[count++] = p - 1;
                stack[count++] = low;
                stack[count++] = hi;
                stack[count++] = p + 1;
            }
        }

        private static int partition(int[] array, float[][] value, int low, int hi) {
            int pivot = array[hi];
            int i = low;
            for (int j = low; j < hi; ++j) {
                if (array[j] > pivot) continue;
                Sort.swap(array, value, i, j);
                ++i;
            }
            Sort.swap(array, value, i, hi);
            return i;
        }

        private static void swap(int[] array, float[][] value, int a, int b) {
            int tmp = array[a];
            array[a] = array[b];
            array[b] = tmp;
            float[] tmpv = value[a];
            value[a] = value[b];
            value[b] = tmpv;
        }
    }
}

