/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.text.Layout;
import android.text.TextUtils;
import androidx.annotation.IntRange;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.android.InternalPlatformTextApi;
import androidx.compose.ui.text.android.LayoutCompatKt;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\rJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aJ\u0010\u0010\u001e\u001a\u00020\r2\b\b\u0001\u0010\u0015\u001a\u00020\rJ\u001a\u0010\u001f\u001a\u00020\r2\b\b\u0001\u0010\u0018\u001a\u00020\r2\b\b\u0002\u0010\u001d\u001a\u00020\u001aJ\u0010\u0010 \u001a\u00020\r2\b\b\u0001\u0010\u0015\u001a\u00020\rJ\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u001a2\b\b\u0001\u0010\u0015\u001a\u00020\rJ\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Landroidx/compose/ui/text/android/LayoutHelper;", "", "layout", "Landroid/text/Layout;", "(Landroid/text/Layout;)V", "bidiProcessedParagraphs", "", "getLayout", "()Landroid/text/Layout;", "paragraphBidi", "", "Ljava/text/Bidi;", "paragraphCount", "", "getParagraphCount", "()I", "paragraphEnds", "", "tmpBuffer", "", "analyzeBidi", "paragraphIndex", "getDownstreamHorizontal", "", "offset", "primary", "", "getHorizontalPosition", "usePrimaryDirection", "upstream", "getParagraphEnd", "getParagraphForOffset", "getParagraphStart", "isLineEndSpace", "c", "", "isRtlParagraph", "lineEndToVisibleEnd", "lineEnd", "BidiRun", "ui-text_release"})
@InternalPlatformTextApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLayoutHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutHelper.kt\nandroidx/compose/ui/text/android/LayoutHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,377:1\n1#2:378\n1627#3,6:379\n1627#3,6:385\n*S KotlinDebug\n*F\n+ 1 LayoutHelper.kt\nandroidx/compose/ui/text/android/LayoutHelper\n*L\n283#1:379,6\n322#1:385,6\n*E\n"})
public final class LayoutHelper {
    @NotNull
    private final Layout layout;
    @NotNull
    private final List<Integer> paragraphEnds;
    @NotNull
    private final List<Bidi> paragraphBidi;
    @NotNull
    private final boolean[] bidiProcessedParagraphs;
    @Nullable
    private char[] tmpBuffer;
    private final int paragraphCount;
    public static final int $stable = 8;

    public LayoutHelper(@NotNull Layout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.layout = layout;
        int paragraphEnd = 0;
        List lineFeeds = new ArrayList();
        do {
            CharSequence charSequence = this.layout.getText();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"layout.text");
            paragraphEnd = StringsKt.indexOf$default((CharSequence)charSequence, (char)'\n', (int)paragraphEnd, (boolean)false, (int)4, null);
            paragraphEnd = paragraphEnd < 0 ? this.layout.getText().length() : ++paragraphEnd;
            lineFeeds.add(paragraphEnd);
        } while (paragraphEnd < this.layout.getText().length());
        this.paragraphEnds = lineFeeds;
        int n = this.paragraphEnds.size();
        LayoutHelper layoutHelper2 = this;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(null);
        }
        layoutHelper2.paragraphBidi = arrayList;
        this.bidiProcessedParagraphs = new boolean[this.paragraphEnds.size()];
        this.paragraphCount = this.paragraphEnds.size();
    }

    @NotNull
    public final Layout getLayout() {
        return this.layout;
    }

    @Nullable
    public final Bidi analyzeBidi(int paragraphIndex) {
        int flag;
        Bidi bidi;
        if (this.bidiProcessedParagraphs[paragraphIndex]) {
            return this.paragraphBidi.get(paragraphIndex);
        }
        int paragraphStart = paragraphIndex == 0 ? 0 : ((Number)this.paragraphEnds.get(paragraphIndex - 1)).intValue();
        int paragraphEnd = ((Number)this.paragraphEnds.get(paragraphIndex)).intValue();
        int paragraphLength = paragraphEnd - paragraphStart;
        char[] buffer = this.tmpBuffer;
        buffer = buffer == null || buffer.length < paragraphLength ? new char[paragraphLength] : buffer;
        TextUtils.getChars((CharSequence)this.layout.getText(), (int)paragraphStart, (int)paragraphEnd, (char[])buffer, (int)0);
        Bidi result2 = Bidi.requiresBidi(buffer, 0, paragraphLength) ? ((bidi = new Bidi(buffer, 0, null, 0, paragraphLength, flag = this.isRtlParagraph(paragraphIndex) ? 1 : 0)).getRunCount() == 1 ? null : bidi) : null;
        this.paragraphBidi.set(paragraphIndex, result2);
        this.bidiProcessedParagraphs[paragraphIndex] = true;
        this.tmpBuffer = result2 != null ? (Object)(buffer == this.tmpBuffer ? null : this.tmpBuffer) : buffer;
        return result2;
    }

    public final int getParagraphCount() {
        return this.paragraphCount;
    }

    public final int getParagraphForOffset(@IntRange(from=0L) int offset, boolean upstream) {
        int it = CollectionsKt.binarySearch$default(this.paragraphEnds, (Comparable)Integer.valueOf(offset), (int)0, (int)0, (int)6, null);
        boolean bl = false;
        int paragraphIndex = it < 0 ? -(it + 1) : it + 1;
        if (upstream && paragraphIndex > 0 && offset == ((Number)this.paragraphEnds.get(paragraphIndex - 1)).intValue()) {
            return paragraphIndex - 1;
        }
        return paragraphIndex;
    }

    public static /* synthetic */ int getParagraphForOffset$default(LayoutHelper layoutHelper2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return layoutHelper2.getParagraphForOffset(n, bl);
    }

    public final int getParagraphStart(@IntRange(from=0L) int paragraphIndex) {
        return paragraphIndex == 0 ? 0 : ((Number)this.paragraphEnds.get(paragraphIndex - 1)).intValue();
    }

    public final int getParagraphEnd(@IntRange(from=0L) int paragraphIndex) {
        return ((Number)this.paragraphEnds.get(paragraphIndex)).intValue();
    }

    public final boolean isRtlParagraph(@IntRange(from=0L) int paragraphIndex) {
        int lineNumber = this.layout.getLineForOffset(this.getParagraphStart(paragraphIndex));
        return this.layout.getParagraphDirection(lineNumber) == -1;
    }

    public final float getHorizontalPosition(int offset, boolean usePrimaryDirection, boolean upstream) {
        boolean isLeftRequested;
        int n;
        Object[] runs;
        boolean isParaRtl;
        int lineNo;
        block16: {
            Bidi lineBidi;
            if (!upstream) {
                return this.getDownstreamHorizontal(offset, usePrimaryDirection);
            }
            lineNo = LayoutCompatKt.getLineForOffset(this.layout, offset, upstream);
            int lineStart = this.layout.getLineStart(lineNo);
            int lineEnd = this.layout.getLineEnd(lineNo);
            if (offset != lineStart && offset != lineEnd) {
                return this.getDownstreamHorizontal(offset, usePrimaryDirection);
            }
            if (offset == 0 || offset == this.layout.getText().length()) {
                return this.getDownstreamHorizontal(offset, usePrimaryDirection);
            }
            int paraNo = this.getParagraphForOffset(offset, upstream);
            isParaRtl = this.isRtlParagraph(paraNo);
            int lineVisibleEnd = this.lineEndToVisibleEnd(lineEnd);
            int paragraphStart = this.getParagraphStart(paraNo);
            int bidiStart = lineStart - paragraphStart;
            int bidiEnd = lineVisibleEnd - paragraphStart;
            Bidi bidi = this.analyzeBidi(paraNo);
            Bidi bidi2 = lineBidi = bidi != null ? bidi.createLineBidi(bidiStart, bidiEnd) : null;
            if (lineBidi == null || lineBidi.getRunCount() == 1) {
                boolean isStartLeft;
                boolean runDirection = this.layout.isRtlCharAt(lineStart);
                boolean bl = usePrimaryDirection || isParaRtl == runDirection ? !isParaRtl : (isStartLeft = isParaRtl);
                boolean isOffsetLeft = offset == lineStart ? isStartLeft : !isStartLeft;
                return isOffsetLeft ? this.layout.getLineLeft(lineNo) : this.layout.getLineRight(lineNo);
            }
            int isOffsetLeft = lineBidi.getRunCount();
            Object[] objectArray = new BidiRun[isOffsetLeft];
            for (int isStartLeft = 0; isStartLeft < isOffsetLeft; ++isStartLeft) {
                int n2 = isStartLeft;
                objectArray[n2] = new BidiRun(lineStart + lineBidi.getRunStart(n2), lineStart + lineBidi.getRunLimit(n2), lineBidi.getRunLevel(n2) % 2 == 1);
            }
            runs = objectArray;
            isOffsetLeft = 0;
            int n3 = lineBidi.getRunCount();
            byte[] byArray = new byte[n3];
            while (isOffsetLeft < n3) {
                int n4 = isOffsetLeft++;
                byArray[n4] = (byte)lineBidi.getRunLevel(n4);
            }
            byte[] levels = byArray;
            Bidi.reorderVisually(levels, 0, runs, 0, runs.length);
            if (offset == lineStart) {
                boolean isLeftRequested2;
                int n5;
                block15: {
                    Object[] $this$indexOfFirst$iv = runs;
                    boolean $i$f$indexOfFirst = false;
                    int n6 = $this$indexOfFirst$iv.length;
                    for (int index$iv = 0; index$iv < n6; ++index$iv) {
                        Object it = $this$indexOfFirst$iv[index$iv];
                        boolean bl = false;
                        if (!(((BidiRun)it).getStart() == offset)) continue;
                        n5 = index$iv;
                        break block15;
                    }
                    n5 = -1;
                }
                int index = n5;
                Object run = runs[index];
                boolean bl = usePrimaryDirection || isParaRtl == ((BidiRun)run).isRtl() ? !isParaRtl : (isLeftRequested2 = isParaRtl);
                if (index == 0 && isLeftRequested2) {
                    return this.layout.getLineLeft(lineNo);
                }
                if (index == ArraysKt.getLastIndex((Object[])runs) && !isLeftRequested2) {
                    return this.layout.getLineRight(lineNo);
                }
                if (isLeftRequested2) {
                    return this.layout.getPrimaryHorizontal(((BidiRun)runs[index - 1]).getStart());
                }
                return this.layout.getPrimaryHorizontal(((BidiRun)runs[index + 1]).getStart());
            }
            int lineEndAdjustedOffset = offset > lineVisibleEnd ? this.lineEndToVisibleEnd(offset) : offset;
            Object[] $this$indexOfFirst$iv = runs;
            boolean $i$f$indexOfFirst = false;
            int n7 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n7; ++index$iv) {
                Object it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(((BidiRun)it).getEnd() == lineEndAdjustedOffset)) continue;
                n = index$iv;
                break block16;
            }
            n = -1;
        }
        int index = n;
        Object run = runs[index];
        boolean bl = usePrimaryDirection || isParaRtl == ((BidiRun)run).isRtl() ? isParaRtl : (isLeftRequested = !isParaRtl);
        if (index == 0 && isLeftRequested) {
            return this.layout.getLineLeft(lineNo);
        }
        if (index == ArraysKt.getLastIndex((Object[])runs) && !isLeftRequested) {
            return this.layout.getLineRight(lineNo);
        }
        if (isLeftRequested) {
            return this.layout.getPrimaryHorizontal(((BidiRun)runs[index - 1]).getEnd());
        }
        return this.layout.getPrimaryHorizontal(((BidiRun)runs[index + 1]).getEnd());
    }

    private final float getDownstreamHorizontal(int offset, boolean primary) {
        return primary ? this.layout.getPrimaryHorizontal(offset) : this.layout.getSecondaryHorizontal(offset);
    }

    private final int lineEndToVisibleEnd(int lineEnd) {
        int visibleEnd;
        for (visibleEnd = lineEnd; visibleEnd > 0 && this.isLineEndSpace(this.layout.getText().charAt(visibleEnd - 1)); --visibleEnd) {
        }
        return visibleEnd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLineEndSpace(char c) {
        if (c == ' ') return true;
        if (c == '\n') return true;
        if (c == '\u1680') return true;
        boolean bl = '\u2000' <= c ? c < '\u200b' : false;
        if (bl) {
            if (c != '\u2007') return true;
        }
        if (c == '\u205f') return true;
        if (c != '\u3000') return false;
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/text/android/LayoutHelper$BidiRun;", "", "start", "", "end", "isRtl", "", "(IIZ)V", "getEnd", "()I", "()Z", "getStart", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "ui-text_release"})
    private static final class BidiRun {
        private final int start;
        private final int end;
        private final boolean isRtl;

        public BidiRun(int start, int end, boolean isRtl) {
            this.start = start;
            this.end = end;
            this.isRtl = isRtl;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final boolean isRtl() {
            return this.isRtl;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        public final boolean component3() {
            return this.isRtl;
        }

        @NotNull
        public final BidiRun copy(int start, int end, boolean isRtl) {
            return new BidiRun(start, end, isRtl);
        }

        public static /* synthetic */ BidiRun copy$default(BidiRun bidiRun, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = bidiRun.start;
            }
            if ((n3 & 2) != 0) {
                n2 = bidiRun.end;
            }
            if ((n3 & 4) != 0) {
                bl = bidiRun.isRtl;
            }
            return bidiRun.copy(n, n2, bl);
        }

        @NotNull
        public String toString() {
            return "BidiRun(start=" + this.start + ", end=" + this.end + ", isRtl=" + this.isRtl + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.start);
            result2 = result2 * 31 + Integer.hashCode(this.end);
            int n = this.isRtl ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BidiRun)) {
                return false;
            }
            BidiRun bidiRun = (BidiRun)other;
            if (this.start != bidiRun.start) {
                return false;
            }
            if (this.end != bidiRun.end) {
                return false;
            }
            return this.isRtl == bidiRun.isRtl;
        }
    }
}

