/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Build;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import androidx.annotation.VisibleForTesting;
import androidx.compose.ui.text.android.Paint29;
import androidx.compose.ui.text.android.SpannedExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a,\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a$\u0010\u000b\u001a\u00020\u0002*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0000\u001a$\u0010\u000f\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0001\u00a8\u0006\u0010"}, d2={"extendWith", "", "Landroid/graphics/Rect;", "rect", "fillStringBounds", "Landroid/graphics/Paint;", "text", "", "start", "", "end", "getCharSequenceBounds", "Landroid/text/TextPaint;", "startInclusive", "endExclusive", "getStringBounds", "ui-text_release"})
public final class PaintExtensionsKt {
    @NotNull
    public static final Rect getCharSequenceBounds(@NotNull TextPaint $this$getCharSequenceBounds, @NotNull CharSequence text, int startInclusive, int endExclusive) {
        Intrinsics.checkNotNullParameter((Object)$this$getCharSequenceBounds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Class<MetricAffectingSpan> metricSpanClass = MetricAffectingSpan.class;
        if (!(text instanceof Spanned) || !SpannedExtensionsKt.hasSpan((Spanned)text, metricSpanClass, startInclusive, endExclusive)) {
            return PaintExtensionsKt.getStringBounds((Paint)$this$getCharSequenceBounds, text, startInclusive, endExclusive);
        }
        Rect finalRect = new Rect();
        Rect tmpRect = new Rect();
        TextPaint tmpPaint = new TextPaint();
        int tmpStart = startInclusive;
        while (tmpStart < endExclusive) {
            int tmpEnd = ((Spanned)text).nextSpanTransition(tmpStart, endExclusive, metricSpanClass);
            MetricAffectingSpan[] spans = (MetricAffectingSpan[])((Spanned)text).getSpans(tmpStart, tmpEnd, metricSpanClass);
            tmpPaint.set($this$getCharSequenceBounds);
            Intrinsics.checkNotNullExpressionValue((Object)spans, (String)"spans");
            for (MetricAffectingSpan span : spans) {
                int spanEnd;
                int spanStart = ((Spanned)text).getSpanStart((Object)span);
                if (spanStart == (spanEnd = ((Spanned)text).getSpanEnd((Object)span))) continue;
                span.updateMeasureState(tmpPaint);
            }
            PaintExtensionsKt.fillStringBounds((Paint)tmpPaint, text, tmpStart, tmpEnd, tmpRect);
            PaintExtensionsKt.extendWith(finalRect, tmpRect);
            tmpStart = tmpEnd;
        }
        return finalRect;
    }

    private static final void extendWith(Rect $this$extendWith, Rect rect) {
        $this$extendWith.right += rect.width();
        $this$extendWith.top = Math.min($this$extendWith.top, rect.top);
        $this$extendWith.bottom = Math.max($this$extendWith.bottom, rect.bottom);
    }

    @VisibleForTesting
    @NotNull
    public static final Rect getStringBounds(@NotNull Paint $this$getStringBounds, @NotNull CharSequence text, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)$this$getStringBounds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Rect rect = new Rect();
        PaintExtensionsKt.fillStringBounds($this$getStringBounds, text, start2, end, rect);
        return rect;
    }

    private static final void fillStringBounds(Paint $this$fillStringBounds, CharSequence text, int start2, int end, Rect rect) {
        if (Build.VERSION.SDK_INT >= 29) {
            Paint29.getTextBounds($this$fillStringBounds, text, start2, end, rect);
        } else {
            $this$fillStringBounds.getTextBounds(((Object)text).toString(), start2, end, rect);
        }
    }
}

