/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.CustomAccessibilityAction;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.test.ActionsKt;
import androidx.compose.ui.test.Actions_androidKt;
import androidx.compose.ui.test.ErrorMessagesKt;
import androidx.compose.ui.test.ExperimentalTestApi;
import androidx.compose.ui.test.GestureScope;
import androidx.compose.ui.test.GlobalAssertions;
import androidx.compose.ui.test.KeyInjectionScope;
import androidx.compose.ui.test.MouseInjectionScope;
import androidx.compose.ui.test.MultiModalInjectionScope;
import androidx.compose.ui.test.MultiModalInjectionScopeImpl;
import androidx.compose.ui.test.RotaryInjectionScope;
import androidx.compose.ui.test.SemanticsMatcher;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import androidx.compose.ui.test.TestOwner;
import androidx.compose.ui.test.TouchInjectionScope;
import androidx.compose.ui.test.UtilsKt;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u009e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0002*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0014\u001a\u0014\u0010\u0015\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u001a;\u0010\u0018\u001a\u00020\u0014*\u00020\u00142\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00172!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00060\u001bH\u0007\u001a%\u0010\u001e\u001a\u00020\u0014*\u00020\u00142\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001b\u00a2\u0006\u0002\b\"H\u0007\u001a%\u0010#\u001a\u00020\u0014*\u00020\u00142\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020!0\u001b\u00a2\u0006\u0002\b\"H\u0007\u001a%\u0010%\u001a\u00020\u0014*\u00020\u00142\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020!0\u001b\u00a2\u0006\u0002\b\"H\u0007\u001a#\u0010'\u001a\u00020\u0014*\u00020\u00142\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020!0\u001b\u00a2\u0006\u0002\b\"\u001a%\u0010)\u001a\u00020\u0014*\u00020\u00142\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020!0\u001b\u00a2\u0006\u0002\b\"H\u0007\u001a\n\u0010+\u001a\u00020\u0014*\u00020\u0014\u001a\u0012\u0010,\u001a\u00020\u0014*\u00020\u00142\u0006\u0010-\u001a\u00020.\u001a\u0012\u0010/\u001a\u00020\u0014*\u00020\u00142\u0006\u00100\u001a\u000201\u001a\u0012\u00102\u001a\u00020\u0014*\u00020\u00142\u0006\u00103\u001a\u00020\u0011\u001a$\u00104\u001a\u00020\u0014*\u00020\u00142\u0018\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0006070605\u001aB\u00104\u001a\u00020\u0014\"\u000e\b\u0000\u00108*\b\u0012\u0004\u0012\u00020\u000609*\u00020\u00142\u0012\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H806052\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H8\u0012\u0004\u0012\u00020!0\u001b\u001a+\u0010;\u001a\u00020!*\u00020\u00142\u0018\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0006070605H\u0007\u00a2\u0006\u0002\b4\u001aI\u0010;\u001a\u00020!\"\u000e\b\u0000\u00108*\b\u0012\u0004\u0012\u00020\u000609*\u00020\u00142\u0012\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H806052\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H8\u0012\u0004\u0012\u00020!0\u001bH\u0007\u00a2\u0006\u0002\b4\u001a#\u0010<\u001a\u00020\u0014*\u00020\u00142\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020!0\u001b\u00a2\u0006\u0002\b\"\u001a\n\u0010>\u001a\u00020\u0014*\u00020\u0014\u001aC\u0010?\u001a\u00020!*\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00022\u001a\u0010@\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003050A\"\u0006\u0012\u0002\b\u0003052\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001707H\u0002\u00a2\u0006\u0002\u0010C\u001a\u001c\u0010D\u001a\u00020!*\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010E\u001a\u00020\u0014H\u0002\u001a\u0017\u0010F\u001a\u0004\u0018\u00010\u0002*\u00020\u00112\u0006\u0010G\u001a\u00020\u0002H\u0082\b\u001a\u0016\u0010F\u001a\u0004\u0018\u00010\u0002*\u00020\u00142\u0006\u00103\u001a\u00020\u0011H\u0002\u001a\u0014\u0010H\u001a\u00020\u0006*\u00020\u00022\u0006\u0010I\u001a\u00020JH\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u001a\u0010\b\u001a\u00020\u0006*\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\"\u0018\u0010\t\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\n\"\u0018\u0010\f\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\"\u0018\u0010\r\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\"\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0004\u00a8\u0006K"}, d2={"horizontalScrollAxis", "Landroidx/compose/ui/semantics/ScrollAxisRange;", "Landroidx/compose/ui/semantics/SemanticsNode;", "getHorizontalScrollAxis", "(Landroidx/compose/ui/semantics/SemanticsNode;)Landroidx/compose/ui/semantics/ScrollAxisRange;", "isAtEnd", "", "(Landroidx/compose/ui/semantics/ScrollAxisRange;)Z", "isAtStart", "isLazyList", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "isReversedHorizontally", "isReversedVertically", "isRtl", "verticalScrollAxis", "getVerticalScrollAxis", "findMatchInHierarchy", "Landroidx/compose/ui/test/SemanticsMatcher;", "node", "performClick", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "performCustomAccessibilityActionWithLabel", "label", "", "performCustomAccessibilityActionWithLabelMatching", "predicateDescription", "labelPredicate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "performGesture", "block", "Landroidx/compose/ui/test/GestureScope;", "", "Lkotlin/ExtensionFunctionType;", "performKeyInput", "Landroidx/compose/ui/test/KeyInjectionScope;", "performMouseInput", "Landroidx/compose/ui/test/MouseInjectionScope;", "performMultiModalInput", "Landroidx/compose/ui/test/MultiModalInjectionScope;", "performRotaryScrollInput", "Landroidx/compose/ui/test/RotaryInjectionScope;", "performScrollTo", "performScrollToIndex", "index", "", "performScrollToKey", "key", "", "performScrollToNode", "matcher", "performSemanticsAction", "Landroidx/compose/ui/semantics/SemanticsPropertyKey;", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function0;", "T", "Lkotlin/Function;", "invocation", "performSemanticsActionUnit", "performTouchInput", "Landroidx/compose/ui/test/TouchInjectionScope;", "requestFocus", "requireSemantics", "properties", "", "errorMessage", "(Landroidx/compose/ui/test/SemanticsNodeInteraction;Landroidx/compose/ui/semantics/SemanticsNode;[Landroidx/compose/ui/semantics/SemanticsPropertyKey;Lkotlin/jvm/functions/Function0;)V", "scrollToIndex", "nodeInteraction", "scrollToMatchingDescendantOrReturnScrollable", "root", "scrollToNode", "testOwner", "Landroidx/compose/ui/test/TestOwner;", "ui-test_release"})
@SourceDebugExtension(value={"SMAP\nActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Actions.kt\nandroidx/compose/ui/test/ActionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,766:1\n760#1:768\n760#1:771\n760#1:782\n1#2:767\n288#3,2:769\n288#3,2:772\n766#3:774\n857#3,2:775\n288#3,2:780\n288#3,2:783\n3792#4:777\n4307#4,2:778\n*S KotlinDebug\n*F\n+ 1 Actions.kt\nandroidx/compose/ui/test/ActionsKt\n*L\n285#1:768\n291#1:771\n764#1:782\n285#1:769,2\n291#1:772,2\n694#1:774\n694#1:775,2\n760#1:780,2\n764#1:783,2\n747#1:777\n747#1:778,2\n*E\n"})
public final class ActionsKt {
    @NotNull
    public static final SemanticsNodeInteraction performClick(@NotNull SemanticsNodeInteraction $this$performClick) {
        return Actions_androidKt.performClickImpl(GlobalAssertions.invokeGlobalAssertions($this$performClick));
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollTo(@NotNull SemanticsNodeInteraction $this$performScrollTo) {
        boolean shouldContinueScroll;
        GlobalAssertions.invokeGlobalAssertions($this$performScrollTo);
        while (shouldContinueScroll = ActionsKt.scrollToNode($this$performScrollTo.fetchSemanticsNode("Action performScrollTo() failed."), $this$performScrollTo.getTestContext$ui_test_release().getTestOwner$ui_test_release())) {
        }
        return $this$performScrollTo;
    }

    private static final boolean scrollToNode(SemanticsNode $this$scrollToNode, TestOwner testOwner) {
        SemanticsNode semanticsNode = UtilsKt.findClosestParentNode$default($this$scrollToNode, false, scrollToNode.scrollableNode.1.INSTANCE, 1, null);
        if (semanticsNode == null) {
            throw new AssertionError((Object)"Semantic Node has no parent layout with a Scroll SemanticsAction");
        }
        SemanticsNode scrollableNode2 = semanticsNode;
        Rect viewportInParent = LayoutCoordinatesKt.boundsInParent((LayoutCoordinates)scrollableNode2.getLayoutInfo().getCoordinates());
        LayoutCoordinates layoutCoordinates = scrollableNode2.getLayoutInfo().getCoordinates().getParentLayoutCoordinates();
        long parentInRoot = layoutCoordinates != null ? LayoutCoordinatesKt.positionInRoot((LayoutCoordinates)layoutCoordinates) : Offset.Companion.getZero-F1C5BW0();
        Rect viewport = viewportInParent.translate-k-4lQ0M(parentInRoot);
        Rect target = RectKt.Rect-tz77jQw((long)$this$scrollToNode.getPositionInRoot-F1C5BW0(), (long)IntSizeKt.toSize-ozmzZPI((long)$this$scrollToNode.getSize-YbymL2g()));
        Ref.FloatRef dx = new Ref.FloatRef();
        dx.element = ActionsKt.scrollToNode$scrollDelta(target.getLeft() - viewport.getLeft(), target.getRight() - viewport.getRight());
        if (ActionsKt.isReversedHorizontally(scrollableNode2)) {
            dx.element = -dx.element;
        }
        if (ActionsKt.isRtl(scrollableNode2)) {
            dx.element = -dx.element;
        }
        Ref.FloatRef dy = new Ref.FloatRef();
        dy.element = ActionsKt.scrollToNode$scrollDelta(target.getTop() - viewport.getTop(), target.getBottom() - viewport.getBottom());
        if (ActionsKt.isReversedVertically(scrollableNode2)) {
            dy.element = -dy.element;
        }
        if (!(dx.element == 0.0f) && ActionsKt.getHorizontalScrollAxis(scrollableNode2) != null || !(dy.element == 0.0f) && ActionsKt.getVerticalScrollAxis(scrollableNode2) != null) {
            testOwner.runOnUiThread((Function0)new Function0<Boolean>(scrollableNode2, dx, dy){
                final /* synthetic */ SemanticsNode $scrollableNode;
                final /* synthetic */ Ref.FloatRef $dx;
                final /* synthetic */ Ref.FloatRef $dy;
                {
                    this.$scrollableNode = $scrollableNode;
                    this.$dx = $dx;
                    this.$dy = $dy;
                    super(0);
                }

                @Nullable
                public final Boolean invoke() {
                    Function2 function2 = (Function2)((AccessibilityAction)this.$scrollableNode.getConfig().get(SemanticsActions.INSTANCE.getScrollBy())).getAction();
                    return function2 != null ? (Boolean)function2.invoke((Object)Float.valueOf(this.$dx.element), (Object)Float.valueOf(this.$dy.element)) : null;
                }
            });
            return true;
        }
        return false;
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollToIndex(@NotNull SemanticsNodeInteraction $this$performScrollToIndex, int index) {
        GlobalAssertions.invokeGlobalAssertions($this$performScrollToIndex);
        ActionsKt.scrollToIndex($this$performScrollToIndex.fetchSemanticsNode("Failed: performScrollToIndex(" + index + ')'), index, $this$performScrollToIndex);
        return $this$performScrollToIndex;
    }

    private static final void scrollToIndex(SemanticsNode $this$scrollToIndex, int index, SemanticsNodeInteraction nodeInteraction) {
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{SemanticsActions.INSTANCE.getScrollToIndex()};
        ActionsKt.requireSemantics(nodeInteraction, $this$scrollToIndex, semanticsPropertyKeyArray, (Function0<String>)((Function0)new Function0<String>(index){
            final /* synthetic */ int $index;
            {
                this.$index = $index;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Failed to scroll to index " + this.$index;
            }
        }));
        nodeInteraction.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Boolean>($this$scrollToIndex, index){
            final /* synthetic */ SemanticsNode $this_scrollToIndex;
            final /* synthetic */ int $index;
            {
                this.$this_scrollToIndex = $receiver;
                this.$index = $index;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Function function = ((AccessibilityAction)this.$this_scrollToIndex.getConfig().get(SemanticsActions.INSTANCE.getScrollToIndex())).getAction();
                Intrinsics.checkNotNull((Object)function);
                return (Boolean)((Function1)function).invoke((Object)this.$index);
            }
        });
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollToKey(@NotNull SemanticsNodeInteraction $this$performScrollToKey, @NotNull Object key) {
        GlobalAssertions.invokeGlobalAssertions($this$performScrollToKey);
        SemanticsNode node = $this$performScrollToKey.fetchSemanticsNode("Failed: performScrollToKey(\"" + key + "\")");
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{SemanticsProperties.INSTANCE.getIndexForKey(), SemanticsActions.INSTANCE.getScrollToIndex()};
        ActionsKt.requireSemantics($this$performScrollToKey, node, semanticsPropertyKeyArray, (Function0<String>)((Function0)new Function0<String>(key){
            final /* synthetic */ Object $key;
            {
                this.$key = $key;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Failed to scroll to the item identified by \"" + this.$key + '\"';
            }
        }));
        int index = ((Number)((Function1)node.getConfig().get(SemanticsProperties.INSTANCE.getIndexForKey())).invoke(key)).intValue();
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Failed to scroll to the item identified by \"" + key + "\", couldn't find the key.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$performScrollToKey.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Boolean>(node, index){
            final /* synthetic */ SemanticsNode $node;
            final /* synthetic */ int $index;
            {
                this.$node = $node;
                this.$index = $index;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Function function = ((AccessibilityAction)this.$node.getConfig().get(SemanticsActions.INSTANCE.getScrollToIndex())).getAction();
                Intrinsics.checkNotNull((Object)function);
                return (Boolean)((Function1)function).invoke((Object)this.$index);
            }
        });
        return $this$performScrollToKey;
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollToNode(@NotNull SemanticsNodeInteraction $this$performScrollToNode, @NotNull SemanticsMatcher matcher) {
        GlobalAssertions.invokeGlobalAssertions($this$performScrollToNode);
        SemanticsNode semanticsNode = ActionsKt.scrollToMatchingDescendantOrReturnScrollable($this$performScrollToNode, matcher);
        if (semanticsNode == null) {
            return $this$performScrollToNode;
        }
        SemanticsNode node = semanticsNode;
        if (!ActionsKt.isLazyList(node)) {
            String msg2 = "No node found that matches " + matcher.getDescription() + " in scrollable container";
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(msg2, $this$performScrollToNode.getSelector$ui_test_release(), node));
        }
        if (!ActionsKt.isAtStart(ActionsKt.getHorizontalScrollAxis(node)) || !ActionsKt.isAtStart(ActionsKt.getVerticalScrollAxis(node))) {
            ActionsKt.scrollToIndex(node, 0, $this$performScrollToNode);
        }
        while (ActionsKt.scrollToMatchingDescendantOrReturnScrollable($this$performScrollToNode, matcher) != null) {
            float f;
            float dx;
            float f2;
            SemanticsNode newNode;
            if (ActionsKt.isAtEnd(ActionsKt.getHorizontalScrollAxis(newNode)) && ActionsKt.isAtEnd(ActionsKt.getVerticalScrollAxis(newNode))) {
                String msg3 = "No node found that matches " + matcher.getDescription() + " in scrollable container";
                throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(msg3, $this$performScrollToNode.getSelector$ui_test_release(), newNode));
            }
            long viewPortSize = LayoutCoordinatesKt.boundsInParent((LayoutCoordinates)newNode.getLayoutInfo().getCoordinates()).getSize-NH-jbRc();
            if (ActionsKt.getHorizontalScrollAxis(newNode) != null) {
                boolean bl = false;
                f2 = Size.getWidth-impl((long)viewPortSize);
            } else {
                f2 = dx = 0.0f;
            }
            if (ActionsKt.getVerticalScrollAxis(newNode) != null) {
                boolean bl = false;
                f = Size.getHeight-impl((long)viewPortSize);
            } else {
                f = 0.0f;
            }
            float dy = f;
            $this$performScrollToNode.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Boolean>(newNode, dx, dy){
                final /* synthetic */ SemanticsNode $newNode;
                final /* synthetic */ float $dx;
                final /* synthetic */ float $dy;
                {
                    this.$newNode = $newNode;
                    this.$dx = $dx;
                    this.$dy = $dy;
                    super(0);
                }

                @Nullable
                public final Boolean invoke() {
                    Function2 function2 = (Function2)((AccessibilityAction)this.$newNode.getConfig().get(SemanticsActions.INSTANCE.getScrollBy())).getAction();
                    return function2 != null ? (Boolean)function2.invoke((Object)Float.valueOf(this.$dx), (Object)Float.valueOf(this.$dy)) : null;
                }
            });
        }
        return $this$performScrollToNode;
    }

    private static final SemanticsNode scrollToMatchingDescendantOrReturnScrollable(SemanticsNodeInteraction $this$scrollToMatchingDescendantOrReturnScrollable, SemanticsMatcher matcher) {
        Object v0;
        SemanticsNode node;
        block4: {
            node = $this$scrollToMatchingDescendantOrReturnScrollable.fetchSemanticsNode("Failed: performScrollToNode(" + matcher.getDescription() + ')');
            SemanticsMatcher $this$scrollToMatchingDescendantOrReturnScrollable$iv = matcher;
            boolean $i$f$scrollToMatchingDescendantOrReturnScrollable = false;
            Iterable $this$firstOrNull$iv$iv = node.getChildren();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                SemanticsNode it$iv = (SemanticsNode)element$iv$iv;
                boolean bl = false;
                if (!(it$iv.getLayoutInfo().isPlaced() && ActionsKt.findMatchInHierarchy($this$scrollToMatchingDescendantOrReturnScrollable$iv, it$iv) != null)) continue;
                v0 = element$iv$iv;
                break block4;
            }
            v0 = null;
        }
        SemanticsNode matchedNode = v0;
        while (matchedNode != null) {
            Object v1;
            block5: {
                boolean shouldContinueScroll = ActionsKt.scrollToNode(matchedNode, $this$scrollToMatchingDescendantOrReturnScrollable.getTestContext$ui_test_release().getTestOwner$ui_test_release());
                if (!shouldContinueScroll) {
                    return null;
                }
                node = $this$scrollToMatchingDescendantOrReturnScrollable.fetchSemanticsNode("Failed: performScrollToNode(" + matcher.getDescription() + ')');
                SemanticsMatcher $this$scrollToMatchingDescendantOrReturnScrollable$iv = matcher;
                boolean $i$f$scrollToMatchingDescendantOrReturnScrollable = false;
                Iterable $this$firstOrNull$iv$iv = node.getChildren();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    SemanticsNode it$iv = (SemanticsNode)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv.getLayoutInfo().isPlaced() && ActionsKt.findMatchInHierarchy($this$scrollToMatchingDescendantOrReturnScrollable$iv, it$iv) != null)) continue;
                    v1 = element$iv$iv;
                    break block5;
                }
                v1 = null;
            }
            matchedNode = v1;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Replaced by performTouchInput", replaceWith=@ReplaceWith(expression="performTouchInput(block)", imports={"import androidx.compose.ui.test.performGesture"}))
    @NotNull
    public static final SemanticsNodeInteraction performGesture(@NotNull SemanticsNodeInteraction $this$performGesture, @NotNull Function1<? super GestureScope, Unit> block) {
        SemanticsNode node = $this$performGesture.fetchSemanticsNode("Failed to perform a gesture.");
        GestureScope $this$performGesture_u24lambda_u243 = new GestureScope(node, $this$performGesture.getTestContext$ui_test_release());
        boolean bl = false;
        try {
            block.invoke((Object)$this$performGesture_u24lambda_u243);
        }
        finally {
            $this$performGesture_u24lambda_u243.dispose$ui_test_release();
        }
        return $this$performGesture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SemanticsNodeInteraction performTouchInput(@NotNull SemanticsNodeInteraction $this$performTouchInput, @NotNull Function1<? super TouchInjectionScope, Unit> block) {
        GlobalAssertions.invokeGlobalAssertions($this$performTouchInput);
        SemanticsNode node = $this$performTouchInput.fetchSemanticsNode("Failed to inject touch input.");
        MultiModalInjectionScopeImpl $this$performTouchInput_u24lambda_u244 = new MultiModalInjectionScopeImpl(node, $this$performTouchInput.getTestContext$ui_test_release());
        boolean bl = false;
        try {
            $this$performTouchInput_u24lambda_u244.touch(block);
        }
        finally {
            $this$performTouchInput_u24lambda_u244.dispose$ui_test_release();
        }
        return $this$performTouchInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performMouseInput(@NotNull SemanticsNodeInteraction $this$performMouseInput, @NotNull Function1<? super MouseInjectionScope, Unit> block) {
        GlobalAssertions.invokeGlobalAssertions($this$performMouseInput);
        SemanticsNode node = $this$performMouseInput.fetchSemanticsNode("Failed to inject mouse input.");
        MultiModalInjectionScopeImpl $this$performMouseInput_u24lambda_u245 = new MultiModalInjectionScopeImpl(node, $this$performMouseInput.getTestContext$ui_test_release());
        boolean bl = false;
        try {
            $this$performMouseInput_u24lambda_u245.mouse(block);
        }
        finally {
            $this$performMouseInput_u24lambda_u245.dispose$ui_test_release();
        }
        return $this$performMouseInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performKeyInput(@NotNull SemanticsNodeInteraction $this$performKeyInput, @NotNull Function1<? super KeyInjectionScope, Unit> block) {
        GlobalAssertions.invokeGlobalAssertions($this$performKeyInput);
        SemanticsNode node = $this$performKeyInput.fetchSemanticsNode("Failed to inject key input.");
        MultiModalInjectionScopeImpl $this$performKeyInput_u24lambda_u246 = new MultiModalInjectionScopeImpl(node, $this$performKeyInput.getTestContext$ui_test_release());
        boolean bl = false;
        try {
            $this$performKeyInput_u24lambda_u246.key(block);
        }
        finally {
            $this$performKeyInput_u24lambda_u246.dispose$ui_test_release();
        }
        return $this$performKeyInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SemanticsNodeInteraction performMultiModalInput(@NotNull SemanticsNodeInteraction $this$performMultiModalInput, @NotNull Function1<? super MultiModalInjectionScope, Unit> block) {
        SemanticsNode node = $this$performMultiModalInput.fetchSemanticsNode("Failed to inject multi-modal input.");
        MultiModalInjectionScopeImpl $this$performMultiModalInput_u24lambda_u247 = new MultiModalInjectionScopeImpl(node, $this$performMultiModalInput.getTestContext$ui_test_release());
        boolean bl = false;
        try {
            block.invoke((Object)$this$performMultiModalInput_u24lambda_u247);
        }
        finally {
            $this$performMultiModalInput_u24lambda_u247.dispose$ui_test_release();
        }
        return $this$performMultiModalInput;
    }

    @NotNull
    public static final SemanticsNodeInteraction requestFocus(@NotNull SemanticsNodeInteraction $this$requestFocus) {
        return ActionsKt.performSemanticsAction($this$requestFocus, (SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>)SemanticsActions.INSTANCE.getRequestFocus());
    }

    @Deprecated(message="Replaced with same function, but with SemanticsNodeInteraction as return type", level=DeprecationLevel.HIDDEN)
    @JvmName(name="performSemanticsAction")
    public static final /* synthetic */ void performSemanticsAction(SemanticsNodeInteraction $this$performSemanticsActionUnit, SemanticsPropertyKey key, Function1 invocation) {
        ActionsKt.performSemanticsAction($this$performSemanticsActionUnit, key, invocation);
    }

    @NotNull
    public static final <T extends Function<? extends Boolean>> SemanticsNodeInteraction performSemanticsAction(@NotNull SemanticsNodeInteraction $this$performSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<T>> key, @NotNull Function1<? super T, Unit> invocation) {
        SemanticsNode node = $this$performSemanticsAction.fetchSemanticsNode("Failed to perform " + key.getName() + " action.");
        SemanticsPropertyKey[] semanticsPropertyKeyArray = new SemanticsPropertyKey[]{key};
        ActionsKt.requireSemantics($this$performSemanticsAction, node, semanticsPropertyKeyArray, (Function0<String>)((Function0)new Function0<String>(key){
            final /* synthetic */ SemanticsPropertyKey<AccessibilityAction<T>> $key;
            {
                this.$key = $key;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Failed to perform action " + this.$key.getName();
            }
        }));
        $this$performSemanticsAction.getTestContext$ui_test_release().getTestOwner$ui_test_release().runOnUiThread((Function0)new Function0<Unit>(node, key, invocation){
            final /* synthetic */ SemanticsNode $node;
            final /* synthetic */ SemanticsPropertyKey<AccessibilityAction<T>> $key;
            final /* synthetic */ Function1<T, Unit> $invocation;
            {
                this.$node = $node;
                this.$key = $key;
                this.$invocation = $invocation;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Unit unit;
                Function function = ((AccessibilityAction)this.$node.getConfig().get(this.$key)).getAction();
                if (function != null) {
                    Function function2 = function;
                    this.$invocation.invoke((Object)function2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        });
        return $this$performSemanticsAction;
    }

    @Deprecated(message="Replaced with same function, but with SemanticsNodeInteraction as return type", level=DeprecationLevel.HIDDEN)
    @JvmName(name="performSemanticsAction")
    public static final /* synthetic */ void performSemanticsAction(SemanticsNodeInteraction $this$performSemanticsActionUnit, SemanticsPropertyKey key) {
        ActionsKt.performSemanticsAction($this$performSemanticsActionUnit, (SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>)key);
    }

    @NotNull
    public static final SemanticsNodeInteraction performSemanticsAction(@NotNull SemanticsNodeInteraction $this$performSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
        return ActionsKt.performSemanticsAction($this$performSemanticsAction, key, performSemanticsAction.3.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performRotaryScrollInput(@NotNull SemanticsNodeInteraction $this$performRotaryScrollInput, @NotNull Function1<? super RotaryInjectionScope, Unit> block) {
        GlobalAssertions.invokeGlobalAssertions($this$performRotaryScrollInput);
        SemanticsNode node = $this$performRotaryScrollInput.fetchSemanticsNode("Failed to send rotary Event");
        MultiModalInjectionScopeImpl $this$performRotaryScrollInput_u24lambda_u248 = new MultiModalInjectionScopeImpl(node, $this$performRotaryScrollInput.getTestContext$ui_test_release());
        boolean bl = false;
        try {
            $this$performRotaryScrollInput_u24lambda_u248.rotary(block);
        }
        finally {
            $this$performRotaryScrollInput_u24lambda_u248.dispose$ui_test_release();
        }
        return $this$performRotaryScrollInput;
    }

    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performCustomAccessibilityActionWithLabel(@NotNull SemanticsNodeInteraction $this$performCustomAccessibilityActionWithLabel, @NotNull String label) {
        return ActionsKt.performCustomAccessibilityActionWithLabelMatching($this$performCustomAccessibilityActionWithLabel, "label is \"" + label + '\"', (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(label){
            final /* synthetic */ String $label;
            {
                this.$label = $label;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                return Intrinsics.areEqual((Object)it, (Object)this.$label);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalTestApi
    @NotNull
    public static final SemanticsNodeInteraction performCustomAccessibilityActionWithLabelMatching(@NotNull SemanticsNodeInteraction $this$performCustomAccessibilityActionWithLabelMatching, @Nullable String predicateDescription, @NotNull Function1<? super String, Boolean> labelPredicate) {
        void $this$filterTo$iv$iv;
        SemanticsNode node = SemanticsNodeInteraction.fetchSemanticsNode$default($this$performCustomAccessibilityActionWithLabelMatching, null, 1, null);
        List actions = (List)node.getConfig().get(SemanticsActions.INSTANCE.getCustomActions());
        Iterable $this$filter$iv = actions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CustomAccessibilityAction it = (CustomAccessibilityAction)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)labelPredicate.invoke((Object)it.getLabel())).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchingActions = (List)destination$iv$iv;
        if (matchingActions.isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("No custom accessibility actions matched [" + predicateDescription + "].", $this$performCustomAccessibilityActionWithLabelMatching.getSelector$ui_test_release(), node));
        }
        if (matchingActions.size() > 1) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("Expected exactly one custom accessibility action to match [" + predicateDescription + "], but found " + matchingActions.size() + '.', $this$performCustomAccessibilityActionWithLabelMatching.getSelector$ui_test_release(), node));
        }
        ((CustomAccessibilityAction)matchingActions.get(0)).getAction().invoke();
        return $this$performCustomAccessibilityActionWithLabelMatching;
    }

    public static /* synthetic */ SemanticsNodeInteraction performCustomAccessibilityActionWithLabelMatching$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ActionsKt.performCustomAccessibilityActionWithLabelMatching(semanticsNodeInteraction, string, (Function1<? super String, Boolean>)function1);
    }

    private static final boolean isLazyList(SemanticsNode $this$isLazyList) {
        return $this$isLazyList.getConfig().contains(SemanticsActions.INSTANCE.getScrollBy()) && $this$isLazyList.getConfig().contains(SemanticsActions.INSTANCE.getScrollToIndex());
    }

    private static final ScrollAxisRange getHorizontalScrollAxis(SemanticsNode $this$horizontalScrollAxis) {
        return (ScrollAxisRange)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)$this$horizontalScrollAxis.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
    }

    private static final ScrollAxisRange getVerticalScrollAxis(SemanticsNode $this$verticalScrollAxis) {
        return (ScrollAxisRange)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)$this$verticalScrollAxis.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
    }

    private static final boolean isReversedHorizontally(SemanticsNode $this$isReversedHorizontally) {
        ScrollAxisRange scrollAxisRange = ActionsKt.getHorizontalScrollAxis($this$isReversedHorizontally);
        return scrollAxisRange != null ? scrollAxisRange.getReverseScrolling() : false;
    }

    private static final boolean isReversedVertically(SemanticsNode $this$isReversedVertically) {
        ScrollAxisRange scrollAxisRange = ActionsKt.getVerticalScrollAxis($this$isReversedVertically);
        return scrollAxisRange != null ? scrollAxisRange.getReverseScrolling() : false;
    }

    private static final boolean isAtStart(ScrollAxisRange $this$isAtStart) {
        boolean bl;
        ScrollAxisRange scrollAxisRange = $this$isAtStart;
        if (scrollAxisRange != null) {
            ScrollAxisRange it = scrollAxisRange;
            boolean bl2 = false;
            bl = ((Number)$this$isAtStart.getValue().invoke()).floatValue() == 0.0f;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean isAtEnd(ScrollAxisRange $this$isAtEnd) {
        boolean bl;
        ScrollAxisRange scrollAxisRange = $this$isAtEnd;
        if (scrollAxisRange != null) {
            ScrollAxisRange it = scrollAxisRange;
            boolean bl2 = false;
            bl = ((Number)$this$isAtEnd.getValue().invoke()).floatValue() == ((Number)$this$isAtEnd.getMaxValue().invoke()).floatValue();
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean isRtl(SemanticsNode $this$isRtl) {
        return $this$isRtl.getLayoutInfo().getLayoutDirection() == LayoutDirection.Rtl;
    }

    /*
     * WARNING - void declaration
     */
    private static final void requireSemantics(SemanticsNodeInteraction $this$requireSemantics, SemanticsNode node, SemanticsPropertyKey<?>[] properties, Function0<String> errorMessage) {
        void $this$filterTo$iv$iv;
        SemanticsPropertyKey<?>[] $this$filter$iv = properties;
        boolean $i$f$filter = false;
        SemanticsPropertyKey<?>[] semanticsPropertyKeyArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(!node.getConfig().contains((SemanticsPropertyKey)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingProperties = (List)destination$iv$iv;
        if (!((Collection)missingProperties).isEmpty()) {
            String msg2 = (String)errorMessage.invoke() + ", the node is missing [" + CollectionsKt.joinToString$default((Iterable)missingProperties, null, null, null, (int)0, null, (Function1)requireSemantics.msg.1.INSTANCE, (int)31, null) + ']';
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(msg2, $this$requireSemantics.getSelector$ui_test_release(), node));
        }
    }

    private static final SemanticsNode scrollToMatchingDescendantOrReturnScrollable(SemanticsMatcher $this$scrollToMatchingDescendantOrReturnScrollable, SemanticsNode root) {
        Object v0;
        block1: {
            boolean $i$f$scrollToMatchingDescendantOrReturnScrollable = false;
            Iterable $this$firstOrNull$iv = root.getChildren();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SemanticsNode it = (SemanticsNode)element$iv;
                boolean bl = false;
                if (!(it.getLayoutInfo().isPlaced() && ActionsKt.findMatchInHierarchy($this$scrollToMatchingDescendantOrReturnScrollable, it) != null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final SemanticsNode findMatchInHierarchy(SemanticsMatcher $this$findMatchInHierarchy, SemanticsNode node) {
        SemanticsNode semanticsNode;
        if ($this$findMatchInHierarchy.matches(node)) {
            semanticsNode = node;
        } else {
            Object v1;
            block3: {
                SemanticsMatcher $this$scrollToMatchingDescendantOrReturnScrollable$iv = $this$findMatchInHierarchy;
                boolean $i$f$scrollToMatchingDescendantOrReturnScrollable = false;
                Iterable $this$firstOrNull$iv$iv = node.getChildren();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    SemanticsNode it$iv = (SemanticsNode)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv.getLayoutInfo().isPlaced() && ActionsKt.findMatchInHierarchy($this$scrollToMatchingDescendantOrReturnScrollable$iv, it$iv) != null)) continue;
                    v1 = element$iv$iv;
                    break block3;
                }
                v1 = null;
            }
            semanticsNode = v1;
        }
        return semanticsNode;
    }

    private static final float scrollToNode$scrollDelta(float a, float b) {
        return Math.signum(a) == Math.signum(b) ? (Math.abs(a) < Math.abs(b) ? a : b) : 0.0f;
    }
}

