/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.layer;

import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.view.View;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.graphics.AndroidBlendMode_androidKt;
import androidx.compose.ui.graphics.AndroidCanvas_androidKt;
import androidx.compose.ui.graphics.AndroidColorFilter_androidKt;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasHolder;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.RenderEffect;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.layer.CompositingStrategy;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import androidx.compose.ui.graphics.layer.GraphicsLayerImpl;
import androidx.compose.ui.graphics.layer.SurfaceUtils;
import androidx.compose.ui.graphics.layer.ViewLayer;
import androidx.compose.ui.graphics.layer.ViewLayerVerificationHelper28;
import androidx.compose.ui.graphics.layer.ViewLayerVerificationHelper31;
import androidx.compose.ui.graphics.layer.view.DrawChildContainer;
import androidx.compose.ui.graphics.layer.view.PlaceholderHardwareCanvas;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u0098\u00012\u00020\u0001:\u0002\u0098\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010u\u001a\u00020v2\u0006\u00106\u001a\u000205H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bw\u0010\u001eJ\b\u0010x\u001a\u00020yH\u0016J\b\u0010z\u001a\u00020vH\u0016J\u0010\u0010{\u001a\u00020v2\u0006\u0010|\u001a\u00020}H\u0016J\b\u0010~\u001a\u00020>H\u0002JC\u0010\u007f\u001a\u00020v2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u001b\u0010\u0086\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u0088\u0001\u0012\u0004\u0012\u00020v0\u0087\u0001\u00a2\u0006\u0003\b\u0089\u0001H\u0016J\t\u0010\u008a\u0001\u001a\u00020vH\u0002J\t\u0010\u008b\u0001\u001a\u00020%H\u0002J\t\u0010\u008c\u0001\u001a\u00020%H\u0002J*\u0010\u008d\u0001\u001a\u00020v2\n\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\u0007\u0010\u0090\u0001\u001a\u00020fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0091\u0001\u0010\u0092\u0001J-\u0010\u0093\u0001\u001a\u00020v2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020s2\u0006\u0010e\u001a\u00020fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0094\u0001\u0010\u0095\u0001J\t\u0010\u0096\u0001\u001a\u00020vH\u0002J\t\u0010\u0097\u0001\u001a\u00020vH\u0002R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R,\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@VX\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R,\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0019@VX\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R$\u0010&\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020%8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u00100\u001a\u0004\u0018\u00010/2\b\u0010\u000b\u001a\u0004\u0018\u00010/@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R,\u00106\u001a\u0002052\u0006\u0010\u000b\u001a\u000205@VX\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b7\u0010\u001c\"\u0004\b8\u0010\u001eR\u001a\u00109\u001a\u00020%X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010(\"\u0004\b:\u0010*R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0015R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0015R\u0010\u0010A\u001a\u0004\u0018\u00010BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010D\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010F\u001a\u00020E2\u0006\u0010\u000b\u001a\u00020E@VX\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\bG\u0010\u0015\"\u0004\bH\u0010\u0017R(\u0010J\u001a\u0004\u0018\u00010I2\b\u0010\u000b\u001a\u0004\u0018\u00010I@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u0016\u0010O\u001a\n Q*\u0004\u0018\u00010P0PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010R\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u000f\"\u0004\bT\u0010\u0011R$\u0010U\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\u000f\"\u0004\bW\u0010\u0011R$\u0010X\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\u000f\"\u0004\bZ\u0010\u0011R$\u0010[\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\u000f\"\u0004\b]\u0010\u0011R$\u0010^\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010\u000f\"\u0004\b`\u0010\u0011R$\u0010a\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010\u000f\"\u0004\bc\u0010\u0011R\u000e\u0010d\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010e\u001a\u00020fX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0018R,\u0010g\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@VX\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\bh\u0010\u0015\"\u0004\bi\u0010\u0017R$\u0010j\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010\u000f\"\u0004\bl\u0010\u0011R$\u0010m\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010\u000f\"\u0004\bo\u0010\u0011R\u000e\u0010p\u001a\u00020qX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010r\u001a\u00020sX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010t\u001a\u00020sX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0099\u0001"}, d2={"Landroidx/compose/ui/graphics/layer/GraphicsViewLayer;", "Landroidx/compose/ui/graphics/layer/GraphicsLayerImpl;", "layerContainer", "Landroidx/compose/ui/graphics/layer/view/DrawChildContainer;", "ownerId", "", "canvasHolder", "Landroidx/compose/ui/graphics/CanvasHolder;", "canvasDrawScope", "Landroidx/compose/ui/graphics/drawscope/CanvasDrawScope;", "(Landroidx/compose/ui/graphics/layer/view/DrawChildContainer;JLandroidx/compose/ui/graphics/CanvasHolder;Landroidx/compose/ui/graphics/drawscope/CanvasDrawScope;)V", "value", "", "alpha", "getAlpha", "()F", "setAlpha", "(F)V", "Landroidx/compose/ui/graphics/Color;", "ambientShadowColor", "getAmbientShadowColor-0d7_KjU", "()J", "setAmbientShadowColor-8_81llA", "(J)V", "J", "Landroidx/compose/ui/graphics/BlendMode;", "blendMode", "getBlendMode-0nO6VwU", "()I", "setBlendMode-s9anfk8", "(I)V", "I", "cameraDistance", "getCameraDistance", "setCameraDistance", "getCanvasHolder", "()Landroidx/compose/ui/graphics/CanvasHolder;", "", "clip", "getClip", "()Z", "setClip", "(Z)V", "clipBoundsInvalidated", "clipRect", "Landroid/graphics/Rect;", "clipToBounds", "Landroidx/compose/ui/graphics/ColorFilter;", "colorFilter", "getColorFilter", "()Landroidx/compose/ui/graphics/ColorFilter;", "setColorFilter", "(Landroidx/compose/ui/graphics/ColorFilter;)V", "Landroidx/compose/ui/graphics/layer/CompositingStrategy;", "compositingStrategy", "getCompositingStrategy-ke2Ky5w", "setCompositingStrategy-Wpw9cng", "isInvalidated", "setInvalidated", "layerId", "getLayerId", "layerPaint", "Landroid/graphics/Paint;", "outlineIsProvided", "getOwnerId", "picture", "Landroid/graphics/Picture;", "pictureCanvasHolder", "pictureDrawScope", "Landroidx/compose/ui/geometry/Offset;", "pivotOffset", "getPivotOffset-F1C5BW0", "setPivotOffset-k-4lQ0M", "Landroidx/compose/ui/graphics/RenderEffect;", "renderEffect", "getRenderEffect", "()Landroidx/compose/ui/graphics/RenderEffect;", "setRenderEffect", "(Landroidx/compose/ui/graphics/RenderEffect;)V", "resources", "Landroid/content/res/Resources;", "kotlin.jvm.PlatformType", "rotationX", "getRotationX", "setRotationX", "rotationY", "getRotationY", "setRotationY", "rotationZ", "getRotationZ", "setRotationZ", "scaleX", "getScaleX", "setScaleX", "scaleY", "getScaleY", "setScaleY", "shadowElevation", "getShadowElevation", "setShadowElevation", "shouldManuallySetCenterPivot", "size", "Landroidx/compose/ui/unit/IntSize;", "spotShadowColor", "getSpotShadowColor-0d7_KjU", "setSpotShadowColor-8_81llA", "translationX", "getTranslationX", "setTranslationX", "translationY", "getTranslationY", "setTranslationY", "viewLayer", "Landroidx/compose/ui/graphics/layer/ViewLayer;", "x", "", "y", "applyCompositingLayer", "", "applyCompositingLayer-Wpw9cng", "calculateMatrix", "Landroid/graphics/Matrix;", "discardDisplayList", "draw", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "obtainLayerPaint", "record", "density", "Landroidx/compose/ui/unit/Density;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "layer", "Landroidx/compose/ui/graphics/layer/GraphicsLayer;", "block", "Lkotlin/Function1;", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "Lkotlin/ExtensionFunctionType;", "recordDrawingOperations", "requiresCompositingLayer", "requiresLayerPaint", "setOutline", "outline", "Landroid/graphics/Outline;", "outlineSize", "setOutline-O0kMr_c", "(Landroid/graphics/Outline;J)V", "setPosition", "setPosition-H0pRuoY", "(IIJ)V", "updateClipBounds", "updateLayerProperties", "Companion", "ui-graphics_release"})
@SourceDebugExtension(value={"SMAP\nGraphicsViewLayer.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphicsViewLayer.android.kt\nandroidx/compose/ui/graphics/layer/GraphicsViewLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AndroidCanvas.android.kt\nandroidx/compose/ui/graphics/CanvasHolder\n+ 4 CanvasDrawScope.kt\nandroidx/compose/ui/graphics/drawscope/CanvasDrawScope\n*L\n1#1,574:1\n1#2:575\n47#3,3:576\n50#3,2:596\n47#3,5:598\n546#4,17:579\n*S KotlinDebug\n*F\n+ 1 GraphicsViewLayer.android.kt\nandroidx/compose/ui/graphics/layer/GraphicsViewLayer\n*L\n439#1:576,3\n439#1:596,2\n451#1:598,5\n440#1:579,17\n*E\n"})
public final class GraphicsViewLayer
implements GraphicsLayerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DrawChildContainer layerContainer;
    private final long ownerId;
    @NotNull
    private final CanvasHolder canvasHolder;
    @NotNull
    private final ViewLayer viewLayer;
    private final Resources resources;
    @NotNull
    private final Rect clipRect;
    @Nullable
    private Paint layerPaint;
    @Nullable
    private final Picture picture;
    @Nullable
    private final CanvasDrawScope pictureDrawScope;
    @Nullable
    private final CanvasHolder pictureCanvasHolder;
    private int x;
    private int y;
    private long size;
    private boolean clipBoundsInvalidated;
    private boolean isInvalidated;
    private boolean outlineIsProvided;
    private boolean clipToBounds;
    private final long layerId;
    private int blendMode;
    @Nullable
    private ColorFilter colorFilter;
    private int compositingStrategy;
    private float alpha;
    private boolean shouldManuallySetCenterPivot;
    private long pivotOffset;
    private float scaleX;
    private float scaleY;
    private float translationX;
    private float translationY;
    private float shadowElevation;
    private long ambientShadowColor;
    private long spotShadowColor;
    private float rotationX;
    private float rotationY;
    private float rotationZ;
    @Nullable
    private RenderEffect renderEffect;
    private static final boolean mayRenderInSoftware = !SurfaceUtils.INSTANCE.isLockHardwareCanvasAvailable();
    @NotNull
    private static final android.graphics.Canvas PlaceholderCanvas = Build.VERSION.SDK_INT >= 23 ? (android.graphics.Canvas)new android.graphics.Canvas(){

        public boolean isHardwareAccelerated() {
            return true;
        }
    } : (android.graphics.Canvas)new PlaceholderHardwareCanvas();

    public GraphicsViewLayer(@NotNull DrawChildContainer layerContainer, long ownerId, @NotNull CanvasHolder canvasHolder, @NotNull CanvasDrawScope canvasDrawScope) {
        this.layerContainer = layerContainer;
        this.ownerId = ownerId;
        this.canvasHolder = canvasHolder;
        this.viewLayer = new ViewLayer((View)this.layerContainer, this.canvasHolder, canvasDrawScope);
        this.resources = this.layerContainer.getResources();
        this.clipRect = new Rect();
        this.picture = mayRenderInSoftware ? new Picture() : null;
        this.pictureDrawScope = mayRenderInSoftware ? new CanvasDrawScope() : null;
        this.pictureCanvasHolder = mayRenderInSoftware ? new CanvasHolder() : null;
        this.layerContainer.addView(this.viewLayer);
        this.viewLayer.setClipBounds(null);
        this.size = IntSize.Companion.getZero-YbymL2g();
        this.isInvalidated = true;
        this.layerId = View.generateViewId();
        this.blendMode = BlendMode.Companion.getSrcOver-0nO6VwU();
        this.compositingStrategy = CompositingStrategy.Companion.getAuto-ke2Ky5w();
        this.alpha = 1.0f;
        this.pivotOffset = Offset.Companion.getZero-F1C5BW0();
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.ambientShadowColor = Color.Companion.getBlack-0d7_KjU();
        this.spotShadowColor = Color.Companion.getBlack-0d7_KjU();
    }

    public /* synthetic */ GraphicsViewLayer(DrawChildContainer drawChildContainer, long l, CanvasHolder canvasHolder, CanvasDrawScope canvasDrawScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            canvasHolder = new CanvasHolder();
        }
        if ((n & 8) != 0) {
            canvasDrawScope = new CanvasDrawScope();
        }
        this(drawChildContainer, l, canvasHolder, canvasDrawScope);
    }

    @Override
    public long getOwnerId() {
        return this.ownerId;
    }

    @NotNull
    public final CanvasHolder getCanvasHolder() {
        return this.canvasHolder;
    }

    @Override
    public boolean isInvalidated() {
        return this.isInvalidated;
    }

    @Override
    public void setInvalidated(boolean bl) {
        this.isInvalidated = bl;
    }

    @Override
    public long getLayerId() {
        return this.layerId;
    }

    @Override
    public int getBlendMode-0nO6VwU() {
        return this.blendMode;
    }

    @Override
    public void setBlendMode-s9anfk8(int value) {
        Paint paint;
        this.blendMode = value;
        Paint $this$setBlendMode_s9anfk8_u24lambda_u240 = paint = this.obtainLayerPaint();
        boolean bl = false;
        $this$setBlendMode_s9anfk8_u24lambda_u240.setXfermode((Xfermode)new PorterDuffXfermode(AndroidBlendMode_androidKt.toPorterDuffMode-s9anfk8(value)));
        this.updateLayerProperties();
    }

    @Override
    @Nullable
    public ColorFilter getColorFilter() {
        return this.colorFilter;
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter value) {
        Paint paint;
        this.colorFilter = value;
        Paint $this$_set_colorFilter__u24lambda_u241 = paint = this.obtainLayerPaint();
        boolean bl = false;
        ColorFilter colorFilter = value;
        $this$_set_colorFilter__u24lambda_u241.setColorFilter((android.graphics.ColorFilter)(colorFilter != null ? AndroidColorFilter_androidKt.asAndroidColorFilter(colorFilter) : null));
        this.updateLayerProperties();
    }

    @Override
    public int getCompositingStrategy-ke2Ky5w() {
        return this.compositingStrategy;
    }

    @Override
    public void setCompositingStrategy-Wpw9cng(int value) {
        this.compositingStrategy = value;
        this.updateLayerProperties();
    }

    private final void applyCompositingLayer-Wpw9cng(int compositingStrategy) {
        boolean bl;
        int n = compositingStrategy;
        if (CompositingStrategy.equals-impl0(n, CompositingStrategy.Companion.getOffscreen-ke2Ky5w())) {
            this.viewLayer.setLayerType(2, this.layerPaint);
            bl = true;
        } else if (CompositingStrategy.equals-impl0(n, CompositingStrategy.Companion.getModulateAlpha-ke2Ky5w())) {
            this.viewLayer.setLayerType(0, this.layerPaint);
            bl = false;
        } else {
            this.viewLayer.setLayerType(0, this.layerPaint);
            bl = true;
        }
        this.viewLayer.setCanUseCompositingLayer$ui_graphics_release(bl);
    }

    private final void updateLayerProperties() {
        if (this.requiresCompositingLayer()) {
            this.applyCompositingLayer-Wpw9cng(CompositingStrategy.Companion.getOffscreen-ke2Ky5w());
        } else {
            this.applyCompositingLayer-Wpw9cng(this.getCompositingStrategy-ke2Ky5w());
        }
    }

    private final Paint obtainLayerPaint() {
        Paint paint = this.layerPaint;
        if (paint == null) {
            Paint paint2;
            Paint it = paint2 = new Paint();
            boolean bl = false;
            this.layerPaint = it;
            paint = paint2;
        }
        return paint;
    }

    private final boolean requiresCompositingLayer() {
        return CompositingStrategy.equals-impl0(this.getCompositingStrategy-ke2Ky5w(), CompositingStrategy.Companion.getOffscreen-ke2Ky5w()) || this.requiresLayerPaint();
    }

    private final boolean requiresLayerPaint() {
        return !BlendMode.equals-impl0(this.getBlendMode-0nO6VwU(), BlendMode.Companion.getSrcOver-0nO6VwU()) || this.getColorFilter() != null;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float value) {
        this.alpha = value;
        this.viewLayer.setAlpha(value);
    }

    @Override
    public long getPivotOffset-F1C5BW0() {
        return this.pivotOffset;
    }

    @Override
    public void setPivotOffset-k-4lQ0M(long value) {
        this.pivotOffset = value;
        if (OffsetKt.isUnspecified-k-4lQ0M((long)value)) {
            if (Build.VERSION.SDK_INT >= 28) {
                ViewLayerVerificationHelper28.INSTANCE.resetPivot(this.viewLayer);
            } else {
                this.shouldManuallySetCenterPivot = true;
                this.viewLayer.setPivotX((float)IntSize.getWidth-impl((long)this.size) / 2.0f);
                this.viewLayer.setPivotY((float)IntSize.getHeight-impl((long)this.size) / 2.0f);
            }
        } else {
            this.shouldManuallySetCenterPivot = false;
            this.viewLayer.setPivotX(Offset.getX-impl((long)value));
            this.viewLayer.setPivotY(Offset.getY-impl((long)value));
        }
    }

    @Override
    public float getScaleX() {
        return this.scaleX;
    }

    @Override
    public void setScaleX(float value) {
        this.scaleX = value;
        this.viewLayer.setScaleX(value);
    }

    @Override
    public float getScaleY() {
        return this.scaleY;
    }

    @Override
    public void setScaleY(float value) {
        this.scaleY = value;
        this.viewLayer.setScaleY(value);
    }

    @Override
    public float getTranslationX() {
        return this.translationX;
    }

    @Override
    public void setTranslationX(float value) {
        this.translationX = value;
        this.viewLayer.setTranslationX(value);
    }

    @Override
    public float getTranslationY() {
        return this.translationY;
    }

    @Override
    public void setTranslationY(float value) {
        this.translationY = value;
        this.viewLayer.setTranslationY(value);
    }

    @Override
    public float getShadowElevation() {
        return this.shadowElevation;
    }

    @Override
    public void setShadowElevation(float value) {
        this.shadowElevation = value;
        this.viewLayer.setElevation(value);
    }

    @Override
    public long getAmbientShadowColor-0d7_KjU() {
        return this.ambientShadowColor;
    }

    @Override
    public void setAmbientShadowColor-8_81llA(long value) {
        if (Build.VERSION.SDK_INT >= 28) {
            this.ambientShadowColor = value;
            ViewLayerVerificationHelper28.INSTANCE.setOutlineAmbientShadowColor(this.viewLayer, ColorKt.toArgb-8_81llA(value));
        }
    }

    @Override
    public long getSpotShadowColor-0d7_KjU() {
        return this.spotShadowColor;
    }

    @Override
    public void setSpotShadowColor-8_81llA(long value) {
        if (Build.VERSION.SDK_INT >= 28) {
            this.spotShadowColor = value;
            ViewLayerVerificationHelper28.INSTANCE.setOutlineSpotShadowColor(this.viewLayer, ColorKt.toArgb-8_81llA(value));
        }
    }

    @Override
    public float getRotationX() {
        return this.rotationX;
    }

    @Override
    public void setRotationX(float value) {
        this.rotationX = value;
        this.viewLayer.setRotationX(value);
    }

    @Override
    public float getRotationY() {
        return this.rotationY;
    }

    @Override
    public void setRotationY(float value) {
        this.rotationY = value;
        this.viewLayer.setRotationY(value);
    }

    @Override
    public float getRotationZ() {
        return this.rotationZ;
    }

    @Override
    public void setRotationZ(float value) {
        this.rotationZ = value;
        this.viewLayer.setRotation(value);
    }

    @Override
    public float getCameraDistance() {
        return this.viewLayer.getCameraDistance() / (float)this.resources.getDisplayMetrics().densityDpi;
    }

    @Override
    public void setCameraDistance(float value) {
        this.viewLayer.setCameraDistance(value * (float)this.resources.getDisplayMetrics().densityDpi);
    }

    @Override
    public boolean getClip() {
        return this.clipToBounds || this.viewLayer.getClipToOutline();
    }

    @Override
    public void setClip(boolean value) {
        this.clipToBounds = value && !this.outlineIsProvided;
        this.clipBoundsInvalidated = true;
        this.viewLayer.setClipToOutline(value && this.outlineIsProvided);
    }

    @Override
    @Nullable
    public RenderEffect getRenderEffect() {
        return this.renderEffect;
    }

    @Override
    public void setRenderEffect(@Nullable RenderEffect value) {
        this.renderEffect = value;
        if (Build.VERSION.SDK_INT >= 31) {
            ViewLayerVerificationHelper31.INSTANCE.setRenderEffect(this.viewLayer, value);
        }
    }

    @Override
    public void setPosition-H0pRuoY(int x, int y, long size) {
        if (!IntSize.equals-impl0((long)this.size, (long)size)) {
            if (this.getClip()) {
                this.clipBoundsInvalidated = true;
            }
            this.viewLayer.layout(x, y, x + IntSize.getWidth-impl((long)size), y + IntSize.getHeight-impl((long)size));
            this.size = size;
            if (this.shouldManuallySetCenterPivot) {
                this.viewLayer.setPivotX((float)IntSize.getWidth-impl((long)size) / 2.0f);
                this.viewLayer.setPivotY((float)IntSize.getHeight-impl((long)size) / 2.0f);
            }
        } else {
            if (this.x != x) {
                this.viewLayer.offsetLeftAndRight(x - this.x);
            }
            if (this.y != y) {
                this.viewLayer.offsetTopAndBottom(y - this.y);
            }
        }
        this.x = x;
        this.y = y;
    }

    @Override
    public void setOutline-O0kMr_c(@Nullable Outline outline, long outlineSize) {
        boolean requiresRedraw;
        boolean bl = requiresRedraw = !this.viewLayer.setLayerOutline(outline);
        if (this.getClip() && outline != null) {
            this.viewLayer.setClipToOutline(true);
            if (this.clipToBounds) {
                this.clipToBounds = false;
                this.clipBoundsInvalidated = true;
            }
        }
        boolean bl2 = this.outlineIsProvided = outline != null;
        if (requiresRedraw) {
            this.viewLayer.invalidate();
            this.recordDrawingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void record(@NotNull Density density, @NotNull LayoutDirection layoutDirection, @NotNull GraphicsLayer layer, @NotNull Function1<? super DrawScope, Unit> block) {
        block8: {
            if (this.viewLayer.getParent() == null) {
                this.layerContainer.addView(this.viewLayer);
            }
            this.viewLayer.setDrawParams(density, layoutDirection, layer, block);
            if (!this.viewLayer.isAttachedToWindow()) break block8;
            this.viewLayer.setVisibility(4);
            this.viewLayer.setVisibility(0);
            this.recordDrawingOperations();
            Picture picture = this.picture;
            if (picture != null) {
                Picture p = picture;
                boolean bl = false;
                android.graphics.Canvas pictureCanvas = p.beginRecording(IntSize.getWidth-impl((long)this.size), IntSize.getHeight-impl((long)this.size));
                try {
                    Unit unit;
                    CanvasHolder canvasHolder = this.pictureCanvasHolder;
                    if (canvasHolder != null) {
                        CanvasHolder this_$iv = canvasHolder;
                        boolean $i$f$drawInto = false;
                        android.graphics.Canvas previousCanvas$iv = this_$iv.getAndroidCanvas().getInternalCanvas();
                        this_$iv.getAndroidCanvas().setInternalCanvas(pictureCanvas);
                        Canvas $this$record_u24lambda_u244_u24lambda_u243 = this_$iv.getAndroidCanvas();
                        boolean bl2 = false;
                        CanvasDrawScope canvasDrawScope = this.pictureDrawScope;
                        if (canvasDrawScope != null) {
                            CanvasDrawScope.DrawParams drawParams;
                            void this_$iv2;
                            CanvasDrawScope canvasDrawScope2 = canvasDrawScope;
                            long size$iv = IntSizeKt.toSize-ozmzZPI((long)this.size);
                            boolean bl3 = false;
                            CanvasDrawScope.DrawParams drawParams2 = this_$iv2.getDrawParams();
                            Density prevDensity$iv = drawParams2.component1();
                            LayoutDirection prevLayoutDirection$iv = drawParams2.component2();
                            Canvas prevCanvas$iv = drawParams2.component3();
                            long prevSize$iv = drawParams2.component4-NH-jbRc();
                            CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u240$iv = drawParams = this_$iv2.getDrawParams();
                            boolean bl4 = false;
                            $this$draw_yzxVdVo_u24lambda_u240$iv.setDensity(density);
                            $this$draw_yzxVdVo_u24lambda_u240$iv.setLayoutDirection(layoutDirection);
                            $this$draw_yzxVdVo_u24lambda_u240$iv.setCanvas($this$record_u24lambda_u244_u24lambda_u243);
                            $this$draw_yzxVdVo_u24lambda_u240$iv.setSize-uvyYCjk(size$iv);
                            $this$record_u24lambda_u244_u24lambda_u243.save();
                            block.invoke((Object)this_$iv2);
                            $this$record_u24lambda_u244_u24lambda_u243.restore();
                            CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u241$iv = drawParams = this_$iv2.getDrawParams();
                            boolean bl5 = false;
                            $this$draw_yzxVdVo_u24lambda_u241$iv.setDensity(prevDensity$iv);
                            $this$draw_yzxVdVo_u24lambda_u241$iv.setLayoutDirection(prevLayoutDirection$iv);
                            $this$draw_yzxVdVo_u24lambda_u241$iv.setCanvas(prevCanvas$iv);
                            $this$draw_yzxVdVo_u24lambda_u241$iv.setSize-uvyYCjk(prevSize$iv);
                        }
                        this_$iv.getAndroidCanvas().setInternalCanvas(previousCanvas$iv);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                finally {
                    p.endRecording();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void recordDrawingOperations() {
        try {
            void this_$iv;
            CanvasHolder canvasHolder = this.canvasHolder;
            android.graphics.Canvas targetCanvas$iv = PlaceholderCanvas;
            boolean $i$f$drawInto = false;
            android.graphics.Canvas previousCanvas$iv = this_$iv.getAndroidCanvas().getInternalCanvas();
            this_$iv.getAndroidCanvas().setInternalCanvas(targetCanvas$iv);
            Canvas $this$recordDrawingOperations_u24lambda_u245 = this_$iv.getAndroidCanvas();
            boolean bl = false;
            this.layerContainer.drawChild$ui_graphics_release($this$recordDrawingOperations_u24lambda_u245, this.viewLayer, this.viewLayer.getDrawingTime());
            this_$iv.getAndroidCanvas().setInternalCanvas(previousCanvas$iv);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        block1: {
            android.graphics.Canvas androidCanvas;
            block0: {
                this.updateClipBounds();
                androidCanvas = AndroidCanvas_androidKt.getNativeCanvas(canvas);
                if (!androidCanvas.isHardwareAccelerated()) break block0;
                this.layerContainer.drawChild$ui_graphics_release(canvas, this.viewLayer, this.viewLayer.getDrawingTime());
                break block1;
            }
            Picture picture = this.picture;
            if (picture == null) break block1;
            Picture it = picture;
            boolean bl = false;
            androidCanvas.drawPicture(it);
        }
    }

    @Override
    @NotNull
    public Matrix calculateMatrix() {
        return this.viewLayer.getMatrix();
    }

    private final void updateClipBounds() {
        if (this.clipBoundsInvalidated) {
            Rect rect;
            ViewLayer viewLayer = this.viewLayer;
            if (this.getClip() && !this.outlineIsProvided) {
                Rect rect2;
                Rect rect3 = rect2 = this.clipRect;
                ViewLayer viewLayer2 = viewLayer;
                boolean bl = false;
                $this$updateClipBounds_u24lambda_u247.left = 0;
                $this$updateClipBounds_u24lambda_u247.top = 0;
                $this$updateClipBounds_u24lambda_u247.right = this.viewLayer.getWidth();
                $this$updateClipBounds_u24lambda_u247.bottom = this.viewLayer.getHeight();
                viewLayer = viewLayer2;
                rect = rect2;
            } else {
                rect = null;
            }
            viewLayer.setClipBounds(rect);
        }
    }

    @Override
    public void discardDisplayList() {
        this.layerContainer.removeViewInLayout(this.viewLayer);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Landroidx/compose/ui/graphics/layer/GraphicsViewLayer$Companion;", "", "()V", "PlaceholderCanvas", "Landroid/graphics/Canvas;", "getPlaceholderCanvas", "()Landroid/graphics/Canvas;", "mayRenderInSoftware", "", "getMayRenderInSoftware", "()Z", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getMayRenderInSoftware() {
            return mayRenderInSoftware;
        }

        @NotNull
        public final android.graphics.Canvas getPlaceholderCanvas() {
            return PlaceholderCanvas;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

