/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Context;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.platform.AndroidClipboardManager_androidKt;
import androidx.compose.ui.platform.Api28ClipboardManagerClipClear;
import androidx.compose.ui.platform.ClipEntry;
import androidx.compose.ui.platform.ClipboardManager;
import androidx.compose.ui.text.AnnotatedString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00060\u0006j\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/platform/AndroidClipboardManager;", "Landroidx/compose/ui/platform/ClipboardManager;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "clipboardManager", "Landroid/content/ClipboardManager;", "(Landroid/content/ClipboardManager;)V", "nativeClipboard", "Landroidx/compose/ui/platform/NativeClipboard;", "getNativeClipboard", "()Landroid/content/ClipboardManager;", "getClip", "Landroidx/compose/ui/platform/ClipEntry;", "getText", "Landroidx/compose/ui/text/AnnotatedString;", "hasText", "", "setClip", "", "clipEntry", "setText", "annotatedString", "ui_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAndroidClipboardManager.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidClipboardManager.android.kt\nandroidx/compose/ui/platform/AndroidClipboardManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,609:1\n1#2:610\n*E\n"})
public final class AndroidClipboardManager
implements ClipboardManager {
    @NotNull
    private final android.content.ClipboardManager clipboardManager;
    public static final int $stable = 8;

    public AndroidClipboardManager(@NotNull android.content.ClipboardManager clipboardManager) {
        this.clipboardManager = clipboardManager;
    }

    public AndroidClipboardManager(@NotNull Context context) {
        Object object = context.getSystemService("clipboard");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
        this((android.content.ClipboardManager)object);
    }

    @Override
    public void setText(@NotNull AnnotatedString annotatedString) {
        this.clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)"plain text", (CharSequence)AndroidClipboardManager_androidKt.convertToCharSequence(annotatedString)));
    }

    @Override
    @Nullable
    public AnnotatedString getText() {
        AnnotatedString annotatedString;
        ClipData clipData = this.clipboardManager.getPrimaryClip();
        if (clipData != null) {
            ClipData primaryClip = clipData;
            boolean bl = false;
            if (primaryClip.getItemCount() > 0) {
                ClipData.Item item = primaryClip.getItemAt(0);
                annotatedString = AndroidClipboardManager_androidKt.convertToAnnotatedString(item != null ? item.getText() : null);
            } else {
                annotatedString = null;
            }
        } else {
            annotatedString = null;
        }
        return annotatedString;
    }

    @Override
    public boolean hasText() {
        ClipDescription clipDescription = this.clipboardManager.getPrimaryClipDescription();
        return clipDescription != null ? clipDescription.hasMimeType("text/*") : false;
    }

    @Override
    @Nullable
    public ClipEntry getClip() {
        ClipEntry clipEntry;
        ClipData clipData = this.clipboardManager.getPrimaryClip();
        if (clipData != null) {
            ClipData p0 = clipData;
            boolean bl = false;
            clipEntry = new ClipEntry(p0);
        } else {
            clipEntry = null;
        }
        return clipEntry;
    }

    @Override
    public void setClip(@Nullable ClipEntry clipEntry) {
        if (clipEntry == null) {
            if (Build.VERSION.SDK_INT >= 28) {
                Api28ClipboardManagerClipClear.clearPrimaryClip(this.clipboardManager);
            } else {
                this.clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)"", (CharSequence)""));
            }
        } else {
            this.clipboardManager.setPrimaryClip(clipEntry.getClipData());
        }
    }

    @Override
    @NotNull
    public android.content.ClipboardManager getNativeClipboard() {
        return this.clipboardManager;
    }
}

