/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import android.view.View;
import android.view.inputmethod.ExtractedText;
import androidx.compose.ui.platform.coreshims.SoftwareKeyboardControllerCompat;
import androidx.compose.ui.text.input.InputMethodManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/compose/ui/text/input/InputMethodManagerImpl;", "Landroidx/compose/ui/text/input/InputMethodManager;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "imm", "Landroid/view/inputmethod/InputMethodManager;", "getImm", "()Landroid/view/inputmethod/InputMethodManager;", "imm$delegate", "Lkotlin/Lazy;", "softwareKeyboardControllerCompat", "Landroidx/compose/ui/platform/coreshims/SoftwareKeyboardControllerCompat;", "hideSoftInput", "", "restartInput", "showSoftInput", "updateExtractedText", "token", "", "extractedText", "Landroid/view/inputmethod/ExtractedText;", "updateSelection", "selectionStart", "selectionEnd", "compositionStart", "compositionEnd", "ui_release"})
public final class InputMethodManagerImpl
implements InputMethodManager {
    @NotNull
    private final View view;
    @NotNull
    private final Lazy imm$delegate;
    @NotNull
    private final SoftwareKeyboardControllerCompat softwareKeyboardControllerCompat;

    public InputMethodManagerImpl(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.imm$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<android.view.inputmethod.InputMethodManager>(this){
            final /* synthetic */ InputMethodManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final android.view.inputmethod.InputMethodManager invoke() {
                Object object = InputMethodManagerImpl.access$getView$p(this.this$0).getContext().getSystemService("input_method");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
                return (android.view.inputmethod.InputMethodManager)object;
            }
        }));
        this.softwareKeyboardControllerCompat = new SoftwareKeyboardControllerCompat(this.view);
    }

    private final android.view.inputmethod.InputMethodManager getImm() {
        Lazy lazy = this.imm$delegate;
        return (android.view.inputmethod.InputMethodManager)lazy.getValue();
    }

    @Override
    public void restartInput() {
        this.getImm().restartInput(this.view);
    }

    @Override
    public void showSoftInput() {
        this.softwareKeyboardControllerCompat.show();
    }

    @Override
    public void hideSoftInput() {
        this.softwareKeyboardControllerCompat.hide();
    }

    @Override
    public void updateExtractedText(int token, @NotNull ExtractedText extractedText) {
        Intrinsics.checkNotNullParameter((Object)extractedText, (String)"extractedText");
        this.getImm().updateExtractedText(this.view, token, extractedText);
    }

    @Override
    public void updateSelection(int selectionStart, int selectionEnd, int compositionStart, int compositionEnd) {
        this.getImm().updateSelection(this.view, selectionStart, selectionEnd, compositionStart, compositionEnd);
    }

    public static final /* synthetic */ View access$getView$p(InputMethodManagerImpl $this) {
        return $this.view;
    }
}

