/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.CubicBezierEasing;
import androidx.compose.animation.core.Easing;
import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.gestures.BringIntoViewSpec;
import androidx.compose.foundation.gestures.BringIntoViewSpec_androidKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidableCompositionLocal;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\"\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018GX\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u001a\u0010\u0007\u001a\u00020\u0002X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0004\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"LocalBringIntoViewSpec", "Landroidx/compose/runtime/ProvidableCompositionLocal;", "Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "getLocalBringIntoViewSpec$annotations", "()V", "getLocalBringIntoViewSpec", "()Landroidx/compose/runtime/ProvidableCompositionLocal;", "PivotBringIntoViewSpec", "getPivotBringIntoViewSpec$annotations", "getPivotBringIntoViewSpec", "()Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "foundation_release"})
public final class BringIntoViewSpec_androidKt {
    @NotNull
    private static final ProvidableCompositionLocal<BringIntoViewSpec> LocalBringIntoViewSpec = CompositionLocalKt.compositionLocalWithComputedDefaultOf((Function1)LocalBringIntoViewSpec.1.INSTANCE);
    @NotNull
    private static final BringIntoViewSpec PivotBringIntoViewSpec = new BringIntoViewSpec(){
        private final float parentFraction;
        private final float childFraction;
        @NotNull
        private final AnimationSpec<Float> scrollAnimationSpec;
        {
            this.parentFraction = 0.3f;
            this.scrollAnimationSpec = (AnimationSpec)AnimationSpecKt.tween$default((int)125, (int)0, (Easing)((Easing)new CubicBezierEasing(0.25f, 0.1f, 0.25f, 1.0f)), (int)2, null);
        }

        public final float getParentFraction() {
            return this.parentFraction;
        }

        public final float getChildFraction() {
            return this.childFraction;
        }

        @NotNull
        public AnimationSpec<Float> getScrollAnimationSpec() {
            return this.scrollAnimationSpec;
        }

        public float calculateScrollDistance(float offset, float size, float containerSize) {
            float trailingEdgeOfItemRequestingFocus = offset + size;
            float leadingEdgeOfItemRequestingFocus = offset;
            float sizeOfItemRequestingFocus = Math.abs(trailingEdgeOfItemRequestingFocus - leadingEdgeOfItemRequestingFocus);
            boolean childSmallerThanParent = sizeOfItemRequestingFocus <= containerSize;
            float initialTargetForLeadingEdge = this.parentFraction * containerSize - this.childFraction * sizeOfItemRequestingFocus;
            float spaceAvailableToShowItem = containerSize - initialTargetForLeadingEdge;
            float targetForLeadingEdge = childSmallerThanParent && spaceAvailableToShowItem < sizeOfItemRequestingFocus ? containerSize - sizeOfItemRequestingFocus : initialTargetForLeadingEdge;
            return leadingEdgeOfItemRequestingFocus - targetForLeadingEdge;
        }
    };

    @ExperimentalFoundationApi
    @NotNull
    public static final ProvidableCompositionLocal<BringIntoViewSpec> getLocalBringIntoViewSpec() {
        return LocalBringIntoViewSpec;
    }

    @ExperimentalFoundationApi
    public static /* synthetic */ void getLocalBringIntoViewSpec$annotations() {
    }

    @NotNull
    public static final BringIntoViewSpec getPivotBringIntoViewSpec() {
        return PivotBringIntoViewSpec;
    }

    public static /* synthetic */ void getPivotBringIntoViewSpec$annotations() {
    }
}

