/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import android.view.View;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputMethodManager;
import androidx.compose.foundation.text.input.internal.ComposeInputMethodManager;
import androidx.core.view.SoftwareKeyboardControllerCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0002J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0004J\b\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0019H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Landroidx/compose/foundation/text/input/internal/ComposeInputMethodManagerImpl;", "Landroidx/compose/foundation/text/input/internal/ComposeInputMethodManager;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "imm", "Landroid/view/inputmethod/InputMethodManager;", "softwareKeyboardControllerCompat", "Landroidx/core/view/SoftwareKeyboardControllerCompat;", "getView", "()Landroid/view/View;", "acceptStylusHandwritingDelegation", "", "createImm", "hideSoftInput", "prepareStylusHandwritingDelegation", "requireImm", "restartInput", "showSoftInput", "startStylusHandwriting", "updateCursorAnchorInfo", "info", "Landroid/view/inputmethod/CursorAnchorInfo;", "updateExtractedText", "token", "", "extractedText", "Landroid/view/inputmethod/ExtractedText;", "updateSelection", "selectionStart", "selectionEnd", "compositionStart", "compositionEnd", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nComposeInputMethodManager.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeInputMethodManager.android.kt\nandroidx/compose/foundation/text/input/internal/ComposeInputMethodManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
abstract class ComposeInputMethodManagerImpl
implements ComposeInputMethodManager {
    @NotNull
    private final View view;
    @Nullable
    private InputMethodManager imm;
    @NotNull
    private final SoftwareKeyboardControllerCompat softwareKeyboardControllerCompat;

    public ComposeInputMethodManagerImpl(@NotNull View view) {
        this.view = view;
        this.softwareKeyboardControllerCompat = new SoftwareKeyboardControllerCompat(this.view);
    }

    @NotNull
    protected final View getView() {
        return this.view;
    }

    @Override
    public void restartInput() {
        this.requireImm().restartInput(this.view);
    }

    @Override
    public void showSoftInput() {
        this.softwareKeyboardControllerCompat.show();
    }

    @Override
    public void hideSoftInput() {
        this.softwareKeyboardControllerCompat.hide();
    }

    @Override
    public void updateExtractedText(int token, @NotNull ExtractedText extractedText) {
        this.requireImm().updateExtractedText(this.view, token, extractedText);
    }

    @Override
    public void updateSelection(int selectionStart, int selectionEnd, int compositionStart, int compositionEnd) {
        this.requireImm().updateSelection(this.view, selectionStart, selectionEnd, compositionStart, compositionEnd);
    }

    @Override
    public void updateCursorAnchorInfo(@NotNull CursorAnchorInfo info) {
        this.requireImm().updateCursorAnchorInfo(this.view, info);
    }

    @Override
    public void startStylusHandwriting() {
    }

    @Override
    public void prepareStylusHandwritingDelegation() {
    }

    @Override
    public void acceptStylusHandwritingDelegation() {
    }

    @NotNull
    protected final InputMethodManager requireImm() {
        InputMethodManager inputMethodManager = this.imm;
        if (inputMethodManager == null) {
            InputMethodManager inputMethodManager2;
            InputMethodManager it = inputMethodManager2 = this.createImm();
            boolean bl = false;
            this.imm = it;
            inputMethodManager = inputMethodManager2;
        }
        return inputMethodManager;
    }

    private final InputMethodManager createImm() {
        Object object = this.view.getContext().getSystemService("input_method");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        return (InputMethodManager)object;
    }
}

