/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view.transform;

import android.content.ContentResolver;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.camera.core.impl.utils.Exif;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.view.TransformExperimental;
import androidx.camera.view.transform.OutputTransform;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@TransformExperimental
public final class FileTransformFactory {
    private boolean mUsingExifOrientation;

    public void setUsingExifOrientation(boolean usingExifOrientation) {
        this.mUsingExifOrientation = usingExifOrientation;
    }

    public boolean isUsingExifOrientation() {
        return this.mUsingExifOrientation;
    }

    @NonNull
    public OutputTransform getOutputTransform(@NonNull ContentResolver contentResolver, @NonNull Uri uri) throws IOException {
        try (InputStream inputStream = contentResolver.openInputStream(uri);){
            OutputTransform outputTransform = this.getOutputTransform(inputStream);
            return outputTransform;
        }
    }

    @NonNull
    public OutputTransform getOutputTransform(@NonNull File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            OutputTransform outputTransform = this.getOutputTransform(inputStream);
            return outputTransform;
        }
    }

    @NonNull
    public OutputTransform getOutputTransform(@NonNull InputStream inputStream) throws IOException {
        Exif exif = Exif.createFromInputStream((InputStream)inputStream);
        Rect cropRect = new Rect(0, 0, exif.getWidth(), exif.getHeight());
        Matrix matrix = TransformUtils.getNormalizedToBuffer((Rect)cropRect);
        if (this.mUsingExifOrientation) {
            matrix.postConcat(TransformUtils.getExifTransform((int)exif.getOrientation(), (int)exif.getWidth(), (int)exif.getHeight()));
        }
        return new OutputTransform(matrix, TransformUtils.rectToSize((Rect)cropRect));
    }
}

