/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.utils;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.video.internal.config.VideoConfigUtil;

public class EncoderProfilesUtil {
    private EncoderProfilesUtil() {
    }

    @NonNull
    public static EncoderProfilesProxy.VideoProfileProxy deriveVideoProfile(@NonNull EncoderProfilesProxy.VideoProfileProxy baseVideoProfile, @NonNull Size newResolution, @NonNull Range<Integer> bitrateRangeToClamp) {
        int derivedBitrate = VideoConfigUtil.scaleAndClampBitrate(baseVideoProfile.getBitrate(), baseVideoProfile.getBitDepth(), baseVideoProfile.getBitDepth(), baseVideoProfile.getFrameRate(), baseVideoProfile.getFrameRate(), newResolution.getWidth(), baseVideoProfile.getWidth(), newResolution.getHeight(), baseVideoProfile.getHeight(), bitrateRangeToClamp);
        return EncoderProfilesProxy.VideoProfileProxy.create((int)baseVideoProfile.getCodec(), (String)baseVideoProfile.getMediaType(), (int)derivedBitrate, (int)baseVideoProfile.getFrameRate(), (int)newResolution.getWidth(), (int)newResolution.getHeight(), (int)baseVideoProfile.getProfile(), (int)baseVideoProfile.getBitDepth(), (int)baseVideoProfile.getChromaSubsampling(), (int)baseVideoProfile.getHdrFormat());
    }

    @Nullable
    public static EncoderProfilesProxy.VideoProfileProxy getFirstVideoProfile(@Nullable EncoderProfilesProxy encoderProfiles) {
        if (encoderProfiles != null && !encoderProfiles.getVideoProfiles().isEmpty()) {
            return (EncoderProfilesProxy.VideoProfileProxy)encoderProfiles.getVideoProfiles().get(0);
        }
        return null;
    }
}

