/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaCodecInfo;
import android.util.Range;
import androidx.annotation.NonNull;
import androidx.arch.core.util.Function;
import androidx.camera.core.Logger;
import androidx.camera.video.internal.encoder.EncoderInfoImpl;
import androidx.camera.video.internal.encoder.InvalidConfigException;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.camera.video.internal.utils.CodecUtil;
import androidx.camera.video.internal.workaround.VideoEncoderInfoWrapper;
import java.util.Objects;

public class VideoEncoderInfoImpl
extends EncoderInfoImpl
implements VideoEncoderInfo {
    private static final String TAG = "VideoEncoderInfoImpl";
    @NonNull
    public static final Function<VideoEncoderConfig, VideoEncoderInfo> FINDER = videoEncoderConfig -> {
        try {
            return VideoEncoderInfoWrapper.from(VideoEncoderInfoImpl.from(videoEncoderConfig), null);
        }
        catch (InvalidConfigException e) {
            Logger.w((String)TAG, (String)"Unable to find a VideoEncoderInfoImpl", (Throwable)e);
            return null;
        }
    };
    private final MediaCodecInfo.VideoCapabilities mVideoCapabilities;

    @NonNull
    public static VideoEncoderInfoImpl from(@NonNull VideoEncoderConfig encoderConfig) throws InvalidConfigException {
        return new VideoEncoderInfoImpl(CodecUtil.findCodecAndGetCodecInfo(encoderConfig), encoderConfig.getMimeType());
    }

    VideoEncoderInfoImpl(@NonNull MediaCodecInfo codecInfo, @NonNull String mime) throws InvalidConfigException {
        super(codecInfo, mime);
        this.mVideoCapabilities = Objects.requireNonNull(this.mCodecCapabilities.getVideoCapabilities());
    }

    @Override
    public boolean canSwapWidthHeight() {
        return true;
    }

    @Override
    public boolean isSizeSupported(int width, int height) {
        return this.mVideoCapabilities.isSizeSupported(width, height);
    }

    @Override
    @NonNull
    public Range<Integer> getSupportedWidths() {
        return this.mVideoCapabilities.getSupportedWidths();
    }

    @Override
    @NonNull
    public Range<Integer> getSupportedHeights() {
        return this.mVideoCapabilities.getSupportedHeights();
    }

    @Override
    @NonNull
    public Range<Integer> getSupportedWidthsFor(int height) {
        try {
            return this.mVideoCapabilities.getSupportedWidthsFor(height);
        }
        catch (Throwable t) {
            throw VideoEncoderInfoImpl.toIllegalArgumentException(t);
        }
    }

    @Override
    @NonNull
    public Range<Integer> getSupportedHeightsFor(int width) {
        try {
            return this.mVideoCapabilities.getSupportedHeightsFor(width);
        }
        catch (Throwable t) {
            throw VideoEncoderInfoImpl.toIllegalArgumentException(t);
        }
    }

    @Override
    public int getWidthAlignment() {
        return this.mVideoCapabilities.getWidthAlignment();
    }

    @Override
    public int getHeightAlignment() {
        return this.mVideoCapabilities.getHeightAlignment();
    }

    @Override
    @NonNull
    public Range<Integer> getSupportedBitrateRange() {
        return this.mVideoCapabilities.getBitrateRange();
    }

    @NonNull
    private static IllegalArgumentException toIllegalArgumentException(@NonNull Throwable t) {
        if (t instanceof IllegalArgumentException) {
            return (IllegalArgumentException)t;
        }
        return new IllegalArgumentException(t);
    }
}

