/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaCodec;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.video.internal.encoder.InputBuffer;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class InputBufferImpl
implements InputBuffer {
    private final MediaCodec mMediaCodec;
    private final int mBufferIndex;
    private final ByteBuffer mByteBuffer;
    private final ListenableFuture<Void> mTerminationFuture;
    private final CallbackToFutureAdapter.Completer<Void> mTerminationCompleter;
    private final AtomicBoolean mTerminated = new AtomicBoolean(false);
    private long mPresentationTimeUs = 0L;
    private boolean mIsEndOfStream = false;

    InputBufferImpl(@NonNull MediaCodec mediaCodec, @IntRange(from=0L) int bufferIndex) throws MediaCodec.CodecException {
        this.mMediaCodec = (MediaCodec)Preconditions.checkNotNull((Object)mediaCodec);
        this.mBufferIndex = Preconditions.checkArgumentNonnegative((int)bufferIndex);
        this.mByteBuffer = mediaCodec.getInputBuffer(bufferIndex);
        AtomicReference ref = new AtomicReference();
        this.mTerminationFuture = CallbackToFutureAdapter.getFuture(completer -> {
            ref.set(completer);
            return "Terminate InputBuffer";
        });
        this.mTerminationCompleter = (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)((CallbackToFutureAdapter.Completer)ref.get()));
    }

    @Override
    @NonNull
    public ByteBuffer getByteBuffer() {
        this.throwIfTerminated();
        return this.mByteBuffer;
    }

    @Override
    public void setPresentationTimeUs(long presentationTimeUs) {
        this.throwIfTerminated();
        Preconditions.checkArgument((presentationTimeUs >= 0L ? 1 : 0) != 0);
        this.mPresentationTimeUs = presentationTimeUs;
    }

    @Override
    public void setEndOfStream(boolean endOfStream) {
        this.throwIfTerminated();
        this.mIsEndOfStream = endOfStream;
    }

    @Override
    public boolean submit() {
        if (this.mTerminated.getAndSet(true)) {
            return false;
        }
        try {
            this.mMediaCodec.queueInputBuffer(this.mBufferIndex, this.mByteBuffer.position(), this.mByteBuffer.limit(), this.mPresentationTimeUs, this.mIsEndOfStream ? 4 : 0);
            this.mTerminationCompleter.set(null);
            return true;
        }
        catch (IllegalStateException e) {
            this.mTerminationCompleter.setException((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean cancel() {
        if (this.mTerminated.getAndSet(true)) {
            return false;
        }
        try {
            this.mMediaCodec.queueInputBuffer(this.mBufferIndex, 0, 0, 0L, 0);
            this.mTerminationCompleter.set(null);
        }
        catch (IllegalStateException e) {
            this.mTerminationCompleter.setException((Throwable)e);
        }
        return true;
    }

    @Override
    @NonNull
    public ListenableFuture<Void> getTerminationFuture() {
        return Futures.nonCancellationPropagating(this.mTerminationFuture);
    }

    private void throwIfTerminated() {
        if (this.mTerminated.get()) {
            throw new IllegalStateException("The buffer is submitted or canceled.");
        }
    }
}

