/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.camera.video.internal.BufferProvider;
import androidx.camera.video.internal.encoder.EncoderCallback;
import androidx.camera.video.internal.encoder.EncoderInfo;
import androidx.camera.video.internal.encoder.InputBuffer;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

public interface Encoder {
    public static final long NO_TIMESTAMP = -1L;

    @NonNull
    public EncoderInput getInput();

    @NonNull
    public EncoderInfo getEncoderInfo();

    public int getConfiguredBitrate();

    public void start();

    public void stop();

    public void stop(long var1);

    public void pause();

    public void release();

    @NonNull
    public ListenableFuture<Void> getReleasedFuture();

    public void setEncoderCallback(@NonNull EncoderCallback var1, @NonNull Executor var2);

    public void requestKeyFrame();

    public static interface ByteBufferInput
    extends EncoderInput,
    BufferProvider<InputBuffer> {
    }

    public static interface SurfaceInput
    extends EncoderInput {
        public void setOnSurfaceUpdateListener(@NonNull Executor var1, @NonNull OnSurfaceUpdateListener var2);

        public static interface OnSurfaceUpdateListener {
            public void onSurfaceUpdate(@NonNull Surface var1);
        }
    }

    public static interface EncoderInput {
    }
}

