/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import androidx.annotation.NonNull;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.MediaSpec;
import androidx.camera.video.VideoSpec;

final class AutoValue_MediaSpec
extends MediaSpec {
    private final VideoSpec videoSpec;
    private final AudioSpec audioSpec;
    private final int outputFormat;

    private AutoValue_MediaSpec(VideoSpec videoSpec, AudioSpec audioSpec, int outputFormat) {
        this.videoSpec = videoSpec;
        this.audioSpec = audioSpec;
        this.outputFormat = outputFormat;
    }

    @Override
    @NonNull
    public VideoSpec getVideoSpec() {
        return this.videoSpec;
    }

    @Override
    @NonNull
    public AudioSpec getAudioSpec() {
        return this.audioSpec;
    }

    @Override
    public int getOutputFormat() {
        return this.outputFormat;
    }

    public String toString() {
        return "MediaSpec{videoSpec=" + this.videoSpec + ", audioSpec=" + this.audioSpec + ", outputFormat=" + this.outputFormat + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MediaSpec) {
            MediaSpec that = (MediaSpec)o;
            return this.videoSpec.equals(that.getVideoSpec()) && this.audioSpec.equals(that.getAudioSpec()) && this.outputFormat == that.getOutputFormat();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.videoSpec.hashCode();
        h$ *= 1000003;
        h$ ^= this.audioSpec.hashCode();
        h$ *= 1000003;
        return h$ ^= this.outputFormat;
    }

    @Override
    public MediaSpec.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends MediaSpec.Builder {
        private VideoSpec videoSpec;
        private AudioSpec audioSpec;
        private Integer outputFormat;

        Builder() {
        }

        private Builder(MediaSpec source) {
            this.videoSpec = source.getVideoSpec();
            this.audioSpec = source.getAudioSpec();
            this.outputFormat = source.getOutputFormat();
        }

        @Override
        public MediaSpec.Builder setVideoSpec(VideoSpec videoSpec) {
            if (videoSpec == null) {
                throw new NullPointerException("Null videoSpec");
            }
            this.videoSpec = videoSpec;
            return this;
        }

        @Override
        VideoSpec getVideoSpec() {
            if (this.videoSpec == null) {
                throw new IllegalStateException("Property \"videoSpec\" has not been set");
            }
            return this.videoSpec;
        }

        @Override
        public MediaSpec.Builder setAudioSpec(AudioSpec audioSpec) {
            if (audioSpec == null) {
                throw new NullPointerException("Null audioSpec");
            }
            this.audioSpec = audioSpec;
            return this;
        }

        @Override
        AudioSpec getAudioSpec() {
            if (this.audioSpec == null) {
                throw new IllegalStateException("Property \"audioSpec\" has not been set");
            }
            return this.audioSpec;
        }

        @Override
        public MediaSpec.Builder setOutputFormat(int outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public MediaSpec build() {
            String missing = "";
            if (this.videoSpec == null) {
                missing = missing + " videoSpec";
            }
            if (this.audioSpec == null) {
                missing = missing + " audioSpec";
            }
            if (this.outputFormat == null) {
                missing = missing + " outputFormat";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MediaSpec(this.videoSpec, this.audioSpec, this.outputFormat);
        }
    }
}

