/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.internal.encoder.TimeProvider;

@RequiresApi(value=21)
public class VideoTimebaseConverter {
    private static final String TAG = "VideoTimebaseConverter";
    private final TimeProvider mTimeProvider;
    private long mUptimeToRealtimeOffsetUs = -1L;
    private Timebase mInputTimebase;

    public VideoTimebaseConverter(@NonNull TimeProvider timeProvider, @Nullable Timebase inputTimebase) {
        this.mTimeProvider = timeProvider;
        this.mInputTimebase = inputTimebase;
    }

    public long convertToUptimeUs(long timestampUs) {
        if (this.mInputTimebase == null) {
            this.mInputTimebase = this.isCloseToRealtime(timestampUs) ? Timebase.REALTIME : Timebase.UPTIME;
            Logger.d((String)TAG, (String)("Detect input timebase = " + this.mInputTimebase));
        }
        switch (this.mInputTimebase) {
            case REALTIME: {
                if (this.mUptimeToRealtimeOffsetUs == -1L) {
                    this.mUptimeToRealtimeOffsetUs = this.calculateUptimeToRealtimeOffsetUs();
                    Logger.d((String)TAG, (String)("mUptimeToRealtimeOffsetUs = " + this.mUptimeToRealtimeOffsetUs));
                }
                return timestampUs - this.mUptimeToRealtimeOffsetUs;
            }
            case UPTIME: {
                return timestampUs;
            }
        }
        throw new AssertionError((Object)("Unknown timebase: " + this.mInputTimebase));
    }

    private boolean isCloseToRealtime(long timeUs) {
        long uptimeUs = this.mTimeProvider.uptimeUs();
        long realtimeUs = this.mTimeProvider.realtimeUs();
        return Math.abs(timeUs - realtimeUs) < Math.abs(timeUs - uptimeUs);
    }

    private long calculateUptimeToRealtimeOffsetUs() {
        long bestGap = Long.MAX_VALUE;
        long measured = 0L;
        for (int i = 0; i < 3; ++i) {
            long uptime1 = this.mTimeProvider.uptimeUs();
            long realtime = this.mTimeProvider.realtimeUs();
            long uptime2 = this.mTimeProvider.uptimeUs();
            long gap = uptime2 - uptime1;
            if (i != 0 && gap >= bestGap) continue;
            bestGap = gap;
            measured = realtime - (uptime1 + uptime2 >> 1);
        }
        return Math.max(0L, measured);
    }
}

