/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.compat.quirk.NegativeLatLongSavesIncorrectlyQuirk;

@RequiresApi(value=21)
public final class CorrectNegativeLatLongForMediaMuxer {
    private CorrectNegativeLatLongForMediaMuxer() {
    }

    @NonNull
    public static Pair<Double, Double> adjustGeoLocation(double latitude, double longitude) {
        if (DeviceQuirks.get(NegativeLatLongSavesIncorrectlyQuirk.class) != null) {
            latitude = CorrectNegativeLatLongForMediaMuxer.adjustInternal(latitude);
            longitude = CorrectNegativeLatLongForMediaMuxer.adjustInternal(longitude);
        }
        return Pair.create((Object)latitude, (Object)longitude);
    }

    private static double adjustInternal(double value) {
        return value >= 0.0 ? value : (value * 10000.0 - 1.0) / 10000.0;
    }
}

