/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.MediaSpec;
import androidx.camera.video.VideoSpec;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.camera.video.internal.config.VideoEncoderConfigDefaultResolver;
import androidx.camera.video.internal.config.VideoEncoderConfigVideoProfileResolver;
import androidx.camera.video.internal.config.VideoMimeInfo;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.camera.video.internal.encoder.VideoEncoderDataSpace;
import androidx.camera.video.internal.utils.DynamicRangeUtil;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@RequiresApi(value=21)
public final class VideoConfigUtil {
    private static final String TAG = "VideoConfigUtil";
    private static final Map<String, Map<Integer, VideoEncoderDataSpace>> MIME_TO_DATA_SPACE_MAP = new HashMap<String, Map<Integer, VideoEncoderDataSpace>>();

    private VideoConfigUtil() {
    }

    @NonNull
    public static VideoMimeInfo resolveVideoMimeInfo(@NonNull MediaSpec mediaSpec, @NonNull DynamicRange dynamicRange, @Nullable VideoValidatedEncoderProfilesProxy encoderProfiles) {
        String mediaSpecVideoMime;
        Preconditions.checkState((boolean)dynamicRange.isFullySpecified(), (String)("Dynamic range must be a fully specified dynamic range [provided dynamic range: " + dynamicRange + "]"));
        String resolvedVideoMime = mediaSpecVideoMime = MediaSpec.outputFormatToVideoMime(mediaSpec.getOutputFormat());
        EncoderProfilesProxy.VideoProfileProxy compatibleVideoProfile = null;
        if (encoderProfiles != null) {
            Set<Integer> encoderHdrFormats = DynamicRangeUtil.dynamicRangeToVideoProfileHdrFormats(dynamicRange);
            Set<Integer> encoderBitDepths = DynamicRangeUtil.dynamicRangeToVideoProfileBitDepth(dynamicRange);
            for (EncoderProfilesProxy.VideoProfileProxy videoProfile : encoderProfiles.getVideoProfiles()) {
                if (!encoderHdrFormats.contains(videoProfile.getHdrFormat()) || !encoderBitDepths.contains(videoProfile.getBitDepth())) continue;
                String videoProfileMime = videoProfile.getMediaType();
                if (Objects.equals(mediaSpecVideoMime, videoProfileMime)) {
                    Logger.d((String)TAG, (String)("MediaSpec video mime matches EncoderProfiles. Using EncoderProfiles to derive VIDEO settings [mime type: " + resolvedVideoMime + "]"));
                } else {
                    if (mediaSpec.getOutputFormat() != -1) continue;
                    Logger.d((String)TAG, (String)("MediaSpec contains OUTPUT_FORMAT_AUTO. Using CamcorderProfile to derive VIDEO settings [mime type: " + resolvedVideoMime + ", dynamic range: " + dynamicRange + "]"));
                }
                compatibleVideoProfile = videoProfile;
                resolvedVideoMime = videoProfileMime;
                break;
            }
        }
        if (compatibleVideoProfile == null) {
            if (mediaSpec.getOutputFormat() == -1) {
                resolvedVideoMime = VideoConfigUtil.getDynamicRangeDefaultMime(dynamicRange);
            }
            if (encoderProfiles == null) {
                Logger.d((String)TAG, (String)("No EncoderProfiles present. May rely on fallback defaults to derive VIDEO settings [chosen mime type: " + resolvedVideoMime + ", dynamic range: " + dynamicRange + "]"));
            } else {
                Logger.d((String)TAG, (String)("No video EncoderProfile is compatible with requested output format and dynamic range. May rely on fallback defaults to derive VIDEO settings [chosen mime type: " + resolvedVideoMime + ", dynamic range: " + dynamicRange + "]"));
            }
        }
        VideoMimeInfo.Builder mimeInfoBuilder = VideoMimeInfo.builder(resolvedVideoMime);
        if (compatibleVideoProfile != null) {
            mimeInfoBuilder.setCompatibleVideoProfile(compatibleVideoProfile);
        }
        return mimeInfoBuilder.build();
    }

    @NonNull
    private static String getDynamicRangeDefaultMime(@NonNull DynamicRange dynamicRange) {
        switch (dynamicRange.getEncoding()) {
            case 6: {
                return "video/dolby-vision";
            }
            case 3: 
            case 4: 
            case 5: {
                return "video/hevc";
            }
            case 1: {
                return "video/avc";
            }
        }
        throw new UnsupportedOperationException("Unsupported dynamic range: " + dynamicRange + "\nNo supported default mime type available.");
    }

    @NonNull
    public static VideoEncoderConfig resolveVideoEncoderConfig(@NonNull VideoMimeInfo videoMimeInfo, @NonNull Timebase inputTimebase, @NonNull VideoSpec videoSpec, @NonNull Size surfaceSize, @NonNull DynamicRange dynamicRange, @NonNull Range<Integer> expectedFrameRateRange) {
        EncoderProfilesProxy.VideoProfileProxy videoProfile = videoMimeInfo.getCompatibleVideoProfile();
        Object configSupplier = videoProfile != null ? new VideoEncoderConfigVideoProfileResolver(videoMimeInfo.getMimeType(), inputTimebase, videoSpec, surfaceSize, videoProfile, dynamicRange, expectedFrameRateRange) : new VideoEncoderConfigDefaultResolver(videoMimeInfo.getMimeType(), inputTimebase, videoSpec, surfaceSize, dynamicRange, expectedFrameRateRange);
        return (VideoEncoderConfig)configSupplier.get();
    }

    static int scaleAndClampBitrate(int baseBitrate, int actualBitDepth, int baseBitDepth, int actualFrameRate, int baseFrameRate, int actualWidth, int baseWidth, int actualHeight, int baseHeight, @NonNull Range<Integer> clampedRange) {
        Rational bitDepthRatio = new Rational(actualBitDepth, baseBitDepth);
        Rational frameRateRatio = new Rational(actualFrameRate, baseFrameRate);
        Rational widthRatio = new Rational(actualWidth, baseWidth);
        Rational heightRatio = new Rational(actualHeight, baseHeight);
        int resolvedBitrate = (int)((double)baseBitrate * bitDepthRatio.doubleValue() * frameRateRatio.doubleValue() * widthRatio.doubleValue() * heightRatio.doubleValue());
        String debugString = "";
        if (Logger.isDebugEnabled((String)TAG)) {
            debugString = String.format("Base Bitrate(%dbps) * Bit Depth Ratio (%d / %d) * Frame Rate Ratio(%d / %d) * Width Ratio(%d / %d) * Height Ratio(%d / %d) = %d", baseBitrate, actualBitDepth, baseBitDepth, actualFrameRate, baseFrameRate, actualWidth, baseWidth, actualHeight, baseHeight, resolvedBitrate);
        }
        if (!VideoSpec.BITRATE_RANGE_AUTO.equals(clampedRange)) {
            resolvedBitrate = (Integer)clampedRange.clamp((Comparable)Integer.valueOf(resolvedBitrate));
            if (Logger.isDebugEnabled((String)TAG)) {
                debugString = debugString + String.format("\nClamped to range %s -> %dbps", clampedRange, resolvedBitrate);
            }
        }
        Logger.d((String)TAG, (String)debugString);
        return resolvedBitrate;
    }

    @NonNull
    public static VideoEncoderDataSpace mimeAndProfileToEncoderDataSpace(@NonNull String mimeType, int codecProfileLevel) {
        VideoEncoderDataSpace dataSpace;
        Map<Integer, VideoEncoderDataSpace> profileToDataSpaceMap = MIME_TO_DATA_SPACE_MAP.get(mimeType);
        if (profileToDataSpaceMap != null && (dataSpace = profileToDataSpaceMap.get(codecProfileLevel)) != null) {
            return dataSpace;
        }
        Logger.w((String)TAG, (String)String.format("Unsupported mime type %s or profile level %d. Data space is unspecified.", mimeType, codecProfileLevel));
        return VideoEncoderDataSpace.ENCODER_DATA_SPACE_UNSPECIFIED;
    }

    static {
        HashMap<Integer, VideoEncoderDataSpace> profHevcMap = new HashMap<Integer, VideoEncoderDataSpace>();
        profHevcMap.put(1, VideoEncoderDataSpace.ENCODER_DATA_SPACE_UNSPECIFIED);
        profHevcMap.put(2, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_HLG);
        profHevcMap.put(4096, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_PQ);
        profHevcMap.put(8192, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_PQ);
        HashMap<Integer, VideoEncoderDataSpace> profAv1Map = new HashMap<Integer, VideoEncoderDataSpace>();
        profAv1Map.put(1, VideoEncoderDataSpace.ENCODER_DATA_SPACE_UNSPECIFIED);
        profAv1Map.put(2, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_HLG);
        profAv1Map.put(4096, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_PQ);
        profAv1Map.put(8192, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_PQ);
        HashMap<Integer, VideoEncoderDataSpace> profVp9Map = new HashMap<Integer, VideoEncoderDataSpace>();
        profVp9Map.put(1, VideoEncoderDataSpace.ENCODER_DATA_SPACE_UNSPECIFIED);
        profVp9Map.put(4, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_HLG);
        profVp9Map.put(4096, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_PQ);
        profVp9Map.put(16384, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_PQ);
        profVp9Map.put(2, VideoEncoderDataSpace.ENCODER_DATA_SPACE_UNSPECIFIED);
        profVp9Map.put(8, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_HLG);
        profVp9Map.put(8192, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_PQ);
        profVp9Map.put(32768, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_PQ);
        HashMap<Integer, VideoEncoderDataSpace> profDvMap = new HashMap<Integer, VideoEncoderDataSpace>();
        profDvMap.put(256, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT2020_HLG);
        profDvMap.put(512, VideoEncoderDataSpace.ENCODER_DATA_SPACE_BT709);
        MIME_TO_DATA_SPACE_MAP.put("video/hevc", profHevcMap);
        MIME_TO_DATA_SPACE_MAP.put("video/av01", profAv1Map);
        MIME_TO_DATA_SPACE_MAP.put("video/x-vnd.on2.vp9", profVp9Map);
        MIME_TO_DATA_SPACE_MAP.put("video/dolby-vision", profDvMap);
    }
}

