/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.audio;

import android.annotation.SuppressLint;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.video.internal.audio.AudioUtils;
import androidx.camera.video.internal.audio.AutoValue_AudioSettings;
import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RequiresApi(value=21)
@AutoValue
public abstract class AudioSettings {
    public static final List<Integer> COMMON_SAMPLE_RATES = Collections.unmodifiableList(Arrays.asList(48000, 44100, 22050, 11025, 8000, 4800));

    @SuppressLint(value={"Range"})
    @NonNull
    public static Builder builder() {
        return new AutoValue_AudioSettings.Builder().setAudioSource(-1).setSampleRate(-1).setChannelCount(-1).setAudioFormat(-1);
    }

    @NonNull
    public abstract Builder toBuilder();

    public abstract int getAudioSource();

    @IntRange(from=1L)
    public abstract int getSampleRate();

    @IntRange(from=1L)
    public abstract int getChannelCount();

    public abstract int getAudioFormat();

    AudioSettings() {
    }

    public int getBytesPerFrame() {
        return AudioUtils.getBytesPerFrame(this.getAudioFormat(), this.getChannelCount());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @NonNull
        public abstract Builder setAudioSource(int var1);

        @NonNull
        public abstract Builder setSampleRate(@IntRange(from=1L) int var1);

        @NonNull
        public abstract Builder setChannelCount(@IntRange(from=1L) int var1);

        @NonNull
        public abstract Builder setAudioFormat(int var1);

        abstract AudioSettings autoBuild();

        @NonNull
        public final AudioSettings build() {
            AudioSettings settings = this.autoBuild();
            String missingOrInvalid = "";
            if (settings.getAudioSource() == -1) {
                missingOrInvalid = missingOrInvalid + " audioSource";
            }
            if (settings.getSampleRate() <= 0) {
                missingOrInvalid = missingOrInvalid + " sampleRate";
            }
            if (settings.getChannelCount() <= 0) {
                missingOrInvalid = missingOrInvalid + " channelCount";
            }
            if (settings.getAudioFormat() == -1) {
                missingOrInvalid = missingOrInvalid + " audioFormat";
            }
            if (!missingOrInvalid.isEmpty()) {
                throw new IllegalArgumentException("Required settings missing or non-positive:" + missingOrInvalid);
            }
            return settings;
        }

        Builder() {
        }
    }
}

