/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.lifecycle;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.OptIn;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.ConcurrentCamera;
import androidx.camera.core.ExperimentalCameraInfo;
import androidx.camera.core.LayoutSettings;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.ViewPort;
import androidx.camera.core.concurrent.CameraCoordinator;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigProvider;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.ExtendedCameraConfigProviderStore;
import androidx.camera.core.impl.Identifier;
import androidx.camera.core.impl.RestrictedCameraInfo;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.ContextUtil;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.camera.lifecycle.ExperimentalCameraProviderConfiguration;
import androidx.camera.lifecycle.LifecycleCamera;
import androidx.camera.lifecycle.LifecycleCameraProvider;
import androidx.camera.lifecycle.LifecycleCameraRepository;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LifecycleOwner;
import androidx.tracing.Trace;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jk\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010.2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002012\b\u00103\u001a\u0004\u0018\u0001042\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001060\u00042\u0016\u00107\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010908\"\u0004\u0018\u000109H\u0001\u00a2\u0006\u0004\b:\u0010;J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020>H\u0007J5\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010<\u001a\u00020.2\u0016\u00107\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010908\"\u0004\u0018\u000109H\u0007\u00a2\u0006\u0002\u0010?J\u0018\u0010)\u001a\u00020@2\u000e\u0010A\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010B0\u0004H\u0007J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0002J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0018\u0010H\u001a\u00020I2\u0006\u0010<\u001a\u00020.2\u0006\u0010J\u001a\u00020\u0005H\u0002J\u0010\u0010K\u001a\u00020\u00052\u0006\u0010<\u001a\u00020.H\u0017J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010M\u001a\u00020$H\u0002J\u0010\u0010N\u001a\u00020\u00142\u0006\u0010<\u001a\u00020.H\u0016J\u0010\u0010O\u001a\u00020\u00142\u0006\u0010P\u001a\u000209H\u0016J\u0010\u0010Q\u001a\u00020\u00142\u0006\u0010P\u001a\u000209H\u0002J\u0010\u0010R\u001a\u00020\u00142\u0006\u0010P\u001a\u000209H\u0002J\u0010\u0010S\u001a\u00020D2\u0006\u0010T\u001a\u00020\u001bH\u0002J\u0010\u0010U\u001a\u00020D2\u0006\u0010M\u001a\u00020$H\u0002J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020!0\u001fH\u0007J%\u0010W\u001a\u00020D2\u0016\u00107\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010908\"\u0004\u0018\u000109H\u0017\u00a2\u0006\u0002\u0010XJ\b\u0010Y\u001a\u00020DH\u0017R0\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00048G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR$\u0010\r\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00178\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R \u0010 \u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010!0!0\u001f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Landroidx/camera/lifecycle/ProcessCameraProvider;", "Landroidx/camera/lifecycle/LifecycleCameraProvider;", "()V", "cameraInfos", "", "Landroidx/camera/core/CameraInfo;", "activeConcurrentCameraInfos", "getActiveConcurrentCameraInfos", "()Ljava/util/List;", "setActiveConcurrentCameraInfos", "(Ljava/util/List;)V", "availableConcurrentCameraInfos", "getAvailableConcurrentCameraInfos", "cameraOperatingMode", "", "getCameraOperatingMode", "()I", "setCameraOperatingMode", "(I)V", "isConcurrentCameraModeOn", "", "()Z", "mCameraInfoMap", "", "Landroidx/camera/core/internal/CameraUseCaseAdapter$CameraId;", "Landroidx/camera/core/impl/RestrictedCameraInfo;", "mCameraX", "Landroidx/camera/core/CameraX;", "mCameraXConfigProvider", "Landroidx/camera/core/CameraXConfig$Provider;", "mCameraXInitializeFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "mCameraXShutdownFuture", "Ljava/lang/Void;", "kotlin.jvm.PlatformType", "mContext", "Landroid/content/Context;", "mLifecycleCameraRepository", "Landroidx/camera/lifecycle/LifecycleCameraRepository;", "mLock", "", "bindToLifecycle", "Landroidx/camera/core/Camera;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "primaryCameraSelector", "Landroidx/camera/core/CameraSelector;", "secondaryCameraSelector", "primaryLayoutSettings", "Landroidx/camera/core/LayoutSettings;", "secondaryLayoutSettings", "viewPort", "Landroidx/camera/core/ViewPort;", "effects", "Landroidx/camera/core/CameraEffect;", "useCases", "", "Landroidx/camera/core/UseCase;", "bindToLifecycle$camera_lifecycle_release", "(Landroidx/lifecycle/LifecycleOwner;Landroidx/camera/core/CameraSelector;Landroidx/camera/core/CameraSelector;Landroidx/camera/core/LayoutSettings;Landroidx/camera/core/LayoutSettings;Landroidx/camera/core/ViewPort;Ljava/util/List;[Landroidx/camera/core/UseCase;)Landroidx/camera/core/Camera;", "cameraSelector", "useCaseGroup", "Landroidx/camera/core/UseCaseGroup;", "(Landroidx/lifecycle/LifecycleOwner;Landroidx/camera/core/CameraSelector;[Landroidx/camera/core/UseCase;)Landroidx/camera/core/Camera;", "Landroidx/camera/core/ConcurrentCamera;", "singleCameraConfigs", "Landroidx/camera/core/ConcurrentCamera$SingleCameraConfig;", "configureInstanceInternal", "", "cameraXConfig", "Landroidx/camera/core/CameraXConfig;", "getAvailableCameraInfos", "getCameraConfig", "Landroidx/camera/core/impl/CameraConfig;", "cameraInfo", "getCameraInfo", "getOrCreateCameraXInstance", "context", "hasCamera", "isBound", "useCase", "isPreview", "isVideoCapture", "setCameraX", "cameraX", "setContext", "shutdownAsync", "unbind", "([Landroidx/camera/core/UseCase;)V", "unbindAll", "Companion", "camera-lifecycle_release"})
@SourceDebugExtension(value={"SMAP\nProcessCameraProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessCameraProvider.kt\nandroidx/camera/lifecycle/ProcessCameraProvider\n+ 2 Trace.kt\nandroidx/tracing/TraceKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,995:1\n27#2,5:996\n27#2,3:1001\n31#2:1006\n27#2,3:1007\n31#2:1016\n27#2,3:1017\n31#2:1022\n27#2,5:1023\n27#2,5:1028\n27#2,5:1033\n27#2,5:1038\n27#2,5:1043\n27#2,5:1048\n27#2,5:1053\n37#3,2:1004\n37#3,2:1010\n37#3,2:1012\n37#3,2:1014\n1855#4,2:1020\n*S KotlinDebug\n*F\n+ 1 ProcessCameraProvider.kt\nandroidx/camera/lifecycle/ProcessCameraProvider\n*L\n204#1:996,5\n244#1:1001,3\n244#1:1006\n327#1:1007,3\n327#1:1016\n557#1:1017,3\n557#1:1022\n665#1:1023,5\n679#1:1028,5\n687#1:1033,5\n711#1:1038,5\n736#1:1043,5\n761#1:1048,5\n830#1:1053,5\n261#1:1004,2\n388#1:1010,2\n453#1:1012,2\n467#1:1014,2\n589#1:1020,2\n*E\n"})
public final class ProcessCameraProvider
implements LifecycleCameraProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    @Nullable
    private CameraXConfig.Provider mCameraXConfigProvider;
    @GuardedBy(value="mLock")
    @Nullable
    private ListenableFuture<CameraX> mCameraXInitializeFuture;
    @GuardedBy(value="mLock")
    @NotNull
    private ListenableFuture<Void> mCameraXShutdownFuture;
    @NotNull
    private final LifecycleCameraRepository mLifecycleCameraRepository;
    @Nullable
    private CameraX mCameraX;
    @Nullable
    private Context mContext;
    @GuardedBy(value="mLock")
    @NotNull
    private final Map<CameraUseCaseAdapter.CameraId, RestrictedCameraInfo> mCameraInfoMap;
    @NotNull
    private static final ProcessCameraProvider sAppInstance = new ProcessCameraProvider();

    private ProcessCameraProvider() {
        ListenableFuture listenableFuture = Futures.immediateFuture(null);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture<Void>(null)");
        this.mCameraXShutdownFuture = listenableFuture;
        this.mLifecycleCameraRepository = new LifecycleCameraRepository();
        this.mCameraInfoMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public final ListenableFuture<Void> shutdownAsync() {
        ListenableFuture listenableFuture;
        Threads.runOnMainSync(() -> ProcessCameraProvider.shutdownAsync$lambda$0(this));
        if (this.mCameraX != null) {
            CameraX cameraX = this.mCameraX;
            Intrinsics.checkNotNull((Object)cameraX);
            cameraX.getCameraFactory().getCameraCoordinator().shutdown();
        }
        if (this.mCameraX != null) {
            CameraX cameraX = this.mCameraX;
            Intrinsics.checkNotNull((Object)cameraX);
            listenableFuture = cameraX.shutdown();
        } else {
            listenableFuture = Futures.immediateFuture(null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"if (mCameraX != null) mC\u2026mediateFuture<Void>(null)");
        ListenableFuture shutdownFuture = listenableFuture;
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = false;
            this.mCameraXConfigProvider = null;
            this.mCameraXInitializeFuture = null;
            this.mCameraXShutdownFuture = shutdownFuture;
            this.mCameraInfoMap.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.mCameraX = null;
        this.mContext = null;
        return shutdownFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    @NotNull
    public final Camera bindToLifecycle(@NotNull LifecycleOwner lifecycleOwner, @NotNull CameraSelector cameraSelector, UseCase ... useCases) {
        Camera camera;
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)cameraSelector, (String)"cameraSelector");
        Intrinsics.checkNotNullParameter((Object)useCases, (String)"useCases");
        String label$iv = "CX:bindToLifecycle";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            Camera camera2;
            boolean bl = false;
            if (this.getCameraOperatingMode() == 2) {
                throw new UnsupportedOperationException("bindToLifecycle for single camera is not supported in concurrent camera mode, call unbindAll() first");
            }
            this.setCameraOperatingMode(1);
            LayoutSettings layoutSettings = LayoutSettings.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)layoutSettings, (String)"DEFAULT");
            LayoutSettings layoutSettings2 = LayoutSettings.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)layoutSettings2, (String)"DEFAULT");
            camera = camera2 = this.bindToLifecycle$camera_lifecycle_release(lifecycleOwner, cameraSelector, null, layoutSettings, layoutSettings2, null, CollectionsKt.emptyList(), Arrays.copyOf(useCases, useCases.length));
        }
        finally {
            Trace.endSection();
        }
        return camera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    @NotNull
    public final Camera bindToLifecycle(@NotNull LifecycleOwner lifecycleOwner, @NotNull CameraSelector cameraSelector, @NotNull UseCaseGroup useCaseGroup) {
        Camera camera;
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)cameraSelector, (String)"cameraSelector");
        Intrinsics.checkNotNullParameter((Object)useCaseGroup, (String)"useCaseGroup");
        String label$iv = "CX:bindToLifecycle-UseCaseGroup";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            Camera camera2;
            boolean bl = false;
            if (this.getCameraOperatingMode() == 2) {
                throw new UnsupportedOperationException("bindToLifecycle for single camera is not supported in concurrent camera mode, call unbindAll() first.");
            }
            this.setCameraOperatingMode(1);
            LayoutSettings layoutSettings = LayoutSettings.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)layoutSettings, (String)"DEFAULT");
            LayoutSettings layoutSettings2 = LayoutSettings.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)layoutSettings2, (String)"DEFAULT");
            ViewPort viewPort = useCaseGroup.getViewPort();
            List list = useCaseGroup.getEffects();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"useCaseGroup.effects");
            List list2 = useCaseGroup.getUseCases();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"useCaseGroup.useCases");
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            UseCase[] useCaseArray = thisCollection$iv.toArray(new UseCase[0]);
            camera = camera2 = this.bindToLifecycle$camera_lifecycle_release(lifecycleOwner, cameraSelector, null, layoutSettings, layoutSettings2, viewPort, list, Arrays.copyOf(useCaseArray, useCaseArray.length));
        }
        finally {
            Trace.endSection();
        }
        return camera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @OptIn(markerClass={ExperimentalCameraInfo.class})
    @MainThread
    @NotNull
    public final ConcurrentCamera bindToLifecycle(@NotNull List<ConcurrentCamera.SingleCameraConfig> singleCameraConfigs) {
        Intrinsics.checkNotNullParameter(singleCameraConfigs, (String)"singleCameraConfigs");
        label$iv = "CX:bindToLifecycle-Concurrent";
        $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            block22: {
                block23: {
                    block24: {
                        block21: {
                            $i$a$-trace-ProcessCameraProvider$bindToLifecycle$3 = false;
                            if (singleCameraConfigs.size() < 2) {
                                throw new IllegalArgumentException("Concurrent camera needs two camera configs.");
                            }
                            if (singleCameraConfigs.size() > 2) {
                                throw new IllegalArgumentException("Concurrent camera is only supporting two cameras at maximum.");
                            }
                            v0 = singleCameraConfigs.get(0);
                            Intrinsics.checkNotNull((Object)v0);
                            firstCameraConfig = v0;
                            v1 = singleCameraConfigs.get(1);
                            Intrinsics.checkNotNull((Object)v1);
                            secondCameraConfig = v1;
                            cameras = new ArrayList<E>();
                            if (!Intrinsics.areEqual((Object)firstCameraConfig.getCameraSelector().getLensFacing(), (Object)secondCameraConfig.getCameraSelector().getLensFacing())) break block21;
                            if (ProcessCameraProvider.access$getCameraOperatingMode(this) == 2) {
                                throw new UnsupportedOperationException("Camera is already running, call unbindAll() before binding more cameras.");
                            }
                            if (!(Intrinsics.areEqual((Object)firstCameraConfig.getLifecycleOwner(), (Object)secondCameraConfig.getLifecycleOwner()) && Intrinsics.areEqual((Object)firstCameraConfig.getUseCaseGroup().getViewPort(), (Object)secondCameraConfig.getUseCaseGroup().getViewPort()) && Intrinsics.areEqual((Object)firstCameraConfig.getUseCaseGroup().getEffects(), (Object)secondCameraConfig.getUseCaseGroup().getEffects()))) {
                                throw new IllegalArgumentException("Two camera configs need to have the same lifecycle owner, view port and effects.");
                            }
                            v2 = firstCameraConfig.getLifecycleOwner();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"firstCameraConfig.lifecycleOwner");
                            lifecycleOwner = v2;
                            v3 = firstCameraConfig.getCameraSelector();
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"firstCameraConfig.cameraSelector");
                            cameraSelector = v3;
                            viewPort = firstCameraConfig.getUseCaseGroup().getViewPort();
                            v4 = firstCameraConfig.getUseCaseGroup().getEffects();
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"firstCameraConfig.useCaseGroup.effects");
                            effects = v4;
                            useCases = new ArrayList<E>();
                            for (UseCase[] config : singleCameraConfigs) {
                                Intrinsics.checkNotNull((Object)config);
                                for (E v5 : config.getUseCaseGroup().getUseCases()) {
                                    Intrinsics.checkNotNullExpressionValue(v5, (String)"config!!.useCaseGroup.useCases");
                                    useCase = (UseCase)v5;
                                    if (config.getCameraSelector().getPhysicalCameraId() == null) continue;
                                    $i$a$-let-ProcessCameraProvider$bindToLifecycle$3$1 = false;
                                    useCase.setPhysicalCameraId(it);
                                }
                                v6 = config.getUseCaseGroup().getUseCases();
                                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"config.useCaseGroup.useCases");
                                useCases.addAll(v6);
                            }
                            ProcessCameraProvider.access$setCameraOperatingMode(this, 1);
                            v7 = LayoutSettings.DEFAULT;
                            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"DEFAULT");
                            v8 = LayoutSettings.DEFAULT;
                            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"DEFAULT");
                            $this$toTypedArray$iv = useCases;
                            $i$f$toTypedArray = false;
                            thisCollection$iv = $this$toTypedArray$iv;
                            config = thisCollection$iv.toArray(new UseCase[0]);
                            camera = this.bindToLifecycle$camera_lifecycle_release(lifecycleOwner, cameraSelector, null, v7, v8, viewPort, effects, Arrays.copyOf(config, config.length));
                            cameras.add(camera);
                            break block22;
                        }
                        v9 = ProcessCameraProvider.access$getMContext$p(this);
                        Intrinsics.checkNotNull((Object)v9);
                        if (!v9.getPackageManager().hasSystemFeature("android.hardware.camera.concurrent")) {
                            throw new UnsupportedOperationException("Concurrent camera is not supported on the device.");
                        }
                        if (ProcessCameraProvider.access$getCameraOperatingMode(this) == 1) {
                            throw new UnsupportedOperationException("Camera is already running, call unbindAll() before binding more cameras.");
                        }
                        cameraInfosToBind = new ArrayList<E>();
                        firstCameraInfo = null;
                        secondCameraInfo = null;
                        try {
                            v10 = firstCameraConfig.getCameraSelector();
                            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"firstCameraConfig.cameraSelector");
                            firstCameraInfo = this.getCameraInfo(v10);
                            v11 = secondCameraConfig.getCameraSelector();
                            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"secondCameraConfig.cameraSelector");
                            secondCameraInfo = this.getCameraInfo(v11);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Invalid camera selectors in camera configs.");
                        }
                        cameraInfosToBind.add(firstCameraInfo);
                        cameraInfosToBind.add(secondCameraInfo);
                        if (((Collection)ProcessCameraProvider.access$getActiveConcurrentCameraInfos(this)).isEmpty() == false && !Intrinsics.areEqual((Object)cameraInfosToBind, (Object)ProcessCameraProvider.access$getActiveConcurrentCameraInfos(this))) {
                            throw new UnsupportedOperationException("Cameras are already running, call unbindAll() before binding more cameras.");
                        }
                        ProcessCameraProvider.access$setCameraOperatingMode(this, 2);
                        isDualCameraVideoCapture = false;
                        if (!Objects.equals(firstCameraConfig.getUseCaseGroup().getUseCases(), secondCameraConfig.getUseCaseGroup().getUseCases()) || firstCameraConfig.getUseCaseGroup().getUseCases().size() != 2) break block23;
                        useCase0 = (UseCase)firstCameraConfig.getUseCaseGroup().getUseCases().get(0);
                        useCase1 = (UseCase)firstCameraConfig.getUseCaseGroup().getUseCases().get(1);
                        Intrinsics.checkNotNullExpressionValue((Object)useCase0, (String)"useCase0");
                        if (!ProcessCameraProvider.access$isVideoCapture(this, useCase0)) break block24;
                        Intrinsics.checkNotNullExpressionValue((Object)useCase1, (String)"useCase1");
                        if (ProcessCameraProvider.access$isPreview(this, useCase1)) ** GOTO lbl-1000
                    }
                    if (ProcessCameraProvider.access$isPreview(this, useCase0)) {
                        Intrinsics.checkNotNullExpressionValue((Object)useCase1, (String)"useCase1");
                        ** if (!ProcessCameraProvider.access$isVideoCapture((ProcessCameraProvider)this, (UseCase)useCase1)) goto lbl-1000
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        v12 = true;
                        ** GOTO lbl108
                    }
lbl-1000:
                    // 2 sources

                    {
                        v12 = isDualCameraVideoCapture = false;
                    }
                }
                if (isDualCameraVideoCapture) {
                    v13 = firstCameraConfig.getLifecycleOwner();
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"firstCameraConfig.lifecycleOwner");
                    v14 = firstCameraConfig.getCameraSelector();
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"firstCameraConfig.cameraSelector");
                    v15 = secondCameraConfig.getCameraSelector();
                    v16 = firstCameraConfig.getLayoutSettings();
                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"firstCameraConfig.layoutSettings");
                    v17 = secondCameraConfig.getLayoutSettings();
                    Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"secondCameraConfig.layoutSettings");
                    v18 = firstCameraConfig.getUseCaseGroup().getViewPort();
                    v19 = firstCameraConfig.getUseCaseGroup().getEffects();
                    Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"firstCameraConfig.useCaseGroup.effects");
                    v20 = firstCameraConfig.getUseCaseGroup().getUseCases();
                    Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"firstCameraConfig.useCaseGroup.useCases");
                    $this$toTypedArray$iv = v20;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    var12_18 = thisCollection$iv.toArray(new UseCase[0]);
                    cameras.add(this.bindToLifecycle$camera_lifecycle_release(v13, v14, v15, v16, v17, v18, v19, Arrays.copyOf(var12_18, var12_18.length)));
                } else {
                    var12_18 = singleCameraConfigs.iterator();
                    while (var12_18.hasNext()) {
                        v21 = config = var12_18.next();
                        Intrinsics.checkNotNull((Object)v21);
                        v22 = v21.getLifecycleOwner();
                        Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"config!!.lifecycleOwner");
                        v23 = config.getCameraSelector();
                        Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"config.cameraSelector");
                        v24 = LayoutSettings.DEFAULT;
                        Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"DEFAULT");
                        v25 = LayoutSettings.DEFAULT;
                        Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"DEFAULT");
                        v26 = config.getUseCaseGroup().getViewPort();
                        v27 = config.getUseCaseGroup().getEffects();
                        Intrinsics.checkNotNullExpressionValue((Object)v27, (String)"config.useCaseGroup.effects");
                        v28 = config.getUseCaseGroup().getUseCases();
                        Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"config.useCaseGroup.useCases");
                        $this$toTypedArray$iv = v28;
                        $i$f$toTypedArray = false;
                        thisCollection$iv = $this$toTypedArray$iv;
                        var15_26 = thisCollection$iv.toArray(new UseCase[0]);
                        camera = this.bindToLifecycle$camera_lifecycle_release(v22, v23, null, v24, v25, v26, v27, Arrays.copyOf(var15_26, var15_26.length));
                        cameras.add(camera);
                    }
                }
                ProcessCameraProvider.access$setActiveConcurrentCameraInfos(this, cameraInfosToBind);
            }
            var21_35 = new ConcurrentCamera(cameras);
        }
        finally {
            Trace.endSection();
        }
        return var21_35;
    }

    private final boolean isVideoCapture(UseCase useCase) {
        return useCase.getCurrentConfig().containsOption(UseCaseConfig.OPTION_CAPTURE_TYPE) && useCase.getCurrentConfig().getCaptureType() == UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE;
    }

    private final boolean isPreview(UseCase useCase) {
        return useCase instanceof Preview;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OptIn(markerClass={ExperimentalCameraInfo.class})
    @NotNull
    public final Camera bindToLifecycle$camera_lifecycle_release(@NotNull LifecycleOwner lifecycleOwner, @NotNull CameraSelector primaryCameraSelector, @Nullable CameraSelector secondaryCameraSelector, @NotNull LayoutSettings primaryLayoutSettings, @NotNull LayoutSettings secondaryLayoutSettings, @Nullable ViewPort viewPort, @NotNull List<? extends CameraEffect> effects, UseCase ... useCases) {
        LifecycleCamera lifecycleCamera;
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)primaryCameraSelector, (String)"primaryCameraSelector");
        Intrinsics.checkNotNullParameter((Object)primaryLayoutSettings, (String)"primaryLayoutSettings");
        Intrinsics.checkNotNullParameter((Object)secondaryLayoutSettings, (String)"secondaryLayoutSettings");
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        Intrinsics.checkNotNullParameter((Object)useCases, (String)"useCases");
        String label$iv = "CX:bindToLifecycle-internal";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            LifecycleCamera lifecycleCamera2;
            boolean bl = false;
            Threads.checkMainThread();
            CameraX cameraX = this.mCameraX;
            Intrinsics.checkNotNull((Object)cameraX);
            CameraInternal cameraInternal = primaryCameraSelector.select(cameraX.getCameraRepository().getCameras());
            Intrinsics.checkNotNullExpressionValue((Object)cameraInternal, (String)"primaryCameraSelector.se\u2026cameraRepository.cameras)");
            CameraInternal primaryCameraInternal = cameraInternal;
            primaryCameraInternal.setPrimary(true);
            CameraInfo cameraInfo = this.getCameraInfo(primaryCameraSelector);
            Intrinsics.checkNotNull((Object)cameraInfo, (String)"null cannot be cast to non-null type androidx.camera.core.impl.RestrictedCameraInfo");
            RestrictedCameraInfo primaryRestrictedCameraInfo = (RestrictedCameraInfo)cameraInfo;
            CameraInternal secondaryCameraInternal = null;
            RestrictedCameraInfo secondaryRestrictedCameraInfo = null;
            if (secondaryCameraSelector != null) {
                CameraX cameraX2 = this.mCameraX;
                Intrinsics.checkNotNull((Object)cameraX2);
                secondaryCameraInternal = secondaryCameraSelector.select(cameraX2.getCameraRepository().getCameras());
                secondaryCameraInternal.setPrimary(false);
                CameraInfo cameraInfo2 = this.getCameraInfo(secondaryCameraSelector);
                Intrinsics.checkNotNull((Object)cameraInfo2, (String)"null cannot be cast to non-null type androidx.camera.core.impl.RestrictedCameraInfo");
                secondaryRestrictedCameraInfo = (RestrictedCameraInfo)cameraInfo2;
            }
            LifecycleCamera lifecycleCameraToBind = null;
            lifecycleCameraToBind = this.mLifecycleCameraRepository.getLifecycleCamera(lifecycleOwner, CameraUseCaseAdapter.generateCameraId((RestrictedCameraInfo)primaryRestrictedCameraInfo, secondaryRestrictedCameraInfo));
            Collection<LifecycleCamera> lifecycleCameras = this.mLifecycleCameraRepository.getLifecycleCameras();
            Iterable $this$forEach$iv = ArraysKt.filterNotNull((Object[])useCases);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UseCase useCase = (UseCase)element$iv;
                boolean bl2 = false;
                Iterator<LifecycleCamera> iterator = lifecycleCameras.iterator();
                while (iterator.hasNext()) {
                    LifecycleCamera lifecycleCamera3;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"lifecycleCameras");
                    if (!lifecycleCamera3.isBound(useCase) || Intrinsics.areEqual((Object)lifecycleCamera3, (Object)lifecycleCameraToBind)) continue;
                    String string = "Use case %s already bound to a different lifecycle.";
                    Object[] objectArray = new Object[]{useCase};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    throw new IllegalStateException(string2);
                }
            }
            if (lifecycleCameraToBind == null) {
                LifecycleCameraRepository lifecycleCameraRepository = this.mLifecycleCameraRepository;
                CameraX cameraX3 = this.mCameraX;
                Intrinsics.checkNotNull((Object)cameraX3);
                CameraCoordinator cameraCoordinator = cameraX3.getCameraFactory().getCameraCoordinator();
                CameraX cameraX4 = this.mCameraX;
                Intrinsics.checkNotNull((Object)cameraX4);
                CameraDeviceSurfaceManager cameraDeviceSurfaceManager = cameraX4.getCameraDeviceSurfaceManager();
                CameraX cameraX5 = this.mCameraX;
                Intrinsics.checkNotNull((Object)cameraX5);
                lifecycleCameraToBind = lifecycleCameraRepository.createLifecycleCamera(lifecycleOwner, new CameraUseCaseAdapter(primaryCameraInternal, secondaryCameraInternal, primaryRestrictedCameraInfo, secondaryRestrictedCameraInfo, primaryLayoutSettings, secondaryLayoutSettings, cameraCoordinator, cameraDeviceSurfaceManager, cameraX5.getDefaultConfigFactory()));
            }
            if (useCases.length == 0) {
                LifecycleCamera lifecycleCamera4 = lifecycleCameraToBind;
                lifecycleCamera2 = lifecycleCamera4;
                Intrinsics.checkNotNull((Object)lifecycleCamera4);
            } else {
                LifecycleCameraRepository lifecycleCameraRepository = this.mLifecycleCameraRepository;
                LifecycleCamera lifecycleCamera5 = lifecycleCameraToBind;
                Intrinsics.checkNotNull((Object)lifecycleCamera5);
                Collection collection = CollectionsKt.listOf((Object[])Arrays.copyOf(useCases, useCases.length));
                CameraX cameraX6 = this.mCameraX;
                Intrinsics.checkNotNull((Object)cameraX6);
                lifecycleCameraRepository.bindToLifecycleCamera(lifecycleCamera5, viewPort, effects, collection, cameraX6.getCameraFactory().getCameraCoordinator());
                lifecycleCamera2 = lifecycleCameraToBind;
            }
            lifecycleCamera = lifecycleCamera2;
        }
        finally {
            Trace.endSection();
        }
        return lifecycleCamera;
    }

    @Override
    public boolean isBound(@NotNull UseCase useCase) {
        Intrinsics.checkNotNullParameter((Object)useCase, (String)"useCase");
        Iterator<LifecycleCamera> iterator = this.mLifecycleCameraRepository.getLifecycleCameras().iterator();
        while (iterator.hasNext()) {
            LifecycleCamera lifecycleCamera;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"mLifecycleCameraRepository.lifecycleCameras");
            if (!lifecycleCamera.isBound(useCase)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @MainThread
    public void unbind(UseCase ... useCases) {
        Intrinsics.checkNotNullParameter((Object)useCases, (String)"useCases");
        String label$iv = "CX:unbind";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            boolean bl = false;
            Threads.checkMainThread();
            if (this.getCameraOperatingMode() == 2) {
                throw new UnsupportedOperationException("Unbind usecase is not supported in concurrent camera mode, call unbindAll() first.");
            }
            this.mLifecycleCameraRepository.unbind(CollectionsKt.listOf((Object[])Arrays.copyOf(useCases, useCases.length)));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Trace.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @MainThread
    public void unbindAll() {
        String label$iv = "CX:unbindAll";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            boolean bl = false;
            Threads.checkMainThread();
            this.setCameraOperatingMode(0);
            this.mLifecycleCameraRepository.unbindAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Trace.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCamera(@NotNull CameraSelector cameraSelector) throws CameraInfoUnavailableException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cameraSelector, (String)"cameraSelector");
        String label$iv = "CX:hasCamera";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            boolean bl2;
            block5: {
                boolean bl3 = false;
                try {
                    CameraX cameraX = this.mCameraX;
                    Intrinsics.checkNotNull((Object)cameraX);
                    cameraSelector.select(cameraX.getCameraRepository().getCameras());
                }
                catch (IllegalArgumentException e) {
                    bl2 = false;
                    break block5;
                }
                bl2 = true;
            }
            bl = bl2;
        }
        finally {
            Trace.endSection();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<CameraInfo> getAvailableCameraInfos() {
        List list;
        String label$iv = "CX:getAvailableCameraInfos";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            boolean bl = false;
            List availableCameraInfos = new ArrayList();
            CameraX cameraX = this.mCameraX;
            Intrinsics.checkNotNull((Object)cameraX);
            LinkedHashSet linkedHashSet = cameraX.getCameraRepository().getCameras();
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashSet, (String)"mCameraX!!.cameraRepository.cameras");
            Set cameras = linkedHashSet;
            for (CameraInternal camera : cameras) {
                CameraInfo cameraInfo = camera.getCameraInfo();
                Intrinsics.checkNotNullExpressionValue((Object)cameraInfo, (String)"camera.cameraInfo");
                availableCameraInfos.add(cameraInfo);
            }
            list = availableCameraInfos;
        }
        finally {
            Trace.endSection();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OptIn(markerClass={ExperimentalCameraInfo.class})
    @NotNull
    public final List<List<CameraInfo>> getAvailableConcurrentCameraInfos() {
        List list;
        String label$iv = "CX:getAvailableConcurrentCameraInfos";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            boolean bl = false;
            Objects.requireNonNull(this.mCameraX);
            CameraX cameraX = this.mCameraX;
            Intrinsics.checkNotNull((Object)cameraX);
            Objects.requireNonNull(cameraX.getCameraFactory().getCameraCoordinator());
            CameraX cameraX2 = this.mCameraX;
            Intrinsics.checkNotNull((Object)cameraX2);
            List list2 = cameraX2.getCameraFactory().getCameraCoordinator().getConcurrentCameraSelectors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"mCameraX!!.cameraFactory\u2026concurrentCameraSelectors");
            List concurrentCameraSelectorLists = list2;
            List availableConcurrentCameraInfos = new ArrayList();
            for (List cameraSelectors : concurrentCameraSelectorLists) {
                List cameraInfos = new ArrayList();
                for (CameraSelector cameraSelector : cameraSelectors) {
                    CameraInfo cameraInfo = null;
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)cameraSelector, (String)"cameraSelector");
                        cameraInfo = this.getCameraInfo(cameraSelector);
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    cameraInfos.add(cameraInfo);
                }
                availableConcurrentCameraInfos.add(cameraInfos);
            }
            list = availableConcurrentCameraInfos;
        }
        finally {
            Trace.endSection();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalCameraInfo
    @NotNull
    public CameraInfo getCameraInfo(@NotNull CameraSelector cameraSelector) {
        RestrictedCameraInfo restrictedCameraInfo;
        Intrinsics.checkNotNullParameter((Object)cameraSelector, (String)"cameraSelector");
        String label$iv = "CX:getCameraInfo";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            boolean bl = false;
            CameraX cameraX = this.mCameraX;
            Intrinsics.checkNotNull((Object)cameraX);
            CameraInfoInternal cameraInfoInternal = cameraSelector.select(cameraX.getCameraRepository().getCameras()).getCameraInfoInternal();
            Intrinsics.checkNotNullExpressionValue((Object)cameraInfoInternal, (String)"cameraSelector.select(mC\u2026meras).cameraInfoInternal");
            CameraInfoInternal cameraInfoInternal2 = cameraInfoInternal;
            CameraConfig cameraConfig = this.getCameraConfig(cameraSelector, (CameraInfo)cameraInfoInternal2);
            CameraUseCaseAdapter.CameraId cameraId = CameraUseCaseAdapter.CameraId.create((String)cameraInfoInternal2.getCameraId(), (Identifier)cameraConfig.getCompatibilityId());
            Intrinsics.checkNotNullExpressionValue((Object)cameraId, (String)"create(\n                \u2026ilityId\n                )");
            CameraUseCaseAdapter.CameraId key = cameraId;
            RestrictedCameraInfo restrictedCameraInfo2 = null;
            Object object = this.mLock;
            synchronized (object) {
                boolean bl2 = false;
                restrictedCameraInfo2 = (RestrictedCameraInfo)this.mCameraInfoMap.get(key);
                if (restrictedCameraInfo2 == null) {
                    restrictedCameraInfo2 = new RestrictedCameraInfo(cameraInfoInternal2, cameraConfig);
                    this.mCameraInfoMap.put(key, restrictedCameraInfo2);
                }
                Unit unit = Unit.INSTANCE;
            }
            restrictedCameraInfo = restrictedCameraInfo2;
        }
        finally {
            Trace.endSection();
        }
        return (CameraInfo)restrictedCameraInfo;
    }

    @MainThread
    public final boolean isConcurrentCameraModeOn() {
        return this.getCameraOperatingMode() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ListenableFuture<CameraX> getOrCreateCameraXInstance(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (this.mCameraXInitializeFuture == null) break block4;
                ListenableFuture<CameraX> listenableFuture = this.mCameraXInitializeFuture;
                Intrinsics.checkNotNull(listenableFuture, (String)"null cannot be cast to non-null type com.google.common.util.concurrent.ListenableFuture<androidx.camera.core.CameraX>");
                ListenableFuture<CameraX> listenableFuture2 = listenableFuture;
                return listenableFuture2;
            }
            CameraX cameraX = new CameraX(context, this.mCameraXConfigProvider);
            this.mCameraXInitializeFuture = CallbackToFutureAdapter.getFuture(arg_0 -> ProcessCameraProvider.getOrCreateCameraXInstance$lambda$18$lambda$17(this, cameraX, arg_0));
            ListenableFuture<CameraX> listenableFuture = this.mCameraXInitializeFuture;
            Intrinsics.checkNotNull(listenableFuture, (String)"null cannot be cast to non-null type com.google.common.util.concurrent.ListenableFuture<androidx.camera.core.CameraX>");
            ListenableFuture<CameraX> listenableFuture3 = listenableFuture;
            return listenableFuture3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void configureInstanceInternal(CameraXConfig cameraXConfig) {
        String label$iv = "CX:configureInstanceInternal";
        boolean $i$f$trace = false;
        Trace.beginSection((String)label$iv);
        try {
            boolean bl = false;
            Object object = this.mLock;
            synchronized (object) {
                boolean bl2 = false;
                Preconditions.checkNotNull((Object)cameraXConfig);
                Preconditions.checkState((this.mCameraXConfigProvider == null ? 1 : 0) != 0, (String)"CameraX has already been configured. To use a different configuration, shutdown() must be called.");
                this.mCameraXConfigProvider = new CameraXConfig.Provider(cameraXConfig){
                    final /* synthetic */ CameraXConfig $cameraXConfig;
                    {
                        this.$cameraXConfig = $cameraXConfig;
                    }

                    @NotNull
                    public final CameraXConfig getCameraXConfig() {
                        return this.$cameraXConfig;
                    }
                };
                Unit unit = Unit.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Trace.endSection();
        }
    }

    private final CameraConfig getCameraConfig(CameraSelector cameraSelector, CameraInfo cameraInfo) {
        CameraConfig cameraConfig = null;
        for (Object e : cameraSelector.getCameraFilterSet()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"cameraSelector.cameraFilterSet");
            CameraFilter cameraFilter = (CameraFilter)e;
            if (Intrinsics.areEqual((Object)cameraFilter.getIdentifier(), (Object)CameraFilter.DEFAULT_ID)) continue;
            CameraConfigProvider cameraConfigProvider = ExtendedCameraConfigProviderStore.getConfigProvider((Object)cameraFilter.getIdentifier());
            Context context = this.mContext;
            Intrinsics.checkNotNull((Object)context);
            CameraConfig extendedCameraConfig = cameraConfigProvider.getConfig(cameraInfo, context);
            if (extendedCameraConfig == null) continue;
            if (cameraConfig != null) {
                throw new IllegalArgumentException("Cannot apply multiple extended camera configs at the same time.");
            }
            cameraConfig = extendedCameraConfig;
        }
        if (cameraConfig == null) {
            cameraConfig = CameraConfigs.defaultConfig();
        }
        return cameraConfig;
    }

    private final void setCameraX(CameraX cameraX) {
        this.mCameraX = cameraX;
    }

    private final void setContext(Context context) {
        this.mContext = context;
    }

    private final int getCameraOperatingMode() {
        if (this.mCameraX == null) {
            return 0;
        }
        CameraX cameraX = this.mCameraX;
        Intrinsics.checkNotNull((Object)cameraX);
        return cameraX.getCameraFactory().getCameraCoordinator().getCameraOperatingMode();
    }

    private final void setCameraOperatingMode(int cameraOperatingMode) {
        if (this.mCameraX == null) {
            return;
        }
        CameraX cameraX = this.mCameraX;
        Intrinsics.checkNotNull((Object)cameraX);
        cameraX.getCameraFactory().getCameraCoordinator().setCameraOperatingMode(cameraOperatingMode);
    }

    private final List<CameraInfo> getActiveConcurrentCameraInfos() {
        if (this.mCameraX == null) {
            return new ArrayList();
        }
        CameraX cameraX = this.mCameraX;
        Intrinsics.checkNotNull((Object)cameraX);
        List list = cameraX.getCameraFactory().getCameraCoordinator().getActiveConcurrentCameraInfos();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mCameraX!!.cameraFactory\u2026tiveConcurrentCameraInfos");
        return list;
    }

    private final void setActiveConcurrentCameraInfos(List<? extends CameraInfo> cameraInfos) {
        if (this.mCameraX == null) {
            return;
        }
        CameraX cameraX = this.mCameraX;
        Intrinsics.checkNotNull((Object)cameraX);
        cameraX.getCameraFactory().getCameraCoordinator().setActiveConcurrentCameraInfos(cameraInfos);
    }

    private static final void shutdownAsync$lambda$0(ProcessCameraProvider this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.unbindAll();
        this$0.mLifecycleCameraRepository.clear();
    }

    private static final ListenableFuture getOrCreateCameraXInstance$lambda$18$lambda$17$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ListenableFuture)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object getOrCreateCameraXInstance$lambda$18$lambda$17(ProcessCameraProvider this$0, CameraX $cameraX, CallbackToFutureAdapter.Completer completer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cameraX, (String)"$cameraX");
        Intrinsics.checkNotNullParameter((Object)completer, (String)"completer");
        Object object = this$0.mLock;
        synchronized (object) {
            boolean bl = false;
            FutureChain futureChain = FutureChain.from(this$0.mCameraXShutdownFuture).transformAsync(arg_0 -> ProcessCameraProvider.getOrCreateCameraXInstance$lambda$18$lambda$17$lambda$16$lambda$15((Function1)new Function1<Void, ListenableFuture<Void>>($cameraX){
                final /* synthetic */ CameraX $cameraX;
                {
                    this.$cameraX = $cameraX;
                    super(1);
                }

                @NotNull
                public final ListenableFuture<Void> invoke(@Nullable Void it) {
                    return this.$cameraX.getInitializeFuture();
                }
            }, arg_0), CameraXExecutors.directExecutor());
            Intrinsics.checkNotNullExpressionValue((Object)futureChain, (String)"cameraX = CameraX(contex\u2026                        )");
            ListenableFuture future2 = (ListenableFuture)futureChain;
            Futures.addCallback((ListenableFuture)future2, (FutureCallback)((FutureCallback)new FutureCallback<Void>((CallbackToFutureAdapter.Completer<CameraX>)completer, $cameraX){
                final /* synthetic */ CallbackToFutureAdapter.Completer<CameraX> $completer;
                final /* synthetic */ CameraX $cameraX;
                {
                    this.$completer = $completer;
                    this.$cameraX = $cameraX;
                }

                public void onSuccess(@Nullable Void result) {
                    this.$completer.set((Object)this.$cameraX);
                }

                public void onFailure(@NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    this.$completer.setException(t);
                }
            }), (Executor)CameraXExecutors.directExecutor());
            Unit unit = Unit.INSTANCE;
        }
        return "ProcessCameraProvider-initializeCameraX";
    }

    @JvmStatic
    @NotNull
    public static final ListenableFuture<ProcessCameraProvider> getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    @JvmStatic
    @ExperimentalCameraProviderConfiguration
    public static final void configureInstance(@NotNull CameraXConfig cameraXConfig) {
        Companion.configureInstance(cameraXConfig);
    }

    public static final /* synthetic */ void access$setCameraX(ProcessCameraProvider $this, CameraX cameraX) {
        $this.setCameraX(cameraX);
    }

    public static final /* synthetic */ void access$setContext(ProcessCameraProvider $this, Context context) {
        $this.setContext(context);
    }

    public static final /* synthetic */ Context access$getMContext$p(ProcessCameraProvider $this) {
        return $this.mContext;
    }

    public static final /* synthetic */ List access$getActiveConcurrentCameraInfos(ProcessCameraProvider $this) {
        return $this.getActiveConcurrentCameraInfos();
    }

    public static final /* synthetic */ boolean access$isVideoCapture(ProcessCameraProvider $this, UseCase useCase) {
        return $this.isVideoCapture(useCase);
    }

    public static final /* synthetic */ boolean access$isPreview(ProcessCameraProvider $this, UseCase useCase) {
        return $this.isPreview(useCase);
    }

    public static final /* synthetic */ void access$setActiveConcurrentCameraInfos(ProcessCameraProvider $this, List cameraInfos) {
        $this.setActiveConcurrentCameraInfos(cameraInfos);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/camera/lifecycle/ProcessCameraProvider$Companion;", "", "()V", "sAppInstance", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "configureInstance", "", "cameraXConfig", "Landroidx/camera/core/CameraXConfig;", "getInstance", "Lcom/google/common/util/concurrent/ListenableFuture;", "context", "Landroid/content/Context;", "camera-lifecycle_release"})
    @SourceDebugExtension(value={"SMAP\nProcessCameraProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessCameraProvider.kt\nandroidx/camera/lifecycle/ProcessCameraProvider$Companion\n+ 2 Trace.kt\nandroidx/tracing/TraceKt\n*L\n1#1,995:1\n27#2,5:996\n*S KotlinDebug\n*F\n+ 1 ProcessCameraProvider.kt\nandroidx/camera/lifecycle/ProcessCameraProvider$Companion\n*L\n992#1:996,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ListenableFuture<ProcessCameraProvider> getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Preconditions.checkNotNull((Object)context);
            ListenableFuture listenableFuture = Futures.transform((ListenableFuture)sAppInstance.getOrCreateCameraXInstance(context), arg_0 -> Companion.getInstance$lambda$0((Function1)new Function1<CameraX, ProcessCameraProvider>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(1);
                }

                public final ProcessCameraProvider invoke(CameraX cameraX) {
                    ProcessCameraProvider processCameraProvider = ProcessCameraProvider.access$getSAppInstance$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)cameraX, (String)"cameraX");
                    ProcessCameraProvider.access$setCameraX(processCameraProvider, cameraX);
                    ProcessCameraProvider processCameraProvider2 = ProcessCameraProvider.access$getSAppInstance$cp();
                    Context context = ContextUtil.getApplicationContext((Context)this.$context);
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(context)");
                    ProcessCameraProvider.access$setContext(processCameraProvider2, context);
                    return ProcessCameraProvider.access$getSAppInstance$cp();
                }
            }, arg_0), (Executor)CameraXExecutors.directExecutor());
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"context: Context): Liste\u2026tExecutor()\n            )");
            return listenableFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @ExperimentalCameraProviderConfiguration
        public final void configureInstance(@NotNull CameraXConfig cameraXConfig) {
            Intrinsics.checkNotNullParameter((Object)cameraXConfig, (String)"cameraXConfig");
            String label$iv = "CX:configureInstance";
            boolean $i$f$trace = false;
            Trace.beginSection((String)label$iv);
            try {
                boolean bl = false;
                sAppInstance.configureInstanceInternal(cameraXConfig);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                Trace.endSection();
            }
        }

        private static final ProcessCameraProvider getInstance$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ProcessCameraProvider)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

