/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.sessionprocessor;

import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.extensions.internal.sessionprocessor.Camera2OutputConfig;
import androidx.camera.extensions.internal.sessionprocessor.Camera2SessionConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
class Camera2SessionConfigBuilder {
    private int mSessionTemplateId = 1;
    private Map<CaptureRequest.Key<?>, Object> mSessionParameters = new HashMap();
    private List<Camera2OutputConfig> mCamera2OutputConfigs = new ArrayList<Camera2OutputConfig>();

    Camera2SessionConfigBuilder() {
    }

    @NonNull
    Camera2SessionConfigBuilder addOutputConfig(@NonNull Camera2OutputConfig outputConfig) {
        this.mCamera2OutputConfigs.add(outputConfig);
        return this;
    }

    @NonNull
    <T> Camera2SessionConfigBuilder addSessionParameter(@NonNull CaptureRequest.Key<T> key, @Nullable T value) {
        this.mSessionParameters.put(key, value);
        return this;
    }

    @NonNull
    Camera2SessionConfigBuilder setSessionTemplateId(int templateId) {
        this.mSessionTemplateId = templateId;
        return this;
    }

    int getSessionTemplateId() {
        return this.mSessionTemplateId;
    }

    @NonNull
    Map<CaptureRequest.Key<?>, Object> getSessionParameters() {
        return this.mSessionParameters;
    }

    @NonNull
    List<Camera2OutputConfig> getCamera2OutputConfigs() {
        return this.mCamera2OutputConfigs;
    }

    @NonNull
    Camera2SessionConfig build() {
        return new SessionConfigImpl(this.mSessionTemplateId, this.mSessionParameters, this.mCamera2OutputConfigs);
    }

    private static class SessionConfigImpl
    implements Camera2SessionConfig {
        private final int mSessionTemplateId;
        private final Map<CaptureRequest.Key<?>, Object> mSessionParameters;
        private final List<Camera2OutputConfig> mCamera2OutputConfigs;

        SessionConfigImpl(int sessionTemplateId, Map<CaptureRequest.Key<?>, Object> sessionParameters, List<Camera2OutputConfig> camera2OutputConfigs) {
            this.mSessionTemplateId = sessionTemplateId;
            this.mSessionParameters = sessionParameters;
            this.mCamera2OutputConfigs = camera2OutputConfigs;
        }

        @Override
        @NonNull
        public List<Camera2OutputConfig> getOutputConfigs() {
            return this.mCamera2OutputConfigs;
        }

        @Override
        @NonNull
        public Map<CaptureRequest.Key<?>, Object> getSessionParameters() {
            return this.mSessionParameters;
        }

        @Override
        public int getSessionTemplateId() {
            return this.mSessionTemplateId;
        }
    }
}

