/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.sessionprocessor;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.extensions.impl.advanced.Camera2OutputConfigImpl;
import androidx.camera.extensions.impl.advanced.ImageReaderOutputConfigImpl;
import androidx.camera.extensions.impl.advanced.MultiResolutionImageReaderOutputConfigImpl;
import androidx.camera.extensions.impl.advanced.SurfaceOutputConfigImpl;
import androidx.camera.extensions.internal.sessionprocessor.Camera2OutputConfig;
import androidx.camera.extensions.internal.sessionprocessor.ImageReaderOutputConfig;
import androidx.camera.extensions.internal.sessionprocessor.MultiResolutionImageReaderOutputConfig;
import androidx.camera.extensions.internal.sessionprocessor.SurfaceOutputConfig;
import java.util.ArrayList;

@RequiresApi(value=21)
class Camera2OutputConfigConverter {
    private Camera2OutputConfigConverter() {
    }

    @NonNull
    static Camera2OutputConfig fromImpl(@NonNull Camera2OutputConfigImpl impl) {
        ArrayList<Camera2OutputConfig> sharedOutputConfigs = new ArrayList<Camera2OutputConfig>();
        if (impl.getSurfaceSharingOutputConfigs() != null) {
            for (Camera2OutputConfigImpl surfaceSharingOutputConfig : impl.getSurfaceSharingOutputConfigs()) {
                Camera2OutputConfig sharedConfig = Camera2OutputConfigConverter.fromImpl(surfaceSharingOutputConfig);
                sharedOutputConfigs.add(sharedConfig);
            }
        }
        if (impl instanceof SurfaceOutputConfigImpl) {
            SurfaceOutputConfigImpl surfaceImpl = (SurfaceOutputConfigImpl)impl;
            return SurfaceOutputConfig.create(surfaceImpl.getId(), surfaceImpl.getSurfaceGroupId(), surfaceImpl.getPhysicalCameraId(), sharedOutputConfigs, surfaceImpl.getSurface());
        }
        if (impl instanceof ImageReaderOutputConfigImpl) {
            ImageReaderOutputConfigImpl imageReaderImpl = (ImageReaderOutputConfigImpl)impl;
            return ImageReaderOutputConfig.create(imageReaderImpl.getId(), imageReaderImpl.getSurfaceGroupId(), imageReaderImpl.getPhysicalCameraId(), sharedOutputConfigs, imageReaderImpl.getSize(), imageReaderImpl.getImageFormat(), imageReaderImpl.getMaxImages());
        }
        if (impl instanceof MultiResolutionImageReaderOutputConfigImpl) {
            MultiResolutionImageReaderOutputConfigImpl multiResolutionImageReaderImpl = (MultiResolutionImageReaderOutputConfigImpl)impl;
            return MultiResolutionImageReaderOutputConfig.create(multiResolutionImageReaderImpl.getId(), multiResolutionImageReaderImpl.getSurfaceGroupId(), multiResolutionImageReaderImpl.getPhysicalCameraId(), sharedOutputConfigs, multiResolutionImageReaderImpl.getImageFormat(), multiResolutionImageReaderImpl.getMaxImages());
        }
        throw new IllegalArgumentException("Not supported Camera2OutputConfigImpl: " + impl.getClass());
    }
}

