/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.compat.quirk;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Quirk;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.Version;

@RequiresApi(value=21)
public class ExtensionDisabledQuirk
implements Quirk {
    private boolean mIsAdvancedInterface = ExtensionDisabledQuirk.isAdvancedExtenderSupported();

    static boolean load() {
        return ExtensionDisabledQuirk.isPixel5() || ExtensionDisabledQuirk.isMotoRazr5G() || ExtensionDisabledQuirk.isAdvancedExtenderSupported();
    }

    public boolean shouldDisableExtension(@NonNull String cameraId, int extensionMode) {
        if (this.mIsAdvancedInterface) {
            return true;
        }
        if (ExtensionDisabledQuirk.isPixel5() && !this.mIsAdvancedInterface) {
            return true;
        }
        return ExtensionDisabledQuirk.isMotoRazr5G() && ("0".equals(cameraId) || "1".equals(cameraId)) && 1 == extensionMode;
    }

    private static boolean isPixel5() {
        return "google".equalsIgnoreCase(Build.BRAND) && "redfin".equalsIgnoreCase(Build.DEVICE);
    }

    private static boolean isMotoRazr5G() {
        return "motorola".equalsIgnoreCase(Build.BRAND) && "smith".equalsIgnoreCase(Build.DEVICE);
    }

    private static boolean isAdvancedExtenderSupported() {
        if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_2) < 0) {
            return false;
        }
        return ExtensionVersion.isAdvancedExtenderSupported();
    }
}

