/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.extensions.impl.advanced.AdvancedExtenderImpl;
import androidx.camera.extensions.impl.advanced.AutoAdvancedExtenderImpl;
import androidx.camera.extensions.impl.advanced.BeautyAdvancedExtenderImpl;
import androidx.camera.extensions.impl.advanced.BokehAdvancedExtenderImpl;
import androidx.camera.extensions.impl.advanced.HdrAdvancedExtenderImpl;
import androidx.camera.extensions.impl.advanced.NightAdvancedExtenderImpl;
import androidx.camera.extensions.internal.VendorExtender;
import androidx.camera.extensions.internal.compat.workaround.ExtensionDisabledValidator;
import androidx.camera.extensions.internal.sessionprocessor.AdvancedSessionProcessor;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
public class AdvancedVendorExtender
implements VendorExtender {
    private final ExtensionDisabledValidator mExtensionDisabledValidator = new ExtensionDisabledValidator();
    private final AdvancedExtenderImpl mAdvancedExtenderImpl;
    private String mCameraId;
    private final int mMode;

    public AdvancedVendorExtender(int mode) {
        this.mMode = mode;
        try {
            switch (mode) {
                case 1: {
                    this.mAdvancedExtenderImpl = new BokehAdvancedExtenderImpl();
                    break;
                }
                case 2: {
                    this.mAdvancedExtenderImpl = new HdrAdvancedExtenderImpl();
                    break;
                }
                case 3: {
                    this.mAdvancedExtenderImpl = new NightAdvancedExtenderImpl();
                    break;
                }
                case 4: {
                    this.mAdvancedExtenderImpl = new BeautyAdvancedExtenderImpl();
                    break;
                }
                case 5: {
                    this.mAdvancedExtenderImpl = new AutoAdvancedExtenderImpl();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Should not active ExtensionMode.NONE");
                }
            }
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalArgumentException("AdvancedExtenderImpl does not exist");
        }
    }

    @Override
    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public void init(@NonNull CameraInfo cameraInfo) {
        this.mCameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
        Map cameraCharacteristicsMap = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraCharacteristicsMap();
        this.mAdvancedExtenderImpl.init(this.mCameraId, cameraCharacteristicsMap);
    }

    @Override
    public boolean isExtensionAvailable(@NonNull String cameraId, @NonNull Map<String, CameraCharacteristics> characteristicsMap) {
        if (this.mExtensionDisabledValidator.shouldDisableExtension(cameraId, this.mMode)) {
            return false;
        }
        return this.mAdvancedExtenderImpl.isExtensionAvailable(cameraId, characteristicsMap);
    }

    @Override
    @Nullable
    public Range<Long> getEstimatedCaptureLatencyRange(@Nullable Size size) {
        Preconditions.checkNotNull((Object)this.mCameraId, (Object)"VendorExtender#init() must be called first");
        return this.mAdvancedExtenderImpl.getEstimatedCaptureLatencyRange(this.mCameraId, size, 256);
    }

    @Override
    @NonNull
    public List<Pair<Integer, Size[]>> getSupportedPreviewOutputResolutions() {
        Preconditions.checkNotNull((Object)this.mCameraId, (Object)"VendorExtender#init() must be called first");
        return this.convertResolutionMapToList(this.mAdvancedExtenderImpl.getSupportedPreviewOutputResolutions(this.mCameraId));
    }

    @Override
    @NonNull
    public List<Pair<Integer, Size[]>> getSupportedCaptureOutputResolutions() {
        Preconditions.checkNotNull((Object)this.mCameraId, (Object)"VendorExtender#init() must be called first");
        return this.convertResolutionMapToList(this.mAdvancedExtenderImpl.getSupportedCaptureOutputResolutions(this.mCameraId));
    }

    @NonNull
    private List<Pair<Integer, Size[]>> convertResolutionMapToList(@NonNull Map<Integer, List<Size>> map) {
        ArrayList<Pair> result = new ArrayList<Pair>();
        for (Integer imageFormat : map.keySet()) {
            Size[] sizeArray = map.get(imageFormat).toArray(new Size[0]);
            result.add(new Pair((Object)imageFormat, (Object)sizeArray));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    @NonNull
    public Size[] getSupportedYuvAnalysisResolutions() {
        Preconditions.checkNotNull((Object)this.mCameraId, (Object)"VendorExtender#init() must be called first");
        List yuvList = this.mAdvancedExtenderImpl.getSupportedYuvAnalysisResolutions(this.mCameraId);
        return yuvList == null ? new Size[]{} : yuvList.toArray(new Size[0]);
    }

    @Override
    @Nullable
    public SessionProcessor createSessionProcessor(@NonNull Context context) {
        Preconditions.checkNotNull((Object)this.mCameraId, (Object)"VendorExtender#init() must be called first");
        return new AdvancedSessionProcessor(this.mAdvancedExtenderImpl.createSessionProcessor(), context);
    }
}

