/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.content.Context;
import android.util.Range;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraProvider;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.utils.ContextUtil;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.extensions.ExtensionsInfo;
import androidx.camera.extensions.impl.InitializerImpl;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.Version;
import androidx.camera.extensions.internal.VersionName;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class ExtensionsManager {
    private static final String TAG = "ExtensionsManager";
    private static final Object EXTENSIONS_LOCK = new Object();
    @GuardedBy(value="EXTENSIONS_LOCK")
    private static ListenableFuture<ExtensionsManager> sInitializeFuture;
    @GuardedBy(value="EXTENSIONS_LOCK")
    private static ListenableFuture<Void> sDeinitializeFuture;
    @GuardedBy(value="EXTENSIONS_LOCK")
    private static ExtensionsManager sExtensionsManager;
    private final ExtensionsAvailability mExtensionsAvailability;
    private final ExtensionsInfo mExtensionsInfo;

    @NonNull
    public static ListenableFuture<ExtensionsManager> getInstanceAsync(@NonNull Context context, @NonNull CameraProvider cameraProvider) {
        return ExtensionsManager.getInstanceAsync(context, cameraProvider, VersionName.getCurrentVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ListenableFuture<ExtensionsManager> getInstanceAsync(@NonNull Context context, final @NonNull CameraProvider cameraProvider, @NonNull VersionName versionName) {
        Object object = EXTENSIONS_LOCK;
        synchronized (object) {
            if (sDeinitializeFuture != null && !sDeinitializeFuture.isDone()) {
                throw new IllegalStateException("Not yet done deinitializing extensions");
            }
            sDeinitializeFuture = null;
            if (ExtensionVersion.getRuntimeVersion() == null) {
                return Futures.immediateFuture((Object)ExtensionsManager.getOrCreateExtensionsManager(ExtensionsAvailability.NONE, cameraProvider));
            }
            if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) < 0) {
                return Futures.immediateFuture((Object)ExtensionsManager.getOrCreateExtensionsManager(ExtensionsAvailability.LIBRARY_AVAILABLE, cameraProvider));
            }
            if (sInitializeFuture == null) {
                sInitializeFuture = CallbackToFutureAdapter.getFuture(completer -> {
                    try {
                        InitializerImpl.init((String)versionName.toVersionString(), (Context)ContextUtil.getApplicationContext((Context)context), (InitializerImpl.OnExtensionsInitializedCallback)new InitializerImpl.OnExtensionsInitializedCallback(){

                            public void onSuccess() {
                                Logger.d((String)ExtensionsManager.TAG, (String)"Successfully initialized extensions");
                                completer.set((Object)ExtensionsManager.getOrCreateExtensionsManager(ExtensionsAvailability.LIBRARY_AVAILABLE, cameraProvider));
                            }

                            public void onFailure(int error) {
                                Logger.e((String)ExtensionsManager.TAG, (String)"Failed to initialize extensions");
                                completer.set((Object)ExtensionsManager.getOrCreateExtensionsManager(ExtensionsAvailability.LIBRARY_UNAVAILABLE_ERROR_LOADING, cameraProvider));
                            }
                        }, (Executor)CameraXExecutors.directExecutor());
                    }
                    catch (AbstractMethodError | NoClassDefFoundError | NoSuchMethodError e) {
                        Logger.e((String)TAG, (String)("Failed to initialize extensions. Some classes or methods are missed in the vendor library. " + e));
                        completer.set((Object)ExtensionsManager.getOrCreateExtensionsManager(ExtensionsAvailability.LIBRARY_UNAVAILABLE_MISSING_IMPLEMENTATION, cameraProvider));
                    }
                    catch (RuntimeException e) {
                        Logger.e((String)TAG, (String)("Failed to initialize extensions. Something wents wrong when initializing the vendor library. " + e));
                        completer.set((Object)ExtensionsManager.getOrCreateExtensionsManager(ExtensionsAvailability.LIBRARY_UNAVAILABLE_ERROR_LOADING, cameraProvider));
                    }
                    return "Initialize extensions";
                });
            }
            return sInitializeFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    @NonNull
    public ListenableFuture<Void> shutdown() {
        Object object = EXTENSIONS_LOCK;
        synchronized (object) {
            ExtensionsAvailability availability;
            if (ExtensionVersion.getRuntimeVersion() == null) {
                sInitializeFuture = null;
                sExtensionsManager = null;
                return Futures.immediateFuture(null);
            }
            if (sInitializeFuture == null) {
                return Futures.immediateFuture(null);
            }
            if (sDeinitializeFuture != null) {
                return sDeinitializeFuture;
            }
            try {
                sInitializeFuture.get();
                sInitializeFuture = null;
                availability = ExtensionsManager.sExtensionsManager.mExtensionsAvailability;
                sExtensionsManager = null;
            }
            catch (InterruptedException | ExecutionException e) {
                sDeinitializeFuture = Futures.immediateFailedFuture((Throwable)e);
                return sDeinitializeFuture;
            }
            sDeinitializeFuture = availability == ExtensionsAvailability.LIBRARY_AVAILABLE ? CallbackToFutureAdapter.getFuture(completer -> {
                try {
                    InitializerImpl.deinit((InitializerImpl.OnExtensionsDeinitializedCallback)new InitializerImpl.OnExtensionsDeinitializedCallback(){

                        public void onSuccess() {
                            completer.set(null);
                        }

                        public void onFailure(int error) {
                            completer.setException((Throwable)new Exception("Failed to deinitialize extensions."));
                        }
                    }, (Executor)CameraXExecutors.directExecutor());
                }
                catch (NoClassDefFoundError | NoSuchMethodError e) {
                    completer.setException((Throwable)e);
                }
                return null;
            }) : Futures.immediateFuture(null);
            return sDeinitializeFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExtensionsManager getOrCreateExtensionsManager(@NonNull ExtensionsAvailability extensionsAvailability, @NonNull CameraProvider cameraProvider) {
        Object object = EXTENSIONS_LOCK;
        synchronized (object) {
            if (sExtensionsManager != null) {
                return sExtensionsManager;
            }
            sExtensionsManager = new ExtensionsManager(extensionsAvailability, cameraProvider);
            return sExtensionsManager;
        }
    }

    @NonNull
    public CameraSelector getExtensionEnabledCameraSelector(@NonNull CameraSelector baseCameraSelector, int mode) {
        if (mode == 0) {
            return baseCameraSelector;
        }
        if (this.mExtensionsAvailability != ExtensionsAvailability.LIBRARY_AVAILABLE) {
            throw new IllegalArgumentException("This device doesn't support extensions function! isExtensionAvailable should be checked first before calling getExtensionEnabledCameraSelector.");
        }
        return this.mExtensionsInfo.getExtensionCameraSelectorAndInjectCameraConfig(baseCameraSelector, mode);
    }

    public boolean isExtensionAvailable(@NonNull CameraSelector baseCameraSelector, int mode) {
        if (mode == 0) {
            return true;
        }
        if (this.mExtensionsAvailability != ExtensionsAvailability.LIBRARY_AVAILABLE) {
            return false;
        }
        return this.mExtensionsInfo.isExtensionAvailable(baseCameraSelector, mode);
    }

    @Nullable
    public Range<Long> getEstimatedCaptureLatencyRange(@NonNull CameraSelector cameraSelector, int mode) {
        if (mode == 0 || this.mExtensionsAvailability != ExtensionsAvailability.LIBRARY_AVAILABLE) {
            throw new IllegalArgumentException("No camera can be found to support the specified extensions mode! isExtensionAvailable should be checked first before calling getEstimatedCaptureLatencyRange.");
        }
        return this.mExtensionsInfo.getEstimatedCaptureLatencyRange(cameraSelector, mode, null);
    }

    @VisibleForTesting
    @NonNull
    ExtensionsAvailability getExtensionsAvailability() {
        return this.mExtensionsAvailability;
    }

    private ExtensionsManager(@NonNull ExtensionsAvailability extensionsAvailability, @NonNull CameraProvider cameraProvider) {
        this.mExtensionsAvailability = extensionsAvailability;
        this.mExtensionsInfo = new ExtensionsInfo(cameraProvider);
    }

    static enum ExtensionsAvailability {
        LIBRARY_AVAILABLE,
        LIBRARY_UNAVAILABLE_ERROR_LOADING,
        LIBRARY_UNAVAILABLE_MISSING_IMPLEMENTATION,
        NONE;

    }
}

