/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraProvider;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.impl.CameraConfigProvider;
import androidx.camera.core.impl.ExtendedCameraConfigProviderStore;
import androidx.camera.core.impl.Identifier;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.extensions.ExtensionCameraFilter;
import androidx.camera.extensions.ExtensionsConfig;
import androidx.camera.extensions.internal.AdvancedVendorExtender;
import androidx.camera.extensions.internal.BasicVendorExtender;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.ExtensionsUseCaseConfigFactory;
import androidx.camera.extensions.internal.VendorExtender;
import androidx.camera.extensions.internal.Version;
import java.util.List;

@RequiresApi(value=21)
final class ExtensionsInfo {
    private static final String EXTENDED_CAMERA_CONFIG_PROVIDER_ID_PREFIX = ":camera:camera-extensions-";
    private final CameraProvider mCameraProvider;

    ExtensionsInfo(@NonNull CameraProvider cameraProvider) {
        this.mCameraProvider = cameraProvider;
    }

    @NonNull
    CameraSelector getExtensionCameraSelectorAndInjectCameraConfig(@NonNull CameraSelector baseCameraSelector, int mode) {
        if (!this.isExtensionAvailable(baseCameraSelector, mode)) {
            throw new IllegalArgumentException("No camera can be found to support the specified extensions mode! isExtensionAvailable should be checked first before calling getExtensionEnabledCameraSelector.");
        }
        for (CameraFilter cameraFilter : baseCameraSelector.getCameraFilterSet()) {
            if (!(cameraFilter instanceof ExtensionCameraFilter)) continue;
            throw new IllegalArgumentException("An extension is already applied to the base CameraSelector.");
        }
        ExtensionsInfo.injectExtensionCameraConfig(mode);
        CameraSelector.Builder builder = CameraSelector.Builder.fromSelector((CameraSelector)baseCameraSelector);
        builder.addCameraFilter(ExtensionsInfo.getFilter(mode));
        return builder.build();
    }

    boolean isExtensionAvailable(@NonNull CameraSelector baseCameraSelector, int mode) {
        CameraSelector.Builder builder = CameraSelector.Builder.fromSelector((CameraSelector)baseCameraSelector);
        builder.addCameraFilter(ExtensionsInfo.getFilter(mode));
        List cameraInfos = builder.build().filter(this.mCameraProvider.getAvailableCameraInfos());
        return !cameraInfos.isEmpty();
    }

    @Nullable
    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    Range<Long> getEstimatedCaptureLatencyRange(@NonNull CameraSelector cameraSelector, int mode, @Nullable Size resolution) {
        CameraSelector newCameraSelector = CameraSelector.Builder.fromSelector((CameraSelector)cameraSelector).addCameraFilter(ExtensionsInfo.getFilter(mode)).build();
        List cameraInfos = newCameraSelector.filter(this.mCameraProvider.getAvailableCameraInfos());
        if (cameraInfos.isEmpty()) {
            throw new IllegalArgumentException("No cameras found for given CameraSelector");
        }
        CameraInfo extensionsCameraInfo = (CameraInfo)cameraInfos.get(0);
        if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_2) < 0) {
            return null;
        }
        try {
            VendorExtender vendorExtender = ExtensionsInfo.getVendorExtender(mode);
            vendorExtender.init(extensionsCameraInfo);
            return vendorExtender.getEstimatedCaptureLatencyRange(resolution);
        }
        catch (NoSuchMethodError e) {
            return null;
        }
    }

    private static CameraFilter getFilter(int mode) {
        String id = ExtensionsInfo.getExtendedCameraConfigProviderId(mode);
        VendorExtender vendorExtender = ExtensionsInfo.getVendorExtender(mode);
        ExtensionCameraFilter filter = new ExtensionCameraFilter(id, vendorExtender);
        return filter;
    }

    private static void injectExtensionCameraConfig(int mode) {
        Identifier id = Identifier.create((Object)ExtensionsInfo.getExtendedCameraConfigProviderId(mode));
        if (ExtendedCameraConfigProviderStore.getConfigProvider((Object)id) == CameraConfigProvider.EMPTY) {
            ExtendedCameraConfigProviderStore.addConfig((Object)id, (cameraInfo, context) -> {
                VendorExtender vendorExtender = ExtensionsInfo.getVendorExtender(mode);
                vendorExtender.init(cameraInfo);
                ExtensionsUseCaseConfigFactory factory = new ExtensionsUseCaseConfigFactory(mode, vendorExtender, context);
                ExtensionsConfig.Builder builder = new ExtensionsConfig.Builder().setExtensionMode(mode).setUseCaseConfigFactory(factory).setCompatibilityId(id).setZslDisabled(true).setUseCaseCombinationRequiredRule(1);
                SessionProcessor sessionProcessor = vendorExtender.createSessionProcessor(context);
                if (sessionProcessor != null) {
                    builder.setSessionProcessor(sessionProcessor);
                }
                return builder.build();
            });
        }
    }

    @NonNull
    private static VendorExtender getVendorExtender(int mode) {
        boolean isAdvancedExtenderSupported = ExtensionsInfo.isAdvancedExtenderSupported();
        VendorExtender vendorExtender = isAdvancedExtenderSupported ? new AdvancedVendorExtender(mode) : new BasicVendorExtender(mode);
        return vendorExtender;
    }

    private static boolean isAdvancedExtenderSupported() {
        if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_2) < 0) {
            return false;
        }
        return ExtensionVersion.isAdvancedExtenderSupported();
    }

    private static String getExtendedCameraConfigProviderId(int mode) {
        String id;
        switch (mode) {
            case 1: {
                id = ":camera:camera-extensions-EXTENSION_MODE_BOKEH";
                break;
            }
            case 2: {
                id = ":camera:camera-extensions-EXTENSION_MODE_HDR";
                break;
            }
            case 3: {
                id = ":camera:camera-extensions-EXTENSION_MODE_NIGHT";
                break;
            }
            case 4: {
                id = ":camera:camera-extensions-EXTENSION_MODE_FACE_RETOUCH";
                break;
            }
            case 5: {
                id = ":camera:camera-extensions-EXTENSION_MODE_AUTO";
                break;
            }
            case 0: {
                id = ":camera:camera-extensions-EXTENSION_MODE_NONE";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid extension mode!");
            }
        }
        return id;
    }
}

