/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.UseCaseConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DynamicRangeUtils {
    private DynamicRangeUtils() {
    }

    @Nullable
    public static DynamicRange resolveDynamicRange(@NonNull Set<UseCaseConfig<?>> useCaseConfigs) {
        ArrayList<DynamicRange> dynamicRanges = new ArrayList<DynamicRange>();
        for (UseCaseConfig<?> useCaseConfig : useCaseConfigs) {
            dynamicRanges.add(useCaseConfig.getDynamicRange());
        }
        return DynamicRangeUtils.intersectDynamicRange(dynamicRanges);
    }

    @Nullable
    private static DynamicRange intersectDynamicRange(@NonNull List<DynamicRange> dynamicRanges) {
        if (dynamicRanges.isEmpty()) {
            return null;
        }
        DynamicRange firstDynamicRange = dynamicRanges.get(0);
        Integer resultEncoding = firstDynamicRange.getEncoding();
        Integer resultBitDepth = firstDynamicRange.getBitDepth();
        for (int i = 1; i < dynamicRanges.size(); ++i) {
            DynamicRange childDynamicRange = dynamicRanges.get(i);
            resultEncoding = DynamicRangeUtils.intersectDynamicRangeEncoding(resultEncoding, childDynamicRange.getEncoding());
            resultBitDepth = DynamicRangeUtils.intersectDynamicRangeBitDepth(resultBitDepth, childDynamicRange.getBitDepth());
            if (resultEncoding != null && resultBitDepth != null) continue;
            return null;
        }
        return new DynamicRange(resultEncoding, resultBitDepth);
    }

    @Nullable
    private static Integer intersectDynamicRangeEncoding(@NonNull Integer encoding1, @NonNull Integer encoding2) {
        if (encoding1.equals(0)) {
            return encoding2;
        }
        if (encoding2.equals(0)) {
            return encoding1;
        }
        if (encoding1.equals(2) && !encoding2.equals(1)) {
            return encoding2;
        }
        if (encoding2.equals(2) && !encoding1.equals(1)) {
            return encoding1;
        }
        return encoding1.equals(encoding2) ? encoding1 : null;
    }

    @Nullable
    private static Integer intersectDynamicRangeBitDepth(@NonNull Integer bitDepth1, @NonNull Integer bitDepth2) {
        if (bitDepth1.equals(0)) {
            return bitDepth2;
        }
        if (bitDepth2.equals(0)) {
            return bitDepth1;
        }
        return bitDepth1.equals(bitDepth2) ? bitDepth1 : null;
    }
}

