/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.annotation.Nullable;
import androidx.camera.core.resolutionselector.ResolutionSelector;

public class ResolutionSelectorUtil {
    private ResolutionSelectorUtil() {
    }

    @Nullable
    public static ResolutionSelector overrideResolutionSelectors(@Nullable ResolutionSelector baseResolutionSelector, @Nullable ResolutionSelector resolutionSelectorToOverride) {
        if (resolutionSelectorToOverride == null) {
            return baseResolutionSelector;
        }
        if (baseResolutionSelector == null) {
            return resolutionSelectorToOverride;
        }
        ResolutionSelector.Builder builder = ResolutionSelector.Builder.fromResolutionSelector(baseResolutionSelector);
        if (resolutionSelectorToOverride.getAspectRatioStrategy() != null) {
            builder.setAspectRatioStrategy(resolutionSelectorToOverride.getAspectRatioStrategy());
        }
        if (resolutionSelectorToOverride.getResolutionStrategy() != null) {
            builder.setResolutionStrategy(resolutionSelectorToOverride.getResolutionStrategy());
        }
        if (resolutionSelectorToOverride.getResolutionFilter() != null) {
            builder.setResolutionFilter(resolutionSelectorToOverride.getResolutionFilter());
        }
        if (resolutionSelectorToOverride.getAllowedResolutionMode() != 0) {
            builder.setAllowedResolutionMode(resolutionSelectorToOverride.getAllowedResolutionMode());
        }
        return builder.build();
    }
}

