/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

final class ByteOrderedDataInputStream
extends InputStream
implements DataInput {
    private static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    private static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    private final DataInputStream mDataInputStream;
    private ByteOrder mByteOrder = ByteOrder.BIG_ENDIAN;
    final int mLength;
    int mPosition;

    ByteOrderedDataInputStream(InputStream in) throws IOException {
        this(in, ByteOrder.BIG_ENDIAN);
    }

    ByteOrderedDataInputStream(InputStream in, ByteOrder byteOrder) throws IOException {
        this.mDataInputStream = new DataInputStream(in);
        this.mLength = this.mDataInputStream.available();
        this.mPosition = 0;
        this.mDataInputStream.mark(this.mLength);
        this.mByteOrder = byteOrder;
    }

    ByteOrderedDataInputStream(byte[] bytes) throws IOException {
        this(new ByteArrayInputStream(bytes));
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.mByteOrder = byteOrder;
    }

    public void seek(long byteCount) throws IOException {
        if ((long)this.mPosition > byteCount) {
            this.mPosition = 0;
            this.mDataInputStream.reset();
            this.mDataInputStream.mark(this.mLength);
        } else {
            byteCount -= (long)this.mPosition;
        }
        if (this.skipBytes((int)byteCount) != (int)byteCount) {
            throw new IOException("Couldn't seek up to the byteCount");
        }
    }

    public int peek() {
        return this.mPosition;
    }

    @Override
    public int available() throws IOException {
        return this.mDataInputStream.available();
    }

    @Override
    public int read() throws IOException {
        ++this.mPosition;
        return this.mDataInputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.mDataInputStream.read(b, off, len);
        this.mPosition += bytesRead;
        return bytesRead;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        ++this.mPosition;
        return this.mDataInputStream.readUnsignedByte();
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException("readLine() not implemented.");
    }

    @Override
    public boolean readBoolean() throws IOException {
        ++this.mPosition;
        return this.mDataInputStream.readBoolean();
    }

    @Override
    public char readChar() throws IOException {
        this.mPosition += 2;
        return this.mDataInputStream.readChar();
    }

    @Override
    public String readUTF() throws IOException {
        this.mPosition += 2;
        return this.mDataInputStream.readUTF();
    }

    @Override
    public void readFully(byte[] buffer, int offset, int length) throws IOException {
        this.mPosition += length;
        if (this.mPosition > this.mLength) {
            throw new EOFException();
        }
        if (this.mDataInputStream.read(buffer, offset, length) != length) {
            throw new IOException("Couldn't read up to the length of buffer");
        }
    }

    @Override
    public void readFully(byte[] buffer) throws IOException {
        this.mPosition += buffer.length;
        if (this.mPosition > this.mLength) {
            throw new EOFException();
        }
        if (this.mDataInputStream.read(buffer, 0, buffer.length) != buffer.length) {
            throw new IOException("Couldn't read up to the length of buffer");
        }
    }

    @Override
    public byte readByte() throws IOException {
        ++this.mPosition;
        if (this.mPosition > this.mLength) {
            throw new EOFException();
        }
        int ch = this.mDataInputStream.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        this.mPosition += 2;
        if (this.mPosition > this.mLength) {
            throw new EOFException();
        }
        int ch1 = this.mDataInputStream.read();
        if ((ch1 | (ch2 = this.mDataInputStream.read())) < 0) {
            throw new EOFException();
        }
        if (this.mByteOrder == LITTLE_ENDIAN) {
            return (short)((ch2 << 8) + ch1);
        }
        if (this.mByteOrder == BIG_ENDIAN) {
            return (short)((ch1 << 8) + ch2);
        }
        throw new IOException("Invalid byte order: " + this.mByteOrder);
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        this.mPosition += 4;
        if (this.mPosition > this.mLength) {
            throw new EOFException();
        }
        int ch1 = this.mDataInputStream.read();
        if ((ch1 | (ch2 = this.mDataInputStream.read()) | (ch3 = this.mDataInputStream.read()) | (ch4 = this.mDataInputStream.read())) < 0) {
            throw new EOFException();
        }
        if (this.mByteOrder == LITTLE_ENDIAN) {
            return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
        }
        if (this.mByteOrder == BIG_ENDIAN) {
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }
        throw new IOException("Invalid byte order: " + this.mByteOrder);
    }

    @Override
    public int skipBytes(int byteCount) throws IOException {
        int skipped;
        int totalSkip = Math.min(byteCount, this.mLength - this.mPosition);
        for (skipped = 0; skipped < totalSkip; skipped += this.mDataInputStream.skipBytes(totalSkip - skipped)) {
        }
        this.mPosition += skipped;
        return skipped;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        this.mPosition += 2;
        if (this.mPosition > this.mLength) {
            throw new EOFException();
        }
        int ch1 = this.mDataInputStream.read();
        if ((ch1 | (ch2 = this.mDataInputStream.read())) < 0) {
            throw new EOFException();
        }
        if (this.mByteOrder == LITTLE_ENDIAN) {
            return (ch2 << 8) + ch1;
        }
        if (this.mByteOrder == BIG_ENDIAN) {
            return (ch1 << 8) + ch2;
        }
        throw new IOException("Invalid byte order: " + this.mByteOrder);
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() throws IOException {
        int ch8;
        int ch7;
        int ch6;
        int ch5;
        int ch4;
        int ch3;
        int ch2;
        this.mPosition += 8;
        if (this.mPosition > this.mLength) {
            throw new EOFException();
        }
        int ch1 = this.mDataInputStream.read();
        if ((ch1 | (ch2 = this.mDataInputStream.read()) | (ch3 = this.mDataInputStream.read()) | (ch4 = this.mDataInputStream.read()) | (ch5 = this.mDataInputStream.read()) | (ch6 = this.mDataInputStream.read()) | (ch7 = this.mDataInputStream.read()) | (ch8 = this.mDataInputStream.read())) < 0) {
            throw new EOFException();
        }
        if (this.mByteOrder == LITTLE_ENDIAN) {
            return ((long)ch8 << 56) + ((long)ch7 << 48) + ((long)ch6 << 40) + ((long)ch5 << 32) + ((long)ch4 << 24) + ((long)ch3 << 16) + ((long)ch2 << 8) + (long)ch1;
        }
        if (this.mByteOrder == BIG_ENDIAN) {
            return ((long)ch1 << 56) + ((long)ch2 << 48) + ((long)ch3 << 40) + ((long)ch4 << 32) + ((long)ch5 << 24) + ((long)ch6 << 16) + ((long)ch7 << 8) + (long)ch8;
        }
        throw new IOException("Invalid byte order: " + this.mByteOrder);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readlimit) {
        DataInputStream dataInputStream = this.mDataInputStream;
        synchronized (dataInputStream) {
            this.mDataInputStream.mark(readlimit);
        }
    }

    public int getLength() {
        return this.mLength;
    }
}

