/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.utils.Optional;
import androidx.core.util.Preconditions;
import androidx.core.util.Supplier;

final class Absent<T>
extends Optional<T> {
    static final Absent<Object> sInstance = new Absent();
    private static final long serialVersionUID = 0L;

    static <T> Optional<T> withType() {
        return sInstance;
    }

    private Absent() {
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    @NonNull
    public T get() {
        throw new IllegalStateException("Optional.get() cannot be called on an absent value");
    }

    @Override
    @NonNull
    public T or(@NonNull T defaultValue) {
        return (T)Preconditions.checkNotNull(defaultValue, (Object)"use Optional.orNull() instead of Optional.or(null)");
    }

    @Override
    @NonNull
    public Optional<T> or(@NonNull Optional<? extends T> secondChoice) {
        return (Optional)Preconditions.checkNotNull(secondChoice);
    }

    @Override
    @NonNull
    public T or(@NonNull Supplier<? extends T> supplier) {
        return (T)Preconditions.checkNotNull((Object)supplier.get(), (Object)"use Optional.orNull() instead of a Supplier that returns null");
    }

    @Override
    @Nullable
    public T orNull() {
        return null;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return 2040732332;
    }

    @Override
    @NonNull
    public String toString() {
        return "Optional.absent()";
    }

    private Object readResolve() {
        return sInstance;
    }
}

