/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class UseCaseAttachState {
    private static final String TAG = "UseCaseAttachState";
    private final String mCameraId;
    private final Map<String, UseCaseAttachInfo> mAttachedUseCasesToInfoMap = new LinkedHashMap<String, UseCaseAttachInfo>();

    public UseCaseAttachState(@NonNull String cameraId) {
        this.mCameraId = cameraId;
    }

    public void setUseCaseActive(@NonNull String useCaseId, @NonNull SessionConfig sessionConfig, @NonNull UseCaseConfig<?> useCaseConfig, @Nullable StreamSpec streamSpec, @Nullable List<UseCaseConfigFactory.CaptureType> captureTypes) {
        UseCaseAttachInfo useCaseAttachInfo = this.getOrCreateUseCaseAttachInfo(useCaseId, sessionConfig, useCaseConfig, streamSpec, captureTypes);
        useCaseAttachInfo.setActive(true);
    }

    public void setUseCaseInactive(@NonNull String useCaseId) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCaseId)) {
            return;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCaseId);
        useCaseAttachInfo.setActive(false);
        if (!useCaseAttachInfo.getAttached()) {
            this.mAttachedUseCasesToInfoMap.remove(useCaseId);
        }
    }

    public void setUseCaseAttached(@NonNull String useCaseId, @NonNull SessionConfig sessionConfig, @NonNull UseCaseConfig<?> useCaseConfig, @Nullable StreamSpec streamSpec, @Nullable List<UseCaseConfigFactory.CaptureType> captureTypes) {
        UseCaseAttachInfo useCaseAttachInfo = this.getOrCreateUseCaseAttachInfo(useCaseId, sessionConfig, useCaseConfig, streamSpec, captureTypes);
        useCaseAttachInfo.setAttached(true);
        this.updateUseCase(useCaseId, sessionConfig, useCaseConfig, streamSpec, captureTypes);
    }

    public void setUseCaseDetached(@NonNull String useCaseId) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCaseId)) {
            return;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCaseId);
        useCaseAttachInfo.setAttached(false);
        if (!useCaseAttachInfo.getActive()) {
            this.mAttachedUseCasesToInfoMap.remove(useCaseId);
        }
    }

    public boolean isUseCaseAttached(@NonNull String useCaseId) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCaseId)) {
            return false;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCaseId);
        return useCaseAttachInfo.getAttached();
    }

    @NonNull
    public Collection<UseCaseConfig<?>> getAttachedUseCaseConfigs() {
        return Collections.unmodifiableCollection(this.getUseCaseConfigs(useCaseAttachInfo -> useCaseAttachInfo.getAttached()));
    }

    @NonNull
    public Collection<SessionConfig> getAttachedSessionConfigs() {
        return Collections.unmodifiableCollection(this.getSessionConfigs(useCaseAttachInfo -> useCaseAttachInfo.getAttached()));
    }

    @NonNull
    public Collection<UseCaseAttachInfo> getAttachedUseCaseInfo() {
        return Collections.unmodifiableCollection(this.getUseCaseInfo(useCaseAttachInfo -> useCaseAttachInfo.getAttached()));
    }

    @NonNull
    public Collection<SessionConfig> getActiveAndAttachedSessionConfigs() {
        return Collections.unmodifiableCollection(this.getSessionConfigs(useCaseAttachInfo -> useCaseAttachInfo.getActive() && useCaseAttachInfo.getAttached()));
    }

    public void updateUseCase(@NonNull String useCaseId, @NonNull SessionConfig sessionConfig, @NonNull UseCaseConfig<?> useCaseConfig, @Nullable StreamSpec streamSpec, @Nullable List<UseCaseConfigFactory.CaptureType> captureTypes) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCaseId)) {
            return;
        }
        UseCaseAttachInfo newUseCaseAttachInfo = new UseCaseAttachInfo(sessionConfig, useCaseConfig, streamSpec, captureTypes);
        UseCaseAttachInfo oldUseCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCaseId);
        newUseCaseAttachInfo.setAttached(oldUseCaseAttachInfo.getAttached());
        newUseCaseAttachInfo.setActive(oldUseCaseAttachInfo.getActive());
        this.mAttachedUseCasesToInfoMap.put(useCaseId, newUseCaseAttachInfo);
    }

    public void removeUseCase(@NonNull String useCaseId) {
        this.mAttachedUseCasesToInfoMap.remove(useCaseId);
    }

    @NonNull
    public SessionConfig.ValidatingBuilder getActiveAndAttachedBuilder() {
        SessionConfig.ValidatingBuilder validatingBuilder = new SessionConfig.ValidatingBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            UseCaseAttachInfo useCaseAttachInfo = attachedUseCase.getValue();
            if (!useCaseAttachInfo.getActive() || !useCaseAttachInfo.getAttached()) continue;
            String useCaseId = attachedUseCase.getKey();
            validatingBuilder.add(useCaseAttachInfo.getSessionConfig());
            list.add(useCaseId);
        }
        Logger.d(TAG, "Active and attached use case: " + list + " for camera: " + this.mCameraId);
        return validatingBuilder;
    }

    @NonNull
    public SessionConfig.ValidatingBuilder getAttachedBuilder() {
        SessionConfig.ValidatingBuilder validatingBuilder = new SessionConfig.ValidatingBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            UseCaseAttachInfo useCaseAttachInfo = attachedUseCase.getValue();
            if (!useCaseAttachInfo.getAttached()) continue;
            validatingBuilder.add(useCaseAttachInfo.getSessionConfig());
            String useCaseId = attachedUseCase.getKey();
            list.add(useCaseId);
        }
        Logger.d(TAG, "All use case: " + list + " for camera: " + this.mCameraId);
        return validatingBuilder;
    }

    private UseCaseAttachInfo getOrCreateUseCaseAttachInfo(@NonNull String useCaseId, @NonNull SessionConfig sessionConfig, @NonNull UseCaseConfig<?> useCaseConfig, @Nullable StreamSpec streamSpec, @Nullable List<UseCaseConfigFactory.CaptureType> captureTypes) {
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCaseId);
        if (useCaseAttachInfo == null) {
            useCaseAttachInfo = new UseCaseAttachInfo(sessionConfig, useCaseConfig, streamSpec, captureTypes);
            this.mAttachedUseCasesToInfoMap.put(useCaseId, useCaseAttachInfo);
        }
        return useCaseAttachInfo;
    }

    private Collection<SessionConfig> getSessionConfigs(AttachStateFilter attachStateFilter) {
        ArrayList<SessionConfig> sessionConfigs = new ArrayList<SessionConfig>();
        for (Map.Entry<String, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            if (attachStateFilter != null && !attachStateFilter.filter(attachedUseCase.getValue())) continue;
            sessionConfigs.add(attachedUseCase.getValue().getSessionConfig());
        }
        return sessionConfigs;
    }

    private Collection<UseCaseConfig<?>> getUseCaseConfigs(AttachStateFilter attachStateFilter) {
        ArrayList useCaseConfigs = new ArrayList();
        for (Map.Entry<String, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            if (attachStateFilter != null && !attachStateFilter.filter(attachedUseCase.getValue())) continue;
            useCaseConfigs.add(attachedUseCase.getValue().getUseCaseConfig());
        }
        return useCaseConfigs;
    }

    private Collection<UseCaseAttachInfo> getUseCaseInfo(AttachStateFilter attachStateFilter) {
        ArrayList<UseCaseAttachInfo> useCaseAttachInfo = new ArrayList<UseCaseAttachInfo>();
        for (Map.Entry<String, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            if (attachStateFilter != null && !attachStateFilter.filter(attachedUseCase.getValue())) continue;
            useCaseAttachInfo.add(attachedUseCase.getValue());
        }
        return useCaseAttachInfo;
    }

    public static final class UseCaseAttachInfo {
        @NonNull
        private final SessionConfig mSessionConfig;
        @NonNull
        private final UseCaseConfig<?> mUseCaseConfig;
        @Nullable
        private final StreamSpec mStreamSpec;
        @Nullable
        private final List<UseCaseConfigFactory.CaptureType> mCaptureTypes;
        private boolean mAttached = false;
        private boolean mActive = false;

        UseCaseAttachInfo(@NonNull SessionConfig sessionConfig, @NonNull UseCaseConfig<?> useCaseConfig, @Nullable StreamSpec streamSpec, @Nullable List<UseCaseConfigFactory.CaptureType> captureTypes) {
            this.mSessionConfig = sessionConfig;
            this.mUseCaseConfig = useCaseConfig;
            this.mStreamSpec = streamSpec;
            this.mCaptureTypes = captureTypes;
        }

        @NonNull
        public UseCaseConfig<?> getUseCaseConfig() {
            return this.mUseCaseConfig;
        }

        @NonNull
        public SessionConfig getSessionConfig() {
            return this.mSessionConfig;
        }

        @Nullable
        public StreamSpec getStreamSpec() {
            return this.mStreamSpec;
        }

        @Nullable
        public List<UseCaseConfigFactory.CaptureType> getCaptureTypes() {
            return this.mCaptureTypes;
        }

        boolean getAttached() {
            return this.mAttached;
        }

        void setAttached(boolean attached) {
            this.mAttached = attached;
        }

        boolean getActive() {
            return this.mActive;
        }

        void setActive(boolean active) {
            this.mActive = active;
        }

        @NonNull
        public String toString() {
            return "UseCaseAttachInfo{mSessionConfig=" + this.mSessionConfig + ", mUseCaseConfig=" + this.mUseCaseConfig + ", mStreamSpec=" + this.mStreamSpec + ", mCaptureTypes=" + this.mCaptureTypes + ", mAttached=" + this.mAttached + ", mActive=" + this.mActive + '}';
        }
    }

    private static interface AttachStateFilter {
        public boolean filter(UseCaseAttachInfo var1);
    }
}

