/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.camera.core.impl.AutoValue_SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.internal.utils.SizeUtil;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class SurfaceConfig {
    public static final long DEFAULT_STREAM_USE_CASE_VALUE = 0L;

    SurfaceConfig() {
    }

    @NonNull
    public static SurfaceConfig create(@NonNull ConfigType type, @NonNull ConfigSize size) {
        return new AutoValue_SurfaceConfig(type, size, 0L);
    }

    @NonNull
    public static SurfaceConfig create(@NonNull ConfigType type, @NonNull ConfigSize size, long streamUseCase) {
        return new AutoValue_SurfaceConfig(type, size, streamUseCase);
    }

    @NonNull
    public abstract ConfigType getConfigType();

    @NonNull
    public abstract ConfigSize getConfigSize();

    public abstract long getStreamUseCase();

    public final boolean isSupported(@NonNull SurfaceConfig surfaceConfig) {
        boolean isSupported = false;
        ConfigType configType = surfaceConfig.getConfigType();
        ConfigSize configSize = surfaceConfig.getConfigSize();
        if (configSize.getId() <= this.getConfigSize().getId() && configType == this.getConfigType()) {
            isSupported = true;
        }
        return isSupported;
    }

    @NonNull
    public static ConfigType getConfigType(int imageFormat) {
        if (imageFormat == 35) {
            return ConfigType.YUV;
        }
        if (imageFormat == 256) {
            return ConfigType.JPEG;
        }
        if (imageFormat == 4101) {
            return ConfigType.JPEG_R;
        }
        if (imageFormat == 32) {
            return ConfigType.RAW;
        }
        return ConfigType.PRIV;
    }

    @NonNull
    public static SurfaceConfig transformSurfaceConfig(int cameraMode, int imageFormat, @NonNull Size size, @NonNull SurfaceSizeDefinition surfaceSizeDefinition) {
        ConfigType configType = SurfaceConfig.getConfigType(imageFormat);
        ConfigSize configSize = ConfigSize.NOT_SUPPORT;
        int sizeArea = SizeUtil.getArea(size);
        if (cameraMode == 1) {
            if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getS720pSize(imageFormat))) {
                configSize = ConfigSize.s720p;
            } else if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getS1440pSize(imageFormat))) {
                configSize = ConfigSize.s1440p;
            }
        } else if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getAnalysisSize())) {
            configSize = ConfigSize.VGA;
        } else if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getPreviewSize())) {
            configSize = ConfigSize.PREVIEW;
        } else if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getRecordSize())) {
            configSize = ConfigSize.RECORD;
        } else if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getMaximumSize(imageFormat))) {
            configSize = ConfigSize.MAXIMUM;
        } else {
            Size ultraMaximumSize = surfaceSizeDefinition.getUltraMaximumSize(imageFormat);
            if (ultraMaximumSize != null && sizeArea <= SizeUtil.getArea(ultraMaximumSize)) {
                configSize = ConfigSize.ULTRA_MAXIMUM;
            }
        }
        return SurfaceConfig.create(configType, configSize);
    }

    public static enum ConfigType {
        PRIV,
        YUV,
        JPEG,
        JPEG_R,
        RAW;

    }

    public static enum ConfigSize {
        VGA(0),
        s720p(1),
        PREVIEW(2),
        s1440p(3),
        RECORD(4),
        MAXIMUM(5),
        ULTRA_MAXIMUM(6),
        NOT_SUPPORT(7);

        final int mId;

        private ConfigSize(int id) {
            this.mId = id;
        }

        int getId() {
            return this.mId;
        }
    }
}

