/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.MutableStateObservable;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.QuirkSettings;
import androidx.core.util.Consumer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

public final class QuirkSettingsHolder {
    public static final QuirkSettings DEFAULT = QuirkSettings.withDefaultBehavior();
    private static final QuirkSettingsHolder sInstance = new QuirkSettingsHolder();
    private final MutableStateObservable<QuirkSettings> mObservable = MutableStateObservable.withInitialState(DEFAULT);

    @NonNull
    public static QuirkSettingsHolder instance() {
        return sInstance;
    }

    @NonNull
    public QuirkSettings get() {
        try {
            return (QuirkSettings)this.mObservable.fetchData().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError("Unexpected error in QuirkSettings StateObservable", e);
        }
    }

    public void set(@NonNull QuirkSettings settings) {
        this.mObservable.setState(settings);
    }

    public void observe(@NonNull Executor executor, @NonNull Consumer<QuirkSettings> listener) {
        this.mObservable.addObserver(executor, new ObserverToConsumerAdapter<QuirkSettings>(listener));
    }

    @VisibleForTesting
    public void reset() {
        this.mObservable.removeObservers();
        this.mObservable.setState(DEFAULT);
    }

    private static class ObserverToConsumerAdapter<T>
    implements Observable.Observer<T> {
        private static final String TAG = "ObserverToConsumerAdapter";
        private final Consumer<T> mDelegate;

        ObserverToConsumerAdapter(@NonNull Consumer<T> delegate) {
            this.mDelegate = delegate;
        }

        @Override
        public void onNewData(@Nullable T newValue) {
            this.mDelegate.accept(newValue);
        }

        @Override
        public void onError(@NonNull Throwable t) {
            Logger.e(TAG, "Unexpected error in Observable", t);
        }
    }
}

