/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.Identifier;
import androidx.camera.core.impl.ReadableConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.UseCaseConfigFactory;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface CameraConfig
extends ReadableConfig {
    public static final Config.Option<UseCaseConfigFactory> OPTION_USECASE_CONFIG_FACTORY = Config.Option.create("camerax.core.camera.useCaseConfigFactory", UseCaseConfigFactory.class);
    public static final Config.Option<Identifier> OPTION_COMPATIBILITY_ID = Config.Option.create("camerax.core.camera.compatibilityId", Identifier.class);
    public static final Config.Option<Integer> OPTION_USE_CASE_COMBINATION_REQUIRED_RULE = Config.Option.create("camerax.core.camera.useCaseCombinationRequiredRule", Integer.class);
    public static final Config.Option<SessionProcessor> OPTION_SESSION_PROCESSOR = Config.Option.create("camerax.core.camera.SessionProcessor", SessionProcessor.class);
    public static final Config.Option<Boolean> OPTION_ZSL_DISABLED = Config.Option.create("camerax.core.camera.isZslDisabled", Boolean.class);
    public static final Config.Option<Boolean> OPTION_POSTVIEW_SUPPORTED = Config.Option.create("camerax.core.camera.isPostviewSupported", Boolean.class);
    public static final Config.Option<Boolean> OPTION_CAPTURE_PROCESS_PROGRESS_SUPPORTED = Config.Option.create("camerax.core.camera.isCaptureProcessProgressSupported", Boolean.class);
    public static final int REQUIRED_RULE_NONE = 0;
    public static final int REQUIRED_RULE_COEXISTING_PREVIEW_AND_IMAGE_CAPTURE = 1;

    @NonNull
    default public UseCaseConfigFactory getUseCaseConfigFactory() {
        return this.retrieveOption(OPTION_USECASE_CONFIG_FACTORY, UseCaseConfigFactory.EMPTY_INSTANCE);
    }

    @NonNull
    public Identifier getCompatibilityId();

    default public int getUseCaseCombinationRequiredRule() {
        return this.retrieveOption(OPTION_USE_CASE_COMBINATION_REQUIRED_RULE, 0);
    }

    @Nullable
    default public SessionProcessor getSessionProcessor(@Nullable SessionProcessor valueIfMissing) {
        return this.retrieveOption(OPTION_SESSION_PROCESSOR, valueIfMissing);
    }

    default public boolean isPostviewSupported() {
        return this.retrieveOption(OPTION_POSTVIEW_SUPPORTED, false);
    }

    default public boolean isCaptureProcessProgressSupported() {
        return this.retrieveOption(OPTION_CAPTURE_PROCESS_PROGRESS_SUPPORTED, false);
    }

    @NonNull
    default public SessionProcessor getSessionProcessor() {
        return this.retrieveOption(OPTION_SESSION_PROCESSOR);
    }

    public static interface Builder<B> {
        @NonNull
        public B setUseCaseConfigFactory(@NonNull UseCaseConfigFactory var1);

        @NonNull
        public B setCompatibilityId(@NonNull Identifier var1);

        @NonNull
        public B setUseCaseCombinationRequiredRule(int var1);

        @NonNull
        public B setSessionProcessor(@NonNull SessionProcessor var1);

        @NonNull
        public B setZslDisabled(boolean var1);

        public B setPostviewSupported(boolean var1);

        public B setCaptureProcessProgressSupported(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequiredRule {
    }
}

