/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import java.io.IOException;
import java.util.Objects;

final class JpegBytes2CroppedBitmap
implements Operation<Packet<byte[]>, Packet<Bitmap>> {
    JpegBytes2CroppedBitmap() {
    }

    @Override
    @NonNull
    public Packet<Bitmap> apply(@NonNull Packet<byte[]> packet) throws ImageCaptureException {
        Rect cropRect = packet.getCropRect();
        Bitmap bitmap = this.createCroppedBitmap(packet.getData(), cropRect);
        return Packet.of(bitmap, Objects.requireNonNull(packet.getExif()), new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()), packet.getRotationDegrees(), TransformUtils.updateSensorToBufferTransform(packet.getSensorToBufferTransform(), cropRect), packet.getCameraCaptureResult());
    }

    @NonNull
    private Bitmap createCroppedBitmap(@NonNull byte[] jpegBytes, @NonNull Rect cropRect) throws ImageCaptureException {
        BitmapRegionDecoder decoder;
        try {
            decoder = BitmapRegionDecoder.newInstance((byte[])jpegBytes, (int)0, (int)jpegBytes.length, (boolean)false);
        }
        catch (IOException e) {
            throw new ImageCaptureException(1, "Failed to decode JPEG.", e);
        }
        return decoder.decodeRegion(cropRect, new BitmapFactory.Options());
    }
}

