/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.concurrent;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public interface CameraCoordinator {
    public static final int CAMERA_OPERATING_MODE_UNSPECIFIED = 0;
    public static final int CAMERA_OPERATING_MODE_SINGLE = 1;
    public static final int CAMERA_OPERATING_MODE_CONCURRENT = 2;

    @NonNull
    public List<List<CameraSelector>> getConcurrentCameraSelectors();

    @NonNull
    public List<CameraInfo> getActiveConcurrentCameraInfos();

    public void setActiveConcurrentCameraInfos(@NonNull List<CameraInfo> var1);

    @Nullable
    public String getPairedConcurrentCameraId(@NonNull String var1);

    public int getCameraOperatingMode();

    public void setCameraOperatingMode(int var1);

    public void addListener(@NonNull ConcurrentCameraModeListener var1);

    public void removeListener(@NonNull ConcurrentCameraModeListener var1);

    public void shutdown();

    public static interface ConcurrentCameraModeListener {
        public void onCameraOperatingModeUpdated(int var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface CameraOperatingMode {
    }
}

