/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.AutoValue_SurfaceOutput_CameraInputInfo;
import androidx.camera.core.AutoValue_SurfaceOutput_Event;
import androidx.camera.core.impl.CameraInternal;
import androidx.core.util.Consumer;
import com.google.auto.value.AutoValue;
import java.io.Closeable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public interface SurfaceOutput
extends Closeable {
    @NonNull
    public Surface getSurface(@NonNull Executor var1, @NonNull Consumer<Event> var2);

    public int getTargets();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    default public int getFormat() {
        return 34;
    }

    @NonNull
    public Size getSize();

    @Override
    public void close();

    public void updateTransformMatrix(@NonNull float[] var1, @NonNull float[] var2);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    default public void updateTransformMatrix(@NonNull float[] updated, @NonNull float[] original, boolean isPrimary) {
    }

    @NonNull
    default public Matrix getSensorToBufferTransform() {
        return new Matrix();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @AutoValue
    public static abstract class CameraInputInfo {
        @NonNull
        public abstract Size getInputSize();

        @NonNull
        public abstract Rect getInputCropRect();

        @Nullable
        public abstract CameraInternal getCameraInternal();

        public abstract int getRotationDegrees();

        public abstract boolean getMirroring();

        @NonNull
        public static CameraInputInfo of(@NonNull Size inputSize, @NonNull Rect inputCropRect, @Nullable CameraInternal cameraInternal, int rotationDegrees, boolean mirroring) {
            return new AutoValue_SurfaceOutput_CameraInputInfo(inputSize, inputCropRect, cameraInternal, rotationDegrees, mirroring);
        }
    }

    @AutoValue
    public static abstract class Event {
        public static final int EVENT_REQUEST_CLOSE = 0;

        Event() {
        }

        public abstract int getEventCode();

        @NonNull
        public abstract SurfaceOutput getSurfaceOutput();

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Event of(int code, @NonNull SurfaceOutput surfaceOutput) {
            return new AutoValue_SurfaceOutput_Event(code, surfaceOutput);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface EventCode {
        }
    }
}

