/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.LayoutSettings;
import androidx.camera.core.UseCaseGroup;
import androidx.lifecycle.LifecycleOwner;
import java.util.List;

public class ConcurrentCamera {
    @NonNull
    private List<Camera> mCameras;

    public ConcurrentCamera(@NonNull List<Camera> cameras) {
        this.mCameras = cameras;
    }

    @NonNull
    public List<Camera> getCameras() {
        return this.mCameras;
    }

    public static final class SingleCameraConfig {
        @NonNull
        private CameraSelector mCameraSelector;
        @NonNull
        private LifecycleOwner mLifecycleOwner;
        @NonNull
        private UseCaseGroup mUseCaseGroup;
        @NonNull
        private LayoutSettings mLayoutSettings;

        public SingleCameraConfig(@NonNull CameraSelector cameraSelector, @NonNull UseCaseGroup useCaseGroup, @NonNull LifecycleOwner lifecycleOwner) {
            this(cameraSelector, useCaseGroup, LayoutSettings.DEFAULT, lifecycleOwner);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public SingleCameraConfig(@NonNull CameraSelector cameraSelector, @NonNull UseCaseGroup useCaseGroup, @NonNull LayoutSettings layoutSettings, @NonNull LifecycleOwner lifecycleOwner) {
            this.mCameraSelector = cameraSelector;
            this.mUseCaseGroup = useCaseGroup;
            this.mLayoutSettings = layoutSettings;
            this.mLifecycleOwner = lifecycleOwner;
        }

        @NonNull
        public CameraSelector getCameraSelector() {
            return this.mCameraSelector;
        }

        @NonNull
        public LifecycleOwner getLifecycleOwner() {
            return this.mLifecycleOwner;
        }

        @NonNull
        public UseCaseGroup getUseCaseGroup() {
            return this.mUseCaseGroup;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public LayoutSettings getLayoutSettings() {
            return this.mLayoutSettings;
        }
    }
}

