/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Matrix;
import androidx.annotation.NonNull;
import androidx.camera.core.ImmutableImageInfo;
import androidx.camera.core.impl.TagBundle;

final class AutoValue_ImmutableImageInfo
extends ImmutableImageInfo {
    private final TagBundle tagBundle;
    private final long timestamp;
    private final int rotationDegrees;
    private final Matrix sensorToBufferTransformMatrix;

    AutoValue_ImmutableImageInfo(TagBundle tagBundle, long timestamp, int rotationDegrees, Matrix sensorToBufferTransformMatrix) {
        if (tagBundle == null) {
            throw new NullPointerException("Null tagBundle");
        }
        this.tagBundle = tagBundle;
        this.timestamp = timestamp;
        this.rotationDegrees = rotationDegrees;
        if (sensorToBufferTransformMatrix == null) {
            throw new NullPointerException("Null sensorToBufferTransformMatrix");
        }
        this.sensorToBufferTransformMatrix = sensorToBufferTransformMatrix;
    }

    @Override
    @NonNull
    public TagBundle getTagBundle() {
        return this.tagBundle;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getRotationDegrees() {
        return this.rotationDegrees;
    }

    @Override
    @NonNull
    public Matrix getSensorToBufferTransformMatrix() {
        return this.sensorToBufferTransformMatrix;
    }

    public String toString() {
        return "ImmutableImageInfo{tagBundle=" + this.tagBundle + ", timestamp=" + this.timestamp + ", rotationDegrees=" + this.rotationDegrees + ", sensorToBufferTransformMatrix=" + this.sensorToBufferTransformMatrix + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableImageInfo) {
            ImmutableImageInfo that = (ImmutableImageInfo)o;
            return this.tagBundle.equals(that.getTagBundle()) && this.timestamp == that.getTimestamp() && this.rotationDegrees == that.getRotationDegrees() && this.sensorToBufferTransformMatrix.equals((Object)that.getSensorToBufferTransformMatrix());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.tagBundle.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.timestamp >>> 32 ^ this.timestamp);
        h$ *= 1000003;
        h$ ^= this.rotationDegrees;
        h$ *= 1000003;
        return h$ ^= this.sensorToBufferTransformMatrix.hashCode();
    }
}

