/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.graphics.Rect;
import android.graphics.RectF;
import android.opengl.Matrix;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.AnyThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.utils.MatrixExt;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;

final class SurfaceOutputImpl
implements SurfaceOutput {
    private static final String TAG = "SurfaceOutputImpl";
    private final Object mLock = new Object();
    @NonNull
    private final Surface mSurface;
    private final int mTargets;
    private final int mFormat;
    @NonNull
    private final Size mSize;
    @NonNull
    private final SurfaceOutput.CameraInputInfo mCameraInputInfo;
    @Nullable
    private final SurfaceOutput.CameraInputInfo mSecondaryCameraInputInfo;
    @NonNull
    private final float[] mAdditionalTransform = new float[16];
    @NonNull
    private final float[] mSecondaryAdditionalTransform = new float[16];
    @NonNull
    private final float[] mInvertedTextureTransform = new float[16];
    @NonNull
    private final float[] mSecondaryInvertedTextureTransform = new float[16];
    @GuardedBy(value="mLock")
    @Nullable
    private Consumer<SurfaceOutput.Event> mEventListener;
    @GuardedBy(value="mLock")
    @Nullable
    private Executor mExecutor;
    @GuardedBy(value="mLock")
    private boolean mHasPendingCloseRequest = false;
    @GuardedBy(value="mLock")
    private boolean mIsClosed = false;
    @NonNull
    private final ListenableFuture<Void> mCloseFuture;
    private CallbackToFutureAdapter.Completer<Void> mCloseFutureCompleter;
    @NonNull
    private android.graphics.Matrix mSensorToBufferTransform;

    SurfaceOutputImpl(@NonNull Surface surface, int targets, int format, @NonNull Size size, @NonNull SurfaceOutput.CameraInputInfo primaryCameraInputInfo, @Nullable SurfaceOutput.CameraInputInfo secondaryCameraInputInfo, @NonNull android.graphics.Matrix sensorToBufferTransform) {
        this.mSurface = surface;
        this.mTargets = targets;
        this.mFormat = format;
        this.mSize = size;
        this.mCameraInputInfo = primaryCameraInputInfo;
        this.mSecondaryCameraInputInfo = secondaryCameraInputInfo;
        this.mSensorToBufferTransform = sensorToBufferTransform;
        SurfaceOutputImpl.calculateAdditionalTransform(this.mAdditionalTransform, this.mInvertedTextureTransform, this.mCameraInputInfo);
        SurfaceOutputImpl.calculateAdditionalTransform(this.mSecondaryAdditionalTransform, this.mSecondaryInvertedTextureTransform, this.mSecondaryCameraInputInfo);
        this.mCloseFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mCloseFutureCompleter = completer;
            return "SurfaceOutputImpl close future complete";
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Surface getSurface(@NonNull Executor executor, @NonNull Consumer<SurfaceOutput.Event> listener) {
        boolean hasPendingCloseRequest;
        Object object = this.mLock;
        synchronized (object) {
            this.mExecutor = executor;
            this.mEventListener = listener;
            hasPendingCloseRequest = this.mHasPendingCloseRequest;
        }
        if (hasPendingCloseRequest) {
            this.requestClose();
        }
        return this.mSurface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClose() {
        AtomicReference<Consumer<SurfaceOutput.Event>> eventListenerRef = new AtomicReference<Consumer<SurfaceOutput.Event>>();
        Executor executor = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mExecutor == null || this.mEventListener == null) {
                this.mHasPendingCloseRequest = true;
            } else if (!this.mIsClosed) {
                eventListenerRef.set(this.mEventListener);
                executor = this.mExecutor;
                this.mHasPendingCloseRequest = false;
            }
        }
        if (executor != null) {
            try {
                executor.execute(() -> ((Consumer)eventListenerRef.get()).accept((Object)SurfaceOutput.Event.of(0, this)));
            }
            catch (RejectedExecutionException e) {
                Logger.d(TAG, "Processor executor closed. Close request not posted.", e);
            }
        }
    }

    @Override
    public int getTargets() {
        return this.mTargets;
    }

    @Override
    public int getFormat() {
        return this.mFormat;
    }

    @Override
    @NonNull
    public Size getSize() {
        return this.mSize;
    }

    @VisibleForTesting
    public Rect getInputCropRect() {
        return this.mCameraInputInfo.getInputCropRect();
    }

    @VisibleForTesting
    public Size getInputSize() {
        return this.mCameraInputInfo.getInputSize();
    }

    @VisibleForTesting
    public int getRotationDegrees() {
        return this.mCameraInputInfo.getRotationDegrees();
    }

    @VisibleForTesting
    public boolean isMirroring() {
        return this.mCameraInputInfo.getMirroring();
    }

    @VisibleForTesting
    @Nullable
    public CameraInternal getCamera() {
        return this.mCameraInputInfo.getCameraInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsClosed) {
                this.mIsClosed = true;
            }
        }
        this.mCloseFutureCompleter.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isClosed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsClosed;
        }
    }

    @NonNull
    public ListenableFuture<Void> getCloseFuture() {
        return this.mCloseFuture;
    }

    @Override
    @AnyThread
    public void updateTransformMatrix(@NonNull float[] output, @NonNull float[] input) {
        this.updateTransformMatrix(output, input, true);
    }

    @Override
    @AnyThread
    public void updateTransformMatrix(@NonNull float[] output, @NonNull float[] input, boolean isPrimary) {
        Matrix.multiplyMM((float[])output, (int)0, (float[])input, (int)0, (float[])(isPrimary ? this.mAdditionalTransform : this.mSecondaryAdditionalTransform), (int)0);
    }

    @Override
    @NonNull
    public android.graphics.Matrix getSensorToBufferTransform() {
        return new android.graphics.Matrix(this.mSensorToBufferTransform);
    }

    private static void calculateAdditionalTransform(@NonNull float[] additionalTransform, @NonNull float[] invertedTransform, @Nullable SurfaceOutput.CameraInputInfo cameraInputInfo) {
        Matrix.setIdentityM((float[])additionalTransform, (int)0);
        if (cameraInputInfo == null) {
            return;
        }
        MatrixExt.preVerticalFlip(additionalTransform, 0.5f);
        MatrixExt.preRotate(additionalTransform, cameraInputInfo.getRotationDegrees(), 0.5f, 0.5f);
        if (cameraInputInfo.getMirroring()) {
            Matrix.translateM((float[])additionalTransform, (int)0, (float)1.0f, (float)0.0f, (float)0.0f);
            Matrix.scaleM((float[])additionalTransform, (int)0, (float)-1.0f, (float)1.0f, (float)1.0f);
        }
        Size rotatedSize = TransformUtils.rotateSize(cameraInputInfo.getInputSize(), cameraInputInfo.getRotationDegrees());
        android.graphics.Matrix imageTransform = TransformUtils.getRectToRect(TransformUtils.sizeToRectF(cameraInputInfo.getInputSize()), TransformUtils.sizeToRectF(rotatedSize), cameraInputInfo.getRotationDegrees(), cameraInputInfo.getMirroring());
        RectF rotatedCroppedRect = new RectF(cameraInputInfo.getInputCropRect());
        imageTransform.mapRect(rotatedCroppedRect);
        float offsetX = rotatedCroppedRect.left / (float)rotatedSize.getWidth();
        float offsetY = ((float)rotatedSize.getHeight() - rotatedCroppedRect.height() - rotatedCroppedRect.top) / (float)rotatedSize.getHeight();
        float scaleX = rotatedCroppedRect.width() / (float)rotatedSize.getWidth();
        float scaleY = rotatedCroppedRect.height() / (float)rotatedSize.getHeight();
        Matrix.translateM((float[])additionalTransform, (int)0, (float)offsetX, (float)offsetY, (float)0.0f);
        Matrix.scaleM((float[])additionalTransform, (int)0, (float)scaleX, (float)scaleY, (float)1.0f);
        SurfaceOutputImpl.calculateInvertedTextureTransform(invertedTransform, cameraInputInfo.getCameraInternal());
        Matrix.multiplyMM((float[])additionalTransform, (int)0, (float[])invertedTransform, (int)0, (float[])additionalTransform, (int)0);
    }

    private static void calculateInvertedTextureTransform(@NonNull float[] invertedTextureTransform, @Nullable CameraInternal cameraInternal) {
        Matrix.setIdentityM((float[])invertedTextureTransform, (int)0);
        MatrixExt.preVerticalFlip(invertedTextureTransform, 0.5f);
        if (cameraInternal != null) {
            Preconditions.checkState((boolean)cameraInternal.getHasTransform(), (String)"Camera has no transform.");
            MatrixExt.preRotate(invertedTextureTransform, cameraInternal.getCameraInfo().getSensorRotationDegrees(), 0.5f, 0.5f);
            if (cameraInternal.isFrontFacing()) {
                Matrix.translateM((float[])invertedTextureTransform, (int)0, (float)1.0f, (float)0.0f, (float)0.0f);
                Matrix.scaleM((float[])invertedTextureTransform, (int)0, (float)-1.0f, (float)1.0f, (float)1.0f);
            }
        }
        Matrix.invertM((float[])invertedTextureTransform, (int)0, (float[])invertedTextureTransform, (int)0);
    }
}

