/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.quirk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.QuirkSettings;
import androidx.camera.core.impl.QuirkSettingsHolder;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.compat.quirk.DeviceQuirksLoader;
import androidx.core.util.Consumer;

public class DeviceQuirks {
    private static final String TAG = "DeviceQuirks";
    @NonNull
    private static volatile Quirks sQuirks;

    private DeviceQuirks() {
    }

    @NonNull
    public static Quirks getAll() {
        return sQuirks;
    }

    @Nullable
    public static <T extends Quirk> T get(@NonNull Class<T> quirkClass) {
        return sQuirks.get(quirkClass);
    }

    static {
        QuirkSettingsHolder.instance().observe(CameraXExecutors.directExecutor(), (Consumer<QuirkSettings>)((Consumer)quirkSettings -> {
            sQuirks = new Quirks(DeviceQuirksLoader.loadQuirks(quirkSettings));
            Logger.d(TAG, "core DeviceQuirks = " + Quirks.toString(sQuirks));
        }));
    }
}

