/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.utils.Optional;
import androidx.core.util.Preconditions;
import androidx.core.util.Supplier;

final class Present<T>
extends Optional<T> {
    private final T mReference;
    private static final long serialVersionUID = 0L;

    Present(T reference) {
        this.mReference = reference;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    @NonNull
    public T get() {
        return this.mReference;
    }

    @Override
    @NonNull
    public T or(@NonNull T defaultValue) {
        Preconditions.checkNotNull(defaultValue, (Object)"use Optional.orNull() instead of Optional.or(null)");
        return this.mReference;
    }

    @Override
    @NonNull
    public Optional<T> or(@NonNull Optional<? extends T> secondChoice) {
        Preconditions.checkNotNull(secondChoice);
        return this;
    }

    @Override
    @NonNull
    public T or(@NonNull Supplier<? extends T> supplier) {
        Preconditions.checkNotNull(supplier);
        return this.mReference;
    }

    @Override
    public T orNull() {
        return this.mReference;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Present) {
            Present other = (Present)object;
            return this.mReference.equals(other.mReference);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 1502476572 + this.mReference.hashCode();
    }

    @Override
    @NonNull
    public String toString() {
        return "Optional.of(" + this.mReference + ")";
    }
}

