/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.os.Build;
import android.util.CloseGuard;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;

public final class CloseGuardHelper {
    private final CloseGuardImpl mImpl;

    private CloseGuardHelper(CloseGuardImpl impl) {
        this.mImpl = impl;
    }

    @NonNull
    public static CloseGuardHelper create() {
        if (Build.VERSION.SDK_INT >= 30) {
            return new CloseGuardHelper(new CloseGuardApi30Impl());
        }
        return new CloseGuardHelper(new CloseGuardNoOpImpl());
    }

    public void open(@NonNull String closeMethodName) {
        this.mImpl.open(closeMethodName);
    }

    public void close() {
        this.mImpl.close();
    }

    public void warnIfOpen() {
        this.mImpl.warnIfOpen();
    }

    private static interface CloseGuardImpl {
        public void open(@NonNull String var1);

        public void close();

        public void warnIfOpen();
    }

    @RequiresApi(value=30)
    static final class CloseGuardApi30Impl
    implements CloseGuardImpl {
        private final CloseGuard mPlatformImpl = new CloseGuard();

        CloseGuardApi30Impl() {
        }

        @Override
        public void open(@NonNull String closeMethodName) {
            this.mPlatformImpl.open(closeMethodName);
        }

        @Override
        public void close() {
            this.mPlatformImpl.close();
        }

        @Override
        public void warnIfOpen() {
            this.mPlatformImpl.warnIfOpen();
        }
    }

    static final class CloseGuardNoOpImpl
    implements CloseGuardImpl {
        CloseGuardNoOpImpl() {
        }

        @Override
        public void open(@NonNull String closeMethodName) {
            Preconditions.checkNotNull((Object)closeMethodName, (Object)"CloseMethodName must not be null.");
        }

        @Override
        public void close() {
        }

        @Override
        public void warnIfOpen() {
        }
    }
}

