/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.camera.core.ExperimentalRetryPolicy;
import androidx.camera.core.RetryPolicy;
import androidx.core.util.Preconditions;

@ExperimentalRetryPolicy
public final class TimeoutRetryPolicy
implements RetryPolicy {
    private final long mTimeoutInMillis;
    private final RetryPolicy mDelegatePolicy;

    public TimeoutRetryPolicy(long timeoutInMillis, @NonNull RetryPolicy delegatePolicy) {
        Preconditions.checkArgument((timeoutInMillis >= 0L ? 1 : 0) != 0, (Object)"Timeout must be non-negative.");
        this.mTimeoutInMillis = timeoutInMillis;
        this.mDelegatePolicy = delegatePolicy;
    }

    @Override
    @NonNull
    public RetryPolicy.RetryConfig onRetryDecisionRequested(@NonNull RetryPolicy.ExecutionState executionState) {
        RetryPolicy.RetryConfig retryConfig = this.mDelegatePolicy.onRetryDecisionRequested(executionState);
        return this.getTimeoutInMillis() > 0L && executionState.getExecutedTimeInMillis() >= this.getTimeoutInMillis() - retryConfig.getRetryDelayInMillis() ? RetryPolicy.RetryConfig.NOT_RETRY : retryConfig;
    }

    @Override
    public long getTimeoutInMillis() {
        return this.mTimeoutInMillis;
    }
}

