/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ExposureState;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.ForwardingCameraInfo;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.utils.SessionProcessorUtil;
import androidx.camera.core.internal.ImmutableZoomState;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RestrictedCameraInfo
extends ForwardingCameraInfo {
    public static final int CAMERA_OPERATION_ZOOM = 0;
    public static final int CAMERA_OPERATION_AUTO_FOCUS = 1;
    public static final int CAMERA_OPERATION_AF_REGION = 2;
    public static final int CAMERA_OPERATION_AE_REGION = 3;
    public static final int CAMERA_OPERATION_AWB_REGION = 4;
    public static final int CAMERA_OPERATION_FLASH = 5;
    public static final int CAMERA_OPERATION_TORCH = 6;
    public static final int CAMERA_OPERATION_EXPOSURE_COMPENSATION = 7;
    public static final int CAMERA_OPERATION_EXTENSION_STRENGTH = 8;
    private final CameraInfoInternal mCameraInfo;
    @Nullable
    private final SessionProcessor mSessionProcessor;
    private boolean mIsPostviewSupported = false;
    private boolean mIsCaptureProcessProgressSupported = false;
    @NonNull
    private final CameraConfig mCameraConfig;

    public RestrictedCameraInfo(@NonNull CameraInfoInternal cameraInfo, @NonNull CameraConfig cameraConfig) {
        super(cameraInfo);
        this.mCameraInfo = cameraInfo;
        this.mCameraConfig = cameraConfig;
        this.mSessionProcessor = cameraConfig.getSessionProcessor(null);
        this.setPostviewSupported(cameraConfig.isPostviewSupported());
        this.setCaptureProcessProgressSupported(cameraConfig.isCaptureProcessProgressSupported());
    }

    @NonNull
    public CameraConfig getCameraConfig() {
        return this.mCameraConfig;
    }

    @Override
    @NonNull
    public CameraInfoInternal getImplementation() {
        return this.mCameraInfo;
    }

    @Nullable
    public SessionProcessor getSessionProcessor() {
        return this.mSessionProcessor;
    }

    @Override
    public boolean hasFlashUnit() {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 5)) {
            return false;
        }
        return this.mCameraInfo.hasFlashUnit();
    }

    @Override
    @NonNull
    public LiveData<Integer> getTorchState() {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 6)) {
            return new MutableLiveData((Object)0);
        }
        return this.mCameraInfo.getTorchState();
    }

    @Override
    @NonNull
    public LiveData<ZoomState> getZoomState() {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 0)) {
            return new MutableLiveData((Object)ImmutableZoomState.create(1.0f, 1.0f, 1.0f, 0.0f));
        }
        return this.mCameraInfo.getZoomState();
    }

    @Override
    @NonNull
    public ExposureState getExposureState() {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 7)) {
            return new ExposureState(){

                @Override
                public int getExposureCompensationIndex() {
                    return 0;
                }

                @Override
                @NonNull
                public Range<Integer> getExposureCompensationRange() {
                    return new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
                }

                @Override
                @NonNull
                public Rational getExposureCompensationStep() {
                    return Rational.ZERO;
                }

                @Override
                public boolean isExposureCompensationSupported() {
                    return false;
                }
            };
        }
        return this.mCameraInfo.getExposureState();
    }

    @Override
    public boolean isFocusMeteringSupported(@NonNull FocusMeteringAction action) {
        FocusMeteringAction modifiedAction = SessionProcessorUtil.getModifiedFocusMeteringAction(this.mSessionProcessor, action);
        if (modifiedAction == null) {
            return false;
        }
        return this.mCameraInfo.isFocusMeteringSupported(modifiedAction);
    }

    public void setPostviewSupported(boolean isPostviewSupported) {
        this.mIsPostviewSupported = isPostviewSupported;
    }

    public void setCaptureProcessProgressSupported(boolean isCaptureProcessProgressSupported) {
        this.mIsCaptureProcessProgressSupported = isCaptureProcessProgressSupported;
    }

    @Override
    public boolean isPostviewSupported() {
        return this.mIsPostviewSupported;
    }

    @Override
    public boolean isCaptureProcessProgressSupported() {
        return this.mIsCaptureProcessProgressSupported;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CameraOperation {
    }
}

